/*
 * Decompiled with CFR 0.152.
 */
package bruma.utils;

import java.util.GregorianCalendar;

public class TimeString {
    private static final int YEAR = 31104000;
    private static final int MONTH = 2592000;
    private static final int WEEK = 604800;
    private static final int DAY = 86400;
    private static final int HOUR = 3600;
    private static final int MINUTE = 60;
    long beginTime = 0L;

    public void start() {
        this.beginTime = new GregorianCalendar().getTimeInMillis();
    }

    public String getTime() {
        if (this.beginTime == 0L) {
            throw new IllegalArgumentException("call to begin() function is required");
        }
        StringBuilder builder = new StringBuilder();
        long totalTimeMili = new GregorianCalendar().getTimeInMillis() - this.beginTime;
        long totalTime = totalTimeMili / 1000L;
        long miliseconds = totalTimeMili % 1000L;
        long years = totalTime / 31104000L;
        long months = (totalTime %= 31104000L) / 2592000L;
        long weeks = (totalTime %= 2592000L) / 604800L;
        long days = (totalTime %= 604800L) / 86400L;
        long hours = (totalTime %= 86400L) / 3600L;
        long minutes = (totalTime %= 3600L) / 60L;
        long seconds = totalTime %= 60L;
        if (years > 0L) {
            builder.append(years);
            builder.append(" year(s) ");
        }
        if (months > 0L) {
            builder.append(months);
            builder.append(" month(s) ");
        }
        if (weeks > 0L) {
            builder.append(weeks);
            builder.append(" week(s) ");
        }
        if (days > 0L) {
            builder.append(days);
            builder.append(" day(s) ");
        }
        if (hours > 0L) {
            builder.append(hours);
            builder.append(" hour(s) ");
        }
        if (minutes > 0L) {
            builder.append(minutes);
            builder.append(" minute(s) ");
        }
        if (seconds > 0L) {
            builder.append(seconds);
            builder.append(" second(s) ");
        }
        if (miliseconds > 0L) {
            builder.append(miliseconds);
            builder.append(" milisecond(s) ");
        }
        if (builder.length() == 0) {
            builder.append("0 milisecond(s) ");
        }
        return builder.toString().trim();
    }
}

