/*
 * Decompiled with CFR 0.152.
 */
package bruma.utils;

import bruma.BrumaException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.GregorianCalendar;

public final class Util {
    private Util() {
    }

    public static String changeFileExtension(String filename, String extension) throws BrumaException {
        String nameExt;
        int curpos;
        int nsize;
        char auxCh = '\u0000';
        String fname = filename;
        String ext = extension;
        if (fname == null) {
            throw new BrumaException("filename=null");
        }
        if (ext != null) {
            if ((ext = ext.trim()).length() == 0) {
                ext = null;
            } else if (ext.charAt(0) == '.') {
                ext = ext.substring(1);
            }
        }
        if ((nsize = (fname = fname.trim()).length()) == 0) {
            throw new BrumaException("filename=\"\"");
        }
        for (curpos = nsize - 1; curpos >= 0 && (auxCh = fname.charAt(curpos)) != '.' && auxCh != '/' && auxCh != '\\'; --curpos) {
        }
        if (curpos < 0) {
            nameExt = fname;
            if (ext != null) {
                nameExt = nameExt + "." + ext;
            }
        } else {
            if (curpos == 0) {
                throw new BrumaException(ext);
            }
            if (curpos == nsize - 1) {
                throw new BrumaException("invalid filename=[" + filename + "]");
            }
            if (auxCh == '/' || auxCh == '\\') {
                nameExt = fname;
                if (ext != null) {
                    nameExt = nameExt + "." + ext;
                }
            } else {
                nameExt = fname.substring(0, curpos);
                if (ext != null) {
                    nameExt = nameExt + "." + ext;
                }
            }
        }
        return nameExt;
    }

    public static String sTrace2Str(Exception exc) {
        String ret;
        if (exc == null) {
            ret = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream pStream = new PrintStream(baos);
            pStream.println(exc.getMessage());
            ret = baos.toString();
        }
        return ret;
    }

    public static String sayHello(String objectName) {
        String ret;
        try {
            InetAddress IAddr = InetAddress.getLocalHost();
            GregorianCalendar calendar = new GregorianCalendar();
            String hello = "Hello from a " + objectName + " object";
            String host = "host name = " + IAddr.getHostName();
            String address = "host address = " + IAddr.getHostAddress();
            String day = "day = " + calendar.get(5);
            String hour = "hour = " + calendar.get(11);
            String minute = "minute = " + calendar.get(12);
            String second = "second = " + calendar.get(13);
            ret = hello + "/n/n" + host + "/n" + address + "/n" + day + "/n" + hour + "/n" + minute + "/n" + second;
        }
        catch (Exception ex) {
            ret = ex.getMessage();
        }
        return ret;
    }

    public static String readParameters(String param) throws BrumaException {
        String ret = null;
        try {
            ret = param.trim();
            if (ret.charAt(0) == '@') {
                BufferedReader reader = new BufferedReader(new FileReader(ret.substring(1)));
                StringWriter writer = new StringWriter();
                int auxCh = 0;
                while ((auxCh = reader.read()) != -1) {
                    writer.write(auxCh);
                }
                writer.close();
                ret = writer.toString();
            }
        }
        catch (Exception ex) {
            throw new BrumaException(ex);
        }
        return ret;
    }
}

