/*
 * Decompiled with CFR 0.152.
 */
package bruma.utils;

import bruma.BrumaException;
import bruma.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeFDT {
    public static final String DEFAULT_EXTENSION = "fdt";
    private List<String> worksheets = new ArrayList<String>();
    private List<String> printFormats = new ArrayList<String>();
    private List<String> fieldSelections = new ArrayList<String>();
    private List<ZeFDTField> fieldDescriptions = new ArrayList<ZeFDTField>();

    public void addWorksheet(String worksheet) {
        String wsheet = null;
        if (worksheet == null) {
            throw new NullPointerException("addWorksheet/null worksheet");
        }
        wsheet = worksheet.trim();
        if (wsheet.length() == 0) {
            throw new IllegalArgumentException("addWorksheet/empty worksheet");
        }
        this.worksheets.add(wsheet);
    }

    public void clearWorksheets() {
        this.worksheets.clear();
    }

    public List<String> getWorksheets() {
        return new ArrayList<String>(this.worksheets);
    }

    public void addPrintFormats(String printFormat) {
        String prtFormat = null;
        if (printFormat == null) {
            throw new NullPointerException("addPrintFormats/null printFormat");
        }
        prtFormat = printFormat.trim();
        if (prtFormat.length() == 0) {
            throw new IllegalArgumentException("addPrintFormats/empty printFormat");
        }
        this.printFormats.add(prtFormat);
    }

    public void clearPrintFormats() {
        this.printFormats.clear();
    }

    public List<String> getPrintFormats() {
        return new ArrayList<String>(this.printFormats);
    }

    public void addFieldSelections(String fieldSelection) {
        String fldSelection = null;
        if (fieldSelection == null) {
            throw new NullPointerException("addFieldSelections/null fieldSelection");
        }
        fldSelection = fieldSelection.trim();
        if (fldSelection.length() == 0) {
            throw new IllegalArgumentException("addFieldSelections/empty fieldSelection");
        }
        this.fieldSelections.add(fldSelection);
    }

    public void clearFieldSelections() {
        this.fieldSelections.clear();
    }

    public List<String> getFieldSelections() {
        return new ArrayList<String>(this.fieldSelections);
    }

    public void addFieldDescription(ZeFDTField fieldDescription) {
        if (fieldDescription == null) {
            throw new NullPointerException("addFieldDescription/null fieldDescription");
        }
        this.fieldDescriptions.add(fieldDescription);
    }

    public void clearFieldDescriptions() {
        this.fieldDescriptions.clear();
    }

    public List<ZeFDTField> getFieldDescriptions() {
        return new ArrayList<ZeFDTField>(this.fieldDescriptions);
    }

    public Map<Integer, String> getFieldDescriptionMap() {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        for (ZeFDTField fld : this.fieldDescriptions) {
            ret.put(fld.getTag(), fld.getDescription());
        }
        return ret;
    }

    public ZeFDT fromFile(String fdtFile) throws BrumaException {
        int counter2;
        int curLine;
        if (fdtFile == null) {
            throw new NullPointerException("fromFile/null fdt file name");
        }
        String fileName = Util.changeFileExtension(fdtFile, DEFAULT_EXTENSION);
        String content = null;
        String[] lines = null;
        String line = null;
        String[] elems = null;
        if (!new File(fileName).isFile()) {
            throw new BrumaException("fromFile/file[" + fileName + "] is not a file");
        }
        try {
            content = this.readParameters(fileName);
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        lines = content.split("\\r?\\n");
        this.worksheets.clear();
        this.printFormats.clear();
        this.fieldSelections.clear();
        this.fieldDescriptions.clear();
        for (curLine = 0; curLine < lines.length && (line = lines[curLine]).startsWith("W:"); ++curLine) {
            elems = line.substring(2).split("\\s+");
            for (counter2 = 0; counter2 < elems.length; ++counter2) {
                this.worksheets.add(elems[counter2].trim());
            }
        }
        if (curLine == lines.length) {
            throw new IllegalArgumentException("fromFile/invalid file format");
        }
        while (curLine < lines.length && (line = lines[curLine]).startsWith("F:")) {
            elems = line.substring(2).split("\\s+");
            for (counter2 = 0; counter2 < elems.length; ++counter2) {
                this.printFormats.add(elems[counter2].trim());
            }
            ++curLine;
        }
        if (curLine == lines.length) {
            throw new IllegalArgumentException("fromFile/invalid file format");
        }
        while (curLine < lines.length && (line = lines[curLine]).startsWith("S:")) {
            elems = line.substring(2).split("\\s+");
            for (counter2 = 0; counter2 < elems.length; ++counter2) {
                this.fieldSelections.add(elems[counter2].trim());
            }
            ++curLine;
        }
        if (curLine == lines.length) {
            throw new IllegalArgumentException("fromFile/invalid file format");
        }
        if (line.compareTo("***") != 0) {
            throw new IllegalArgumentException("fromFile/invalid file format");
        }
        ++curLine;
        while (curLine < lines.length) {
            this.fieldDescriptions.add(new ZeFDTField().fromString(lines[curLine]));
            ++curLine;
        }
        return this;
    }

    public void toFile(String fdtFile) throws BrumaException {
        if (fdtFile == null) {
            throw new NullPointerException("toFile/null fdtFile name");
        }
        String collectionName = Util.changeFileExtension(fdtFile, DEFAULT_EXTENSION);
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(collectionName);
            fWriter.write(this.toString());
        }
        catch (IOException ioe) {
            throw new BrumaException(ioe);
        }
        finally {
            try {
                if (fWriter != null) {
                    fWriter.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        int cur = 0;
        Iterator<String> iterator = null;
        int maxSize = 0;
        if (!this.worksheets.isEmpty()) {
            iterator = this.worksheets.iterator();
            while (iterator.hasNext()) {
                if (cur == 8) {
                    sBuilder.append("\n");
                    cur = 0;
                }
                if (cur == 0) {
                    sBuilder.append("W:");
                }
                sBuilder.append(ZeFDT.paddingWhites(iterator.next(), 6));
                ++cur;
            }
            if (cur != 0) {
                sBuilder.append("\n");
            }
        }
        if (!this.printFormats.isEmpty()) {
            iterator = this.printFormats.iterator();
            while (iterator.hasNext()) {
                if (cur == 8) {
                    sBuilder.append("\n");
                    cur = 0;
                }
                if (cur == 0) {
                    sBuilder.append("F:");
                }
                sBuilder.append(ZeFDT.paddingWhites(iterator.next(), 6));
                ++cur;
            }
            if (cur != 0) {
                sBuilder.append("\n");
            }
        }
        if (!this.fieldSelections.isEmpty()) {
            iterator = this.fieldSelections.iterator();
            while (iterator.hasNext()) {
                if (cur == 8) {
                    sBuilder.append("\n");
                    cur = 0;
                }
                if (cur == 0) {
                    sBuilder.append("S:");
                }
                sBuilder.append(ZeFDT.paddingWhites(iterator.next(), 6));
                ++cur;
            }
            if (cur != 0) {
                sBuilder.append("\n");
            }
        }
        sBuilder.append("***");
        for (ZeFDTField field : this.fieldDescriptions) {
            maxSize = Math.max(maxSize, field.getFormat().length());
        }
        for (ZeFDTField field : this.fieldDescriptions) {
            sBuilder.append("\n");
            sBuilder.append(field.toString(maxSize));
        }
        return sBuilder.toString();
    }

    static String paddingWhites(String in, int outSize) {
        assert (in != null) : "paddingWhites/null in";
        assert (outSize > 0) : "paddingWhites/outSize <= 0";
        String ret = in;
        if (in.length() < outSize) {
            StringBuilder out = new StringBuilder(in);
            int rem = outSize - in.length();
            if (rem > 0) {
                char[] whites = new char[rem];
                Arrays.fill(whites, ' ');
                out.append(whites);
            }
            ret = out.toString();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readParameters(String param) throws IOException {
        String ret = null;
        File f = new File(param);
        BufferedReader in = null;
        StringBuilder out = null;
        String line = null;
        boolean first = true;
        try {
            if (f.isFile() && f.canRead()) {
                in = new BufferedReader(new FileReader(f));
                out = new StringBuilder();
                while (true) {
                    if (first) {
                        first = false;
                    } else {
                        out.append("\n");
                    }
                    line = in.readLine();
                    if (line == null) break;
                    out.append(line);
                }
                ret = out.toString();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return ret;
    }

    public class ZeFDTField {
        private String description;
        private String format;
        private int tag;
        private int maximumLength;
        private FIELD_TYPE type;
        private REPEATABLE repeatable;

        public ZeFDTField(String _description, String _format, int _tag, int _maximumLength, FIELD_TYPE _type, REPEATABLE _repeatable) {
            if (_description == null) {
                throw new NullPointerException("ZeFDTField/null description");
            }
            if (_description.length() > 30) {
                throw new IllegalArgumentException("ZeFDTField/description exceeded 30 characteres");
            }
            if (_format == null) {
                throw new NullPointerException("ZeFDTField/null format");
            }
            if (_format.length() > 20) {
                throw new IllegalArgumentException("ZeFDTField/format exceeded 20 characteres");
            }
            if (_tag <= 0 || _tag > 9999) {
                throw new IllegalArgumentException("ZE__FDT_Field/tag[" + _tag + "] > 9999");
            }
            if (_maximumLength > 1650) {
                throw new IllegalArgumentException("ZeFDTField/null maximumLength");
            }
            this.description = _description.trim();
            this.format = _format.trim();
            this.tag = _tag;
            this.maximumLength = _maximumLength;
            this.type = _type;
            this.repeatable = _repeatable;
        }

        ZeFDTField() {
            this.description = null;
            this.format = null;
            this.tag = 0;
            this.maximumLength = 0;
            this.type = null;
            this.repeatable = null;
        }

        public int getTag() {
            return this.tag;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isNumeric() {
            return this.type == FIELD_TYPE.numeric;
        }

        public boolean isAlpha() {
            return this.type == FIELD_TYPE.alpha;
        }

        public boolean isRepetable() {
            return this.repeatable == REPEATABLE.repeatable;
        }

        public int getMaximumLength() {
            return this.maximumLength;
        }

        public String getFormat() {
            return this.format;
        }

        public ZeFDTField fromString(String in) {
            block16: {
                boolean hasFormat;
                if (in == null) {
                    throw new NullPointerException("fromString/null in string");
                }
                if (in.length() < 57) {
                    throw new IllegalArgumentException("fromString/invalid format: " + in);
                }
                String[] elems = in.substring(30).split("\\s+");
                int val = 0;
                boolean bl = hasFormat = elems.length == 5;
                if (elems.length < 4) {
                    throw new IllegalArgumentException("fromString/invalid format: " + in);
                }
                this.description = in.substring(0, 30).trim();
                this.format = hasFormat ? elems[0] : "";
                try {
                    this.tag = Integer.parseInt(elems[hasFormat ? 1 : 0]);
                    if (this.tag <= 0 || this.tag > 9999) {
                        throw new IllegalArgumentException("fromString/tag[" + this.tag + "] > 9999");
                    }
                    this.maximumLength = Integer.parseInt(elems[hasFormat ? 2 : 1]);
                    val = Integer.parseInt(elems[hasFormat ? 3 : 2]);
                    if (val == 0) {
                        this.type = FIELD_TYPE.alphanum;
                    } else if (val == 1) {
                        this.type = FIELD_TYPE.alpha;
                    } else if (val == 2) {
                        this.type = FIELD_TYPE.numeric;
                    } else if (val == 3) {
                        this.type = FIELD_TYPE.pattern;
                    } else {
                        throw new IllegalArgumentException("fromString/invalid type[" + val + "] value");
                    }
                    val = Integer.parseInt(elems[hasFormat ? 4 : 3]);
                    if (val == 0) {
                        this.repeatable = REPEATABLE.nonrepeatable;
                        break block16;
                    }
                    if (val == 1) {
                        this.repeatable = REPEATABLE.repeatable;
                        break block16;
                    }
                    throw new IllegalArgumentException("fromString/invalid repeatable[" + (Object)((Object)this.repeatable) + "] value");
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("fromString/" + nfe.getMessage());
                }
            }
            return this;
        }

        public String toString(int maxSize) {
            assert (maxSize >= 0);
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(ZeFDT.paddingWhites(this.description, 30));
            sBuilder.append(ZeFDT.paddingWhites(this.format, maxSize + 1));
            sBuilder.append(this.tag);
            sBuilder.append(" ");
            sBuilder.append(this.maximumLength);
            sBuilder.append(" ");
            sBuilder.append(this.type.ordinal());
            sBuilder.append(" ");
            sBuilder.append(this.repeatable.ordinal());
            return sBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum REPEATABLE {
        nonrepeatable,
        repeatable;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FIELD_TYPE {
        alphanum,
        alpha,
        numeric,
        pattern;

    }
}

