/*
 * Decompiled with CFR 0.152.
 */
package com.xhaus.jyson;

import com.xhaus.jyson.JSONEncodeError;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMethod;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;

public class JysonEncoder {
    public boolean emit_ascii = false;
    private static char[] hexdigit = "0123456789ABCDEF".toCharArray();

    protected JysonEncoder() {
    }

    protected void append_json_string_repr(StringBuffer stringBuffer, String string) {
        int n = string.length();
        StringBuffer stringBuffer2 = new StringBuffer(string.length());
        char c = '\"';
        stringBuffer.append(c);
        int n2 = 0;
        while (n-- > 0) {
            char c2;
            if ((c2 = string.charAt(n2++)) == c || c2 == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c2 == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (c2 == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c2 < ' ' || c2 >= '\u007f' && this.emit_ascii) {
                stringBuffer.append("\\u");
                stringBuffer.append(hexdigit[c2 >> 12 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 8 & 0xF]);
                stringBuffer.append(hexdigit[c2 >> 4 & 0xF]);
                stringBuffer.append(hexdigit[c2 & 0xF]);
                continue;
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
    }

    protected void append_json_map_repr(StringBuffer stringBuffer, PyObject pyObject, PyList pyList) throws JSONEncodeError {
        int n = pyList.__len__();
        stringBuffer.append('{');
        for (int i = 0; i < n; ++i) {
            PyObject pyObject2 = pyList.__getitem__(i);
            if (!(pyObject2 instanceof PyString)) {
                throw new JSONEncodeError(((PyType)pyObject2.fastGetClass()).fastGetName() + " objects are not permitted as JSON object keys.");
            }
            this.append_json_string_repr(stringBuffer, ((PyString)pyObject2).toString());
            stringBuffer.append(':');
            stringBuffer.append(this.json_repr(pyObject.__finditem__(pyObject2)));
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
    }

    protected void append_json_string_map_repr(StringBuffer stringBuffer, PyStringMap pyStringMap) throws JSONEncodeError {
        this.append_json_map_repr(stringBuffer, (PyObject)pyStringMap, pyStringMap.keys());
    }

    protected void append_json_dictionary_repr(StringBuffer stringBuffer, PyDictionary pyDictionary) throws JSONEncodeError {
        this.append_json_map_repr(stringBuffer, (PyObject)pyDictionary, pyDictionary.keys());
    }

    protected void append_json_sequence_repr(StringBuffer stringBuffer, PySequence pySequence) throws JSONEncodeError {
        int n = pySequence.__len__();
        stringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.json_repr(pySequence.__getitem__(i)));
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
    }

    public void append_json_repr(StringBuffer stringBuffer, PyObject pyObject) throws JSONEncodeError {
        if (pyObject instanceof PyString) {
            this.append_json_string_repr(stringBuffer, ((PyString)pyObject).toString());
        } else if (pyObject instanceof PyInteger) {
            stringBuffer.append(Integer.toString(((PyInteger)pyObject).getValue()));
        } else if (pyObject instanceof PyLong) {
            String string = ((PyLong)pyObject).__repr__().toString();
            stringBuffer.append(string.substring(0, string.length() - 1));
        } else if (pyObject instanceof PyFloat) {
            stringBuffer.append(Double.toString(((PyFloat)pyObject).getValue()));
        } else if (pyObject instanceof PyStringMap) {
            this.append_json_string_map_repr(stringBuffer, (PyStringMap)pyObject);
        } else if (pyObject instanceof PyDictionary) {
            this.append_json_dictionary_repr(stringBuffer, (PyDictionary)pyObject);
        } else if (pyObject instanceof PySequence) {
            this.append_json_sequence_repr(stringBuffer, (PySequence)pyObject);
        } else if (pyObject instanceof PyNone) {
            stringBuffer.append("null");
        } else if (pyObject.__findattr__("__json__") != null && pyObject.__findattr__("__json__").isCallable()) {
            stringBuffer.append(((PyMethod)pyObject.__findattr__("__json__")).__call__().toString());
        } else {
            throw new JSONEncodeError("Python '" + ((PyType)pyObject.fastGetClass()).fastGetName() + "' object '" + pyObject.__repr__() + "' is not encodable in JSON");
        }
    }

    public String json_repr(PyObject pyObject) throws JSONEncodeError {
        StringBuffer stringBuffer = new StringBuffer();
        this.append_json_repr(stringBuffer, pyObject);
        return stringBuffer.toString();
    }
}

