; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "isk-daemon"
!define PRODUCT_VERSION "0.9.3"
!define PRODUCT_PUBLISHER "imgSeek"
!define PRODUCT_WEB_SITE "http://server.imgseek.net/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\isk-daemon.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor /SOLID lzma

; MUI 1.67 compatible 
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "isk-daemon"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

!define ARCH "$%PROCESSOS_ARCHITECTURE%"

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "isk-daemon_${PRODUCT_VERSION}_$%PROCESSOR_ARCHITECTURE%_setup.exe"
InstallDir "$PROGRAMFILES\isk-daemon"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01

  DetailPrint "Stopping service..."
  ; Stop a service and waits for file release
  SimpleSC::StopService "iskdaemon" 1 60
  Pop $0 ; returns an errorcode (<>0) otherwise success (0)

  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /r "dist\isk-daemon\*"

  MessageBox MB_YESNO "Install and run as a Windows service?" /SD IDYES IDNO false2

  DetailPrint "Removing service..."
  ; Remove a service
  SimpleSC::RemoveService "iskdaemon"
  Pop $0 ; returns an errorcode (<>0) otherwise success (0)

  DetailPrint "Installing service..."
  ; Install service
  ExecWait '$INSTDIR\isk-daemon.exe install'

  SimpleSC::SetServiceStartType "iskdaemon" "2"

  Pop $0 ; returns an errorcode (<>0) otherwise success (0)
  DetailPrint "... service installed."
  DetailPrint "Starting service..."

  ; Start a service
  SimpleSC::StartService "iskdaemon" "" 60
  Pop $0 ; returns an errorcode (<>0) otherwise success (0)
  DetailPrint "Started successfuly."
  Goto next2
false2:
; nothing to be done
next2:
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\isk-daemon.lnk" "$INSTDIR\isk-daemon.exe"
  ;CreateShortCut "$DESKTOP\isk-daemon.lnk" "$INSTDIR\isk-daemon.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\isk-daemon.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\isk-daemon.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  
  ExecShell open "http://eepurl.com/jKmUP"
  ExecShell open "http://127.0.0.1:31128/"

SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$DESKTOP\isk-daemon.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\isk-daemon.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"

; Stop a service and waits for file release
  SimpleSC::StopService "iskdaemon" 1 60
  Pop $0 ; returns an errorcode (<>0) otherwise success (0)

; Remove a service
  SimpleSC::RemoveService "iskdaemon"
  Pop $0 ; returns an errorcode (<>0) otherwise success (0)

  RMDir /r "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
  ExecShell open "https://docs.google.com/a/imgseek.net/spreadsheet/viewform?formkey=dE4wWUgtd1ZYNk0teWVVS0NMenVadGc6MQ"
SectionEnd
