from setuptools import setup, find_packages

version = '0.0.0'

setup(
    name = 'isotoma.recipe.depcheck',
    version = version,
    description = "Buildout recipe to check various dependencies are in place.",
    url = "http://pypi.python.org/pypi/isotoma.recipe.depcheck",
    project_url = "http://github.com/isotoma/recipes",
    long_description = open("README.rst").read() + "\n" + \
                       open("CHANGES.txt").read(),
    classifiers = [
        "Framework :: Buildout",
        "Intended Audience :: System Administrators",
        "Operating System :: POSIX",
        "License :: OSI Approved :: Apache Software License",
    ],
    keywords = "buildout",
    author = "Doug Winter",
    author_email = "doug.winter@isotoma.com",
    license="Apache Software License",
    packages = find_packages(exclude=['ez_setup']),
    package_data = {
        '': ['README.rst', 'CHANGES.txt'],
    },
    namespace_packages = ['isotoma', 'isotoma.recipe'],
    include_package_data = True,
    zip_safe = False,
    install_requires = [
        'setuptools',
        'zc.buildout',
    ],
    entry_points = {
        "zc.buildout": [
            "default = isotoma.recipe.depcheck:Depcheck",
        ],
    }
)
