# -*- coding: UTF-8 -*-
# Copyright (C) 2009 J. David Ibáñez <jdavid.ibp@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# ISO 639-2 (alpha-2)
# http://www.loc.gov/standards/iso639-2/php/code_list.php


languages = {
    'aa': u'Afar',
    'ab': u'Abkhazian',
    'ae': u'Avestan',
    'af': u'Afrikaans',
    'ak': u'Akan',
    'am': u'Amharic',
    'an': u'Aragonese',
    'ar': u'Arabic',
    'as': u'Assamese',
    'av': u'Avaric',
    'ay': u'Aymara',
    'az': u'Azerbaijani',
    'ba': u'Bashkir',
    'be': u'Belarusian',
    'bg': u'Bulgarian',
    'bh': u'Bihari',
    'bi': u'Bislama',
    'bm': u'Bambara',
    'bn': u'Bengali',
    'bo': u'Tibetan',
    'br': u'Breton',
    'bs': u'Bosnian',
    'ca': u'Catalan',
    'ce': u'Chechen',
    'ch': u'Chamorro',
    'co': u'Corsican',
    'cr': u'Cree',
    'cs': u'Czech',
    'cu': u'Church Slavic',
    'cv': u'Chuvash',
    'cy': u'Welsh',
    'da': u'Danish',
    'de': u'German',
    'de-AU': u'German/Austria',
    'de-DE': u'German/Germany',
    'de-CH': u'German/Switzerland',
    'dv': u'Divehi; Dhivehi; Maldivian',
    'dz': u'Dzongkha',
    'ee': u'Ewe',
    'el': u'Greek',
    'en': u'English',
    'en-GB': u'English/United Kingdom',
    'en-US': u'English/United States',
    'eo': u'Esperanto',
    'es': u'Spanish',
    'es-AR': u'Spanish/Argentina',
    'es-CO': u'Spanish/Colombia',
    'es-MX': u'Spanish/Mexico',
    'es-ES': u'Spanish/Spain',
    'et': u'Estonian',
    'eu': u'Basque',
    'fa': u'Persian',
    'ff': u'Fulah',
    'fi': u'Finnish',
    'fj': u'Fijian',
    'fo': u'Faroese',
    'fr': u'French',
    'fr-BE': u'French/Belgium',
    'fr-CA': u'French/Canada',
    'fr-FR': u'French/France',
    'fr-CH': u'French/Switzerland',
    'fy': u'Frisian',
    'ga': u'Irish',
    'gd': u'Gaelic',
    'gl': u'Galician',
    'gn': u'Guarani',
    'gu': u'Gujarati',
    'gv': u'Manx',
    'ha': u'Hausa',
    'he': u'Hebrew',
    'hi': u'Hindi',
    'ho': u'Hiri Motu',
    'hr': u'Croatian',
    'ht': u'Haitian',
    'hu': u'Hungarian',
    'hy': u'Armenian',
    'hz': u'Herero',
    'ia': u'Interlingua',
    'id': u'Indonesian',
    'ie': u'Interlingue; Occidental',
    'ig': u'Igbo',
    'ii': u'Sichuan Yi; Nuosu',
    'ik': u'Inupiak',
    'io': u'Ido',
    'is': u'Icelandic',
    'it': u'Italian',
    'iu': u'Inuktitut',
    'ja': u'Japanese',
    'jv': u'Javanese',
    'ka': u'Georgian',
    'kg': u'Kongo',
    'ki': u'Kikuyu; Gikuyu',
    'kj': u'Kuanyama; Kwanyama',
    'kk': u'Kazakh',
    'kl': u'Kalaallisut; Greenlandic',
    'km': u'Khmer',
    'kn': u'Kannada',
    'ko': u'Korean',
    'kr': u'Kanuri',
    'ks': u'Kashmiri',
    'ku': u'Kurdish',
    'kv': u'Komi',
    'kw': u'Cornish',
    'ky': u'Kirghiz; Kyrgyz',
    'la': u'Latin',
    'lb': u'Luxembourgish',
    'lg': u'Ganda',
    'li': u'Limburgan',
    'ln': u'Lingala',
    'lo': u'Lao',
    'lt': u'Lithuanian',
    'lu': u'Luba-Katanga',
    'lv': u'Latvian',
    'mg': u'Malagasy',
    'mh': u'Marshallese',
    'mi': u'Maori',
    'mk': u'Macedonian',
    'ml': u'Malayalam',
    'mn': u'Mongolian',
    'mr': u'Marathi',
    'ms': u'Malay',
    'mt': u'Maltese',
    'my': u'Burmese',
    'na': u'Nauru',
    'nb': u'Norwegian Bokmal',
    'nd': u'Ndebele, North',
    'ne': u'Nepali',
    'ng': u'Ndonga',
    'nl': u'Dutch',
    'nl-BE': u'Dutch/Belgium',
    'nn': u'Norwegian Nyrnosk',
    'no': u'Norwegian',
    'nr': u'Ndebele, South',
    'nv': u'Navajo; Navaho',
    'ny': u'Chichewa; Chewa; Nyanja',
    'oc': u'Occitan',
    'oj': u'Ojibwa',
    'om': u'Oromo',
    'or': u'Oriya',
    'os': u'Ossetian; Ossetic',
    'pa': u'Panjabi; Punjabi',
    'pi': u'Pali',
    'pl': u'Polish',
    'ps': u'Pushto; Pashto',
    'pt': u'Portuguese',
    'pt-BR': u'Portuguese/Brazil',
    'qu': u'Quechua',
    'rm': u'Romansh',
    'rn': u'Rundi',
    'ro': u'Romanian; Moldavian',
    'ru': u'Russian',
    'rw': u'Kinyarwanda',
    'sa': u'Sanskrit',
    'sc': u'Sardinian',
    'sd': u'Sindhi',
    'se': u'Sami',
    'sg': u'Sango',
    'si': u'Sinhala; Sinhalese',
    'sk': u'Slovak',
    'sl': u'Slovenian',
    'sm': u'Samoan',
    'sn': u'Shona',
    'so': u'Somali',
    'sq': u'Albanian',
    'sr': u'Serbian',
    'ss': u'Swati',
    'st': u'Sotho',
    'su': u'Sundanese',
    'sv': u'Swedish',
    'sw': u'Swahili',
    'ta': u'Tamil',
    'te': u'Telugu',
    'tg': u'Tajik',
    'th': u'Thai',
    'ti': u'Tigrinya',
    'tk': u'Turkmen',
    'tl': u'Tagalog',
    'tn': u'Tswana',
    'to': u'Tonga',
    'tr': u'Turkish',
    'ts': u'Tsonga',
    'tt': u'Tatar',
    'tw': u'Twi',
    'ty': u'Tahitian',
    'ug': u'Uighur; Uyghur',
    'uk': u'Ukrainian',
    'ur': u'Urdu',
    'uz': u'Uzbek',
    've': u'Venda',
    'vi': u'Vietnamese',
    'vo': u'Volapuk',
    'wa': u'Walloon',
    'wo': u'Wolof',
    'xh': u'Xhosa',
    'yi': u'Yiddish',
    'yo': u'Yoruba',
    'za': u'Zhuang; Chuang',
    'zh': u'Chinese',
    'zh-CN': u'Chinese/China',
    'zh-TW': u'Chinese/Taiwan',
    'zu': u'Zulu',
    }


langs = [ {'code': x, 'name': languages[x]} for x in sorted(languages.keys()) ]


###########################################################################
# API
###########################################################################
def has_language(code):
    return code in languages


def get_languages():
    """Returns a list of tuples with the code and the name of each language.
    """
    return [ x.copy() for x in langs ]



def get_language_name(code):
    """Returns the name of a language.
    """
    # FIXME The value returned should be a MSG object, but the MSG class comes
    # from the itools.gettext module, which is higher level than itools.i18n
    if code in languages:
        return languages[code]
    return u'???'

