# -*- coding: utf-8 -*-
## Copyright (C) 2008 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file LICENSE.txt. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: utils.py 36 2008-09-07 09:08:55Z glenfant $
"""
Misc utilities for testing
"""
__author__  = 'Gilles Lenfant <gilles.lenfant@ingeniweb.com>'
__docformat__ = 'restructuredtext'

import base64
from zope.interface import implements

from zope.annotation import IAttributeAnnotatable
from zope.publisher.browser import TestRequest as ZopeTestRequest
from zope.publisher.interfaces.http import IHTTPRequest
from zope.publisher.interfaces.browser import IBrowserRequest

class TestRequest(ZopeTestRequest):
    implements(IHTTPRequest, IAttributeAnnotatable, IBrowserRequest)

    def set(self, attribute, value):
        self._environ[attribute] = value

def addFile(container, oid, title):
    """Adding an empty Collage obj"""
    container.invokeFactory('File', oid, title=title)
    fileobj = getattr(container, oid)
    return fileobj

def addCollage(container, oid, title):
    """Adding an empty Collage"""
    container.invokeFactory('Collage', oid, title=title)
    collageobj = getattr(container, oid)
    return collageobj

def addPloneArticle(container, oid, title):
    """Adding an empty PloneArticle"""
    container.invokeFactory('PloneArticle', oid, title=title)
    articleobj = getattr(container, oid)
    return articleobj

def addSimpleAlias(container, oid, title):
    """Adding an empty SimpleAlias"""
    container.invokeFactory('Alias', oid, title=title)
    aliasobj = getattr(container, oid)
    return aliasobj


LOREM_IPSUM_HTML = """<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Mauris
commodo nibh at quam. Integer vitae augue. Curabitur tempor, eros nec
placerat porta, eros dui tincidunt diam, id bibendum tellus nibh eu
orci. Fusce mattis, nunc eu aliquet luctus, nulla orci tempor elit,
sit amet semper ipsum risus at libero. Morbi rutrum, dui eu fermentum
consectetuer, lectus elit imperdiet risus, eget ornare lorem lectus
sit amet magna. Quisque vestibulum erat nec quam. Mauris nibh lacus,
pellentesque ut, accumsan nec, elementum in, tellus. Phasellus et eros
ut lorem luctus consequat. Vestibulum sed purus nonummy mauris
vulputate vestibulum. Aliquam ac sapien. Quisque convallis eros a
metus. Maecenas wisi. Aliquam quis tortor sit amet ligula rutrum
luctus. Donec eu velit. Fusce pretium consequat enim.</p>

<p>Sed cursus. Donec ipsum pede, consequat in, lobortis vel, molestie in,
augue. Fusce volutpat lobortis risus. Maecenas enim urna, vulputate
ut, cursus cursus, semper nec, neque. Curabitur eu augue. Praesent id
neque id urna tempor feugiat. In quis nunc. Praesent laoreet pretium
dui. Maecenas nisl. Nullam justo metus, pretium vel, laoreet ut,
facilisis in, odio. Duis ac nunc. Aenean wisi. Nam molestie, risus sit
amet vehicula placerat, magna arcu bibendum arcu, a commodo odio arcu
a wisi. Nulla dapibus velit at turpis. Morbi mattis, est ut vestibulum
elementum, justo libero aliquet arcu, sit amet tincidunt dui nibh non
urna. Morbi semper, mi sed tristique congue, felis ligula vehicula
wisi, sed interdum eros lorem id ipsum.</p>

<p>Maecenas lectus libero, condimentum a, feugiat sit amet, laoreet eu,
enim. Nullam lacus. Praesent tellus quam, ullamcorper eget, tincidunt
non, tristique quis, pede. Mauris tristique sagittis purus. Cras
posuere, tellus ac molestie placerat, tortor tellus venenatis nunc,
ultrices gravida augue leo et massa. Fusce nec felis ac lacus
venenatis tristique. Duis egestas fringilla tortor. Proin sem quam,
ultricies vitae, aliquet sit amet, vehicula a, tortor. Duis luctus,
turpis varius posuere viverra, mauris elit placerat turpis, non
faucibus sem sapien vitae massa. Vestibulum facilisis. Sed eu
velit. Duis eleifend arcu. Fusce at elit a neque faucibus
gravida. Phasellus quis est sed est auctor varius. Integer
pellentesque quam non erat. Pellentesque varius, sapien in laoreet
tempor, est mauris molestie metus, et malesuada quam lacus vitae
turpis. Nunc vitae lectus. Vestibulum tincidunt, augue eget commodo
semper, dolor leo viverra arcu, ac vestibulum sem metus ac enim. In ut
velit quis mauris egestas gravida. Etiam rutrum dui interdum est.</p>

<p>Mauris sed lacus sed tellus convallis ornare. Aliquam tincidunt ligula
ac urna fringilla suscipit. Nam diam. Sed malesuada lorem quis
magna. Nam odio enim, faucibus suscipit, ultrices at, molestie at,
dui. In rhoncus dui nec elit. Phasellus ipsum. Nullam a est. Cum
sociis natoque penatibus et magnis dis parturient montes, nascetur
ridiculus mus. Nullam sit amet diam ut nunc iaculis venenatis. Aenean
quis nibh sed lorem volutpat tempor. Donec nec quam sed erat tincidunt
tincidunt. Class aptent taciti sociosqu ad litora torquent per conubia
nostra, per inceptos hymenaeos. Integer sed ligula. Sed quam lacus,
interdum vitae, tincidunt ut, feugiat in, ipsum. Integer egestas
sollicitudin arcu. In lobortis. Quisque feugiat. Praesent sollicitudin
felis non mauris.</p>

<p>Cras augue libero, placerat vitae, dignissim quis, semper non,
lacus. Quisque fringilla libero eget justo. Ut vel nibh at velit
mattis pellentesque. Nunc eleifend dui vitae neque. Phasellus
convallis. Pellentesque habitant morbi tristique senectus et netus et
malesuada fames ac turpis egestas. Vivamus justo ligula, mollis vel,
tincidunt vitae, fermentum sit amet, leo. Curabitur et nisl. Fusce in
ligula. Nam pretium. Nunc scelerisque arcu quis libero. Proin eu
felis. Morbi pellentesque felis at pede. Nullam risus dui, rhoncus
nec, placerat vel, malesuada a, nibh. Proin scelerisque lectus ornare
libero. Integer urna felis, feugiat ut, lobortis quis, varius vel,
leo. Donec sagittis lectus tincidunt urna. Phasellus dui.</p>
"""

# Base 64 of a PDF with "Lorem ipsum..."
LOREM_IPSUM_PDF ="""JVBERi0xLjMKJcTl8uXrp/Og0MTGCjIgMCBvYmoKPDwgL0xlbmd0aCA0IDAgUiAvRmlsdGVyIC9G
bGF0ZURlY29kZSA+PgpzdHJlYW0KeNq1Wdty4zYSfddX9L4lVVxFJHWx5i3rZLZSlUxNary7zxAJ
20jxoiEAZfP32924kBLs7DhByg+2RZE4aJzuc7r5GX6Gz1DewbaE3e4Ih7saJgn/gQG+udclNBo2
/KMb2Kw31WF7qMvtHh4auo2v/L2k+++q7arp4R8PUG78xxvY3lVQVvDQwzfvy/UGb3h4hK8+iicJ
X8PDL/D9g1v++jnQ9Kvr5+zK/bqsdne7F55WvvFRdbneVtvd/oVHjY9vfNauWh+Px81LmyznJ/kI
31FADhU9YJIrinBYwq2w2cNVAPnX3j23is+1g1Gmky0Y+V8DFa2yWq5yON7xQfIqkKxywBNJV8EL
YZmVP6NJDUa27+B6G4faLbDZfskCK7/AbrdcwW+kVb0YmmcJZQm9mDRUm80BysO7Tf2u3lwvW+2O
K1q3xse8YWP1cb8+Hup9fb38arFBeD9O7+Cfquukhh/l8CgGk5xcmhubdbWDXzlFVveffIp8un+R
NPhvzfSFnh5Dd/r/O/h0RbTV1T3bm3u2i3tugG3rm5isSn/5NiQlHmHpYlHHo/hxnGQP6qxtD+3Y
jRNoZUD00hTQjIOWjZHGyglEq85KN2p4Atkps4afhJ2Uxi/1/diOMKjTMwgDn63o1/D16pU4JnDh
d+CWR4S7WsL9AQ/uCdFclBEShH2ycg33dhInZeyEidGfx6kAOY0aBtnAuRONnBAWfmyEv9BaBUYN
jWoxo6BVoi9AtZkwI5FvMJ/USQ4txtfIrrPaRUpaGKdGreG91Y3ELDBG6QIGOzR0TXTqs5UGOtsY
y593neA7/B75EIo8mPfH3S3mQALQuBrG2xEEzxvxYzQ73NI0IgfG6aRgsmayGEOKK2J/lFMvB4Pf
XxKogE7SXjJBxny8gUwBAUVoW4XAGSse+BP+PU6DwEd3zHUPI+6wF0+DWMPPVmkMOVykNupkO4TP
xCEW5YF8KG8hu1zxicS0QLoS6jMyBUMoGZHFcxZNY3stBoKDm+qkj7AaCk+rNXx8FtoxDHeVB/Iu
SUBOIGtCLJme7pxxM1gV/j2HT2OJPduJGD8Otu9/w1DzTi+2O1sjzDLYmUrGfpuk37eUSqLHEIIW
ZyWH+awR90V0HULibQlAPlAkfxKykYPQ8KvSmKLhCZ/xNjBYSHyVzIO4TpKPadmpJ4sp73LLB3oN
343ER0yyiyvCrnqcJ2lUyDc6B5CD6teMjx5c+gf/7VV5+/+IVzPiqg4q8ocevHo1FGUiT5+QQ42d
9Lx3V4nOspXFYr+UB914wrMhfsmugH7siFySL3mhcNG6jJ01Z5Hp/HbHJEciEK5BCzrRqYDFYlQs
coDS223R/ypC0eVcH3CDMlN27O6S7Ji1k1THhenjJKTG+kKiyMvTHwQ7aM+jtE+Ksv2HwSUFydbi
vk5gdchVhHaHJEEC31FwFtEdlO7W8IGUsodfrDajy+ci5gcTI4CjuD+KRmH64w6IJWOrxlyR3if6
9B0FCouQi9W3cpBYzl2B+YCAA18Lr7JRny7yWTVUCoKXKZxkgZgamwntrnzVtNAqmEDR51GQ3NIi
oGdv0mJtPVntChN5BOQUGsbgEYLBwT1mwlwneWfNlXoHkSw8GZxpidbKbSyGeWEI0cawGKNsMe1z
caJKss/FxqU7HqtizTRIAKO8PmFCIk0laZRXhMgHin7Bd1A7M7XsWFDGnDTngVwmuYelgEvwmkv+
G0Vg9QVLbr5IXVZv3sv2mKhLLB3eEzqGsK5gi+oclihCuVt0RqGGSGQQS20oO+zfMvFle0gYHius
byXIlhTASzfjRJpBfrdYkBk5XCwYRdW6YPWMvjMP1n3C7XlRLZ4UZb9zg9ivTRjy86ixK5DBvlJl
jJI9Vzrvtvx3Llg0B2Gygd4l7KbiTAFF8I3U8DSJi2qFE0ZkyQjcMGgtgpkgS+LSEzfAp79AGUOQ
ixHbl1UFD10bjOnjhO25omrs4kaSPKqBCkykCu1M4da4gy5iNZy5HetLHsh1Ii2iiPAYfehxnWDA
RUzKRn4gzoucJlGE5oHlJbb17p6CS3UevOnM4VHYhqWNwuhaCD9/8ExY9DzRUKyBrOts1N05dVI9
oqyy9uTiRDpwcMykLoCl2Hu4uA1P6mXDyCaOpJnUhH7jdynv3FmQz3NjlyyI63TccNXvcq9FB0on
jCiX1xygIhwDcjuU4jj60SZQJQ/adNIQ65S3l1wT8CMrsFQwel8ImCTBB32g0Y77yMnNFXHyYE1H
DFEJfBPkBiLBzAXn4SZ/VN98ugXb1ywdFfGft0yf5wH8woCB5RQbC3ZzRGAmZ8h+X+kih783CuPt
u2RybrMX0uav6oBrnjL8BR1wzcOAG4/CG6fEdKxii+jSdp5fuAnXPKqYDYB3jXhi3MHNEpHnAKsk
O7B5adSZah61NTRddbVwThFnUP2x8vCNvsmNBZ1+MZeq8KxMg866TPIjSj33VSGx6R9uLpGH0/M4
UNy5LaDhC9fzuXY6NxwMoGDewX2ulK7S8YIeG0U9tzAjlcQzm42TG/tRPPFaS2ZLTFh6FLnFfqT6
iSopUBio159USxqP9/RWR+zZZlpVOmfgHovIQHnNU26FbO7Uwi7FptiNFKgDY9YzW+LQxtX5MA3K
Np2t0ikDJxILIjuNmFHxLzzmDh0AiLNhT47ab7CFw+MZUaxAIHaFKspuDE8Kv3LOpaFVOl/AYmBP
CtV+1Ib8Eo/th0aeDfaEz79hOyPkuNByji0XB5efs3AVcxH1LjEP5t3r6uSmMb7PolmMz6oANtR9
PWK5wzDbFqXfuShM0TBwmye7eQCnI4Y4+Yqd2BUi1wmQd3F6ddskr/6UAC2QVYfVnxGgV5WtKhMB
4m7NN0C+P47229OjVVR1tOp9fxnml9R7+o44HExm/ak2SR74MQ/7HB78rOFfbCXiK0pnK9xE6upV
izdp0aZTyXeOLecUtjwmeTCrSZT0G+P7TFNawbWcRkaL5hprJg8vJL2rMkEGgtbmQXx4oSnqJftA
37X5BEVPqy4CRSXO3KjAsLJ2YTI/J72nz/zCMJsClfsXFYheQo7LF8YUNB4bu56J+glfEsmS+Lmx
pwV+oZOTozEPQFmn8sBNJxHhFavr4Pm1ajePU68aJj9/MH6u49XcjZGRwkW0MPxCIQ/gdBIxFwV+
/RIZiKdPiRdnEYso+rFbeD3rdxxqvvOrtLdcoNNZRJAckp/42sYVMT+HcO8MiDXOccRhlge/kDAe
Fc+pnAdzOo8gY/q7w9f/AbDjZ88KZW5kc3RyZWFtCmVuZG9iago0IDAgb2JqCjI0NTAKZW5kb2Jq
CjEgMCBvYmoKPDwgL1R5cGUgL1BhZ2UgL1BhcmVudCAxMCAwIFIgL1Jlc291cmNlcyAzIDAgUiAv
Q29udGVudHMgMiAwIFIgL01lZGlhQm94ClswIDAgNTk1IDg0Ml0gPj4KZW5kb2JqCjMgMCBvYmoK
PDwgL1Byb2NTZXQgWyAvUERGIC9UZXh0IF0gL0NvbG9yU3BhY2UgPDwgL0NzMSA1IDAgUiA+PiAv
Rm9udCA8PCAvRjIuMAo3IDAgUiAvRjEuMCA2IDAgUiAvRjMuMCA4IDAgUiAvRjMuMSA5IDAgUiA+
PiA+PgplbmRvYmoKMTEgMCBvYmoKPDwgL0xlbmd0aCAxMiAwIFIgL04gMyAvQWx0ZXJuYXRlIC9E
ZXZpY2VSR0IgL0ZpbHRlciAvRmxhdGVEZWNvZGUgPj4Kc3RyZWFtCnjafZJPSBRRHMe/syVCrAVl
JlLwTrYHVwbtYB2M3fVvyrasa6YIss6+2R2dnZ3ezG4lHkKILkHWMbpY0Uk6hgcPHQIPEYJiXSLo
KBkEgpeQ7Tczu+6I2oM37zO//7/fe0BdKG2aeoABecMWyf4ouzs+weo3UIcGBEErrVhmJJEYdpls
cWTtfYXknJvh4/X/XQ2CEgISVYDGrMfXHJ72eMDh+7ZpE086rOTSGWKTuE2kkjHiV8Rnsz6e9nGG
WwrxMvFNxRQUJ5AiHigpWSfmDrFsZDSD5JeJuzKWkicm38BTZxZemfYQ0H0FOPW5JpuwgOV3wKXW
mizUDFwcA1Y6a7LdpDsfqWndUjs7XJEUjAJ1P8rl3Vag/gWw/7xc/vu6XN5/Qzm+Ax91pShKlRlJ
0hfA68Ndjf3c4EJTmHNfCVFQNZ37Rnq82uvXi0f1Jat0EnszcVcXsET3MHYGGHoMvPwJXH0PXPgA
JBqA1HUEHqG6bf7AzRMrmA+Fls3ZrEOWO1jYOTpZhF4IZ7FC3izaXLBBQ2lvY2ldZ66pxQS3uCjx
TDvyerHa7znaQW6MjtBJ8wqo3OqtsDSTSffQ3aCdeCPDe3qdd0G8qGp9g86F0P6kir5Rj6Xzmj2Y
8jjQbejx4QrDKMRvezGxY9rRZDW+VRrprcpn0rcSdLaQ/MZsYcixaSLf0FwuNeaxlJrLxeIVXsU4
dHBoMOhrgCGJfkQRhgmBAlTSaGShkZS7NoLYwuyxljoSPmak3yafbdfnHork7XjdQTSOhbaDCEz+
Jv+Wt+Ql+a38a7GlGKppFsSUpqw/+0NxnczVuBVtpSYvvkJ5I6TVkSVp/qAny1eprzrVWGypRXJy
8CfxPV+X3JcpjGk30qybqeTqLPpGfNlOmh7Zrs2vNtdybZ1emdwMrs0fmlXhSFf8oKvD/zU7vz//
B82wAWgKZW5kc3RyZWFtCmVuZG9iagoxMiAwIG9iago3MDYKZW5kb2JqCjUgMCBvYmoKWyAvSUND
QmFzZWQgMTEgMCBSIF0KZW5kb2JqCjEwIDAgb2JqCjw8IC9UeXBlIC9QYWdlcyAvTWVkaWFCb3gg
WzAgMCA1OTUgODQyXSAvQ291bnQgMSAvS2lkcyBbIDEgMCBSIF0gPj4KZW5kb2JqCjEzIDAgb2Jq
Cjw8IC9UeXBlIC9DYXRhbG9nIC9QYWdlcyAxMCAwIFIgPj4KZW5kb2JqCjE0IDAgb2JqCjw8IC9M
ZW5ndGggMTUgMCBSIC9MZW5ndGgxIDEwODEyIC9GaWx0ZXIgL0ZsYXRlRGVjb2RlID4+CnN0cmVh
bQp42t16e3xU1bXw2ueceWUmM2cmj5lJMslMkslrkkzmlcmZmZjJ0yAQAwEMaKJiiIgib4FSCuK1
tJ9NuS0WX+hXuZafoqVcP2vRi95Go2gFEYFSLniVmmKBMaWIfGhhctdeMyBX6/f4894c9tp7r/04
67XXWvsMwADAAGtBhPht829dyDLZi4jZg+Wt2+5Z6pyy5aG1AOxBAGHX4MLb599qXTgAIHXj+NDt
d60cXFn8wiTsfwRgK50759aBk0VfHgFwSDhePxcR+mJRh/0Y9kvnzl+64vvzDXXYvwX7C+9acNut
U7omrsP+e9iPzL91xUJtmbAAoNCAfefdt86fs67rryL2q7HvXrhgyVKhUHwT+9OwP2vh4jkLnylr
sWJ/B4D+R4hjwPnhHKlhF98DZqYx3/4nIO8SqNI9NUHNt8zVgu5KOyNd6+H/9se5yQQjmEDGlhks
hM2CbMiBXGpbwQZ2yKN2PiRgCD5jAjMILmES/JwJcAGOM62ghf0synbCXqy3sE/YFpy9DM7CMiaI
D4AdVwhgZAapRczAsQssG47CYSkBw9jGMeaCNeCDl8W3cb/D+PC/GbBGnCTOFjeDA/6EM0GaKw7B
MHuarYcE2w0d4iZYDftw5mpYLe6FDtx1nxjFHQ1sO3sC8RfwAakFRW8U9uMOGwQHbEBcApKwjT+s
CX4Is2FQehvWwwKYi/jn4XX4AMvz4lx8S4I1sidYJdLG6XSxDbBJOMM24X4O8TpxKuyErbBV+AnC
5+FtfONG4T4JJAVeZvcxiRnhbYQW9jHshxclYD/BGVNT9BKHCem8tCX1YM+O70rAJngR0E7BJY2l
HnhYcNGMIsS/gQUfdba6l+1EGexlKwW38HN2E3zMVsIRnH0EXLAZnyVSBrZfgBdYN649ItxPu86A
1dTarM6WMsTNqQdHG4Vpqr2qRpUDjrAtHKNyqFxsiP1E3MwUOMCG6L1Pi3znw+Je9TBJcgM7j/Lf
wppYC0pxJUpxJT6rSY7bRC08DbfgfjfBq4Kby004n5Ic2y3I4nVsTHTBoww5VC1C7QzBkGoRDAn7
kdrnuByFENwnZcNeMcrmwgLhCFrhEQ2n7R2wq6fCGxqU0xXpHYHzqvlofTPwfeVsk4AYtEfO6ZFc
65pxWAd1cY1aJYkCg2qnvENwTxjYEZ/S63xrpqum+mtdp6xx7oDuHZkrnTvHx7t7pXzVzB2qgh2i
W7tDcpcc/7bB4zXVE7t7nTvZje1t6W3bb2lDZE8vNnkP0Yhvb6tJne7B5CZpUPUUnnINWOM6CdRM
qxIk8O45tscH8sE9B/fUZZldZrfL7BqU4OISMf/in5KbNMYLZxerK1N7LBv/UOpVGfGsW6EmXqDe
Z4F9hpcsv7Z59B5NKStVPWNV6SSTKOXY5IOJgwlfH8ijF0flE3WsWJ2TnRvw14eCZeV+MMtQUsyh
MDhv1XfuvHPVqvknmDF59sRo8nOml2r+vGffyZP79vz5ePKx5LvJvcnH2BwWwGcAyLsdwJNWpJLR
+q6P+7wyc+XnmWVVduFLRhjWaPPMRsmab9IwyWSXud+TZKlOEiWrSV+kF/TF8sG+kZG+g30Ji6JY
FLNV8YE34b84YlXq+twBf25OtrrEVVwWCtZHmVljZCXUbmLXMD4oJLe0xiLtl55vj0TbXl6YV6yt
rPEHLxRVZFYUH/IrDX5/g+IXJznU6mBdSV1mm1ZbHeQ04ymUtCg7H9wRb87x5UNGplbIFlWQv89U
XFQsq5wqb7Gq2POSDoZVmVJ1drVQCsU+wccyBak2B7KNktuWobVJ2lq32S8fHDk4ggyYLVYF//Wh
pL0jnIm+UULhgKLUuV1IOBLtYJyNFE9h5AOVUFKs1uCT4i2cYi1brWHHWX+4vrpOK9idl3yRpnIP
e6il+YaZwSm5BnNdxB9w1nX9cs4rHyxZeVwd8PtqMh+rtflryyZUsh/G18Zn9RYVGB1dLc2tLa6g
f89zSw7cQfraOP4BhhYj1MGPmusRk4M+3oTwdcQUQDeWtVTccAaLCtsmPOsGNhPjUDHOcmPLAy9h
79coPwmqMWZUoz0CxpAi7NdiLaFlV2BkseGeNhyzYYzyoZj6RrglWpSULSYS8tiJ3/eNWVBEdayQ
cV2TCJD/tHXWonjCXCQpKV0ZxqmiY8nCS/+240RT0L6nq3/O9BVNnhkG9V3xyR3X7Swp9yZ+uX3f
zcL20se++y9Hl/b4GmfN6Z8zQyXURLoNjJkmTL32+r5A+fTvvPCz2etTdrxq/Iz4DvrRIpgWDxXZ
rGK+0YDmbzYM578nve/U6e36UuYxtBmmGQYMmmynMd+WKVkLDHqVxNRa0FqdyOCImUzAjEZAHI6Y
Fewgpk7HjMzD0lp3XbHkEFe3CxkS30nu0ubZXzJmCwIbTE6VVIHSqgrBIpY6hNcL7NJ9f3s0L8ti
yMxUicctrsqyCklWPVZQaM9HX8A2jZ8Vw+Ia8gWFcZPhXcsBeFe93WYSs3N0ePxjCTxX8rmLFxN1
LHWm6OVZV7WFwf4lS/pvWrr0pv5Fi/tuWrqEzbu9Z9q8O3umzhVybu+ZPu/OaT23czlhniUNoucN
w67mFtS1CXMJCTMPDeq5DqopUzmOlAhoKyZs8UzDDccwt/gLthla0jQIshtw5lEoQbsbRgsrgTLM
ixyYeRSg5TCowZ24PYkQoJzGj3072hlDi6vEmTX0plJcUQEN8sVYbGTUfzE2IicPjfnNqfPGC/qS
MX/yxFifPzkin0jGRr8aq2MucyB9IAWSQSMrMX/d4aTtzcVPbUpQ4oak91eBQI1SVx8I/KqhRYk0
Jw81R+qDZnMgHI2LgUZPQEGfs28cDA1KoLxkX2skVG9JHg0o0WAwGgoLp5RQJOQOf9Qai7ZxeQbG
j0v7pNdBge/FOwfRSKqqfPa8XE2GGmSxIu9YhkseFnOHXX/0vRoWn4tIOdk5pebSHCVHle8qtFe4
NZl2tQYK7VXuIHgrizVZ1cHaiHwucTAWGx29OGK2pBwQyQOPXcJ/jp87eS9JCo0zNQHdbdqnZhGj
ePJKLoeJcOgrOaB4PIwLg1uwk0cNXCNuyvI4fZVCTazKa8pfOOfRf3r28dKbrlnUpiht7I4ORamX
jTnKhTXJL5O7WOfFjgeke0sLg03Ji+11laFbpr73xhuHzZYn/JFYwB8NKWMGpz2zOMhmMSum/gNO
lJEHbe5htLlSmBSvyMjUiWqWC8ccR9XZbDgz2+iwSjnmTJ1QWugCwa+L5JmhKsctH0uMILPyiJLi
35qyhzeTKc65DZjTPjnH/Pe1zo2Bfcl2+xQlWNV0cVlzQ7ilt7e5IRpn2+LRSLP4xqVcij3JvfWl
wWjEL5wKRiKhUCQSpBi9COleSRlcBXoVn+sYV7jTfMx21MSGtVKeVChYTAadViiyVxSrVeCuLlA5
oaognmOoscm6SvkYKtE/yk17jDOQViK36jE/es46lvPtJsvRojnlSEvYh7c3hxviya0tSspWI83s
8c//9uX5bT++Z/mqxezpvf7I1Qa66zfDbwqO5Eh398QpqXxj7vgn0mrxRSiHIPTFA7Z8q9WTrfdp
KoLgOVBYvjabZX/qGzbmHy49BaeN2zVavZVJnRVWnQaurS11mTtC8rmRxLlYwj+qpM7maOIiWmJy
UWzvmDmtIzqa6bjPvWX5ZT+JKOvXY4DmahsVk3K9Em3r9/vknpdvfnLn2OG6u1pvmN6yt84b+XTP
oZ1n/dNK717dPbH9O9GjyGCgzB+O/PyBTVsz9Fmz+meHa6bc/NTI83r9dc2RxooqrqZe5HeW+ALy
e1dzOfq0DLqHyeiT7PBX9FTDqNUM1oOYYfRvIpzC/nbU8wDeqxiWLJxdQLe3OBYBSxbabzF0QAU/
nX2xPZejRIwCYeo01qVOYdrdXH0KSSgSZmqhIJ25DYZARX2tP+j2F1Ss61/2s0fX3XMyz+1Lfjxy
NrmfVY9O/qk4WF7e3P1UY6S4rq35keWrH75P8fQ/yOTf72e5ZaTTNuRxCHP/UvSnc+ONpU67zZ2j
N2g8wyb7aad7OOeUabvzDJzWOG0OcMiOJsf1Dsml1RskG5PAcU2tTSd1aqCi1NLlI5eDDoc7WZ4F
YcVzucQoV7L8lYavVm8j4/pNc2S92s1cnaNKsrm+Xml7xFHke/SWkeQFpn/32vUN97dHIu0sXGxP
embfu/a22+5ddzQcigat2R2t1zL9W+8xi9dzKYRGXVB2KbFx0dKNDy5Z+CDyzPU6X3wec5Ii1Gwl
avMAZjsA/0gS+YhyAcAbrIh6NaAGhzEOncLWdkzSp2Ls4bmMHSWmo9wpjkXAUoS96zHedYATBeHH
rDZh5jF3lNg/17foU57hfEONEj+kKS1r2Iy8n333u2ftbm/y1F6uQ+/ZP7ACZeY889Ci+ffnsY0L
7l4Z9vT/ABV4iMnjL0WrN/cN3jqb07sb/cxslQuj4w3xOl9tsRs8tYfdds05J3zmPm/VnZadeVaz
ZMuWMzATh0ypQgs6R7arzsZsfvlYX2yEh8+DPHtJ+8mEP4F26ZeTqQBSxy4r7VtiZJRdScwQwY1W
2HqYe8bDuzm8dKQ9onTMm0fwd599b3moxrXS1jdRXBNAX5kMp5xPxM/eDkaifmXkF7GmKr+l5w7k
rQt5W482qsD6+GQlVOuwqkUN5Im1p0N5w+Kp0JnqwhxRc9pt9PqrK8tyLCatXl1fVlQMJsv1lpst
ouWpXJNO36ku7nQ7QFc50aie4p8UqinrjvDEYZTca2xUHk3GTiy6KlhSEwURG7P6x5LcgOl6QqlD
KlCav7LjlCTIPX0TfVlA3KrfKFk784lnzaGw0nahVamvl5smdS+W68OR1gvtDeGQ2RxSIu27ivPE
cGN853PJB7hFB6P19axk7W33zk5+wPuBWCgsDij13LLR9raifDpVt0A+eqqp8Zp8q1zwZbF82vqF
Ec+t1WzUSu5sWxG/gYG7BxN0rLNNeqYHnakCQyRaqvxm36GxdF50JUwmxz4Yu+q0/t0AI16dP54l
dV+6qS2qdBxe1BppaGc1BYX/OKHO091VU3v0ioZPBKJRvzWb/aVh3qCvtn1tB+p4E/IQQh3nQyzu
zEfiz3DitUi9lG0j0rP1RLlObyrANBuvVvKI+aorI6f3/0yrcPxwe4PSdmlWqxJuP3x3WxSdh6eg
KE1X1CcOcF9hzebnf3wM6TmJvn8yPBTvgc623Gq7uixL1ei2GDWVucNi4+m2LyaKp6I1eWh5QZfx
muZoQ3tnqNZXXQzu/EK7yaLVz7D0qn1PVhc+aVRPtzcHq3sbZrTFQtNd9hvcXXgh959Dq0v4R2Q0
QHlUHhtV0jZ3GSpmMj+yPz83wFTWkkoC/p4N/h37+38wSdpH2Fp1d9MPVhi9Xl90W35hVYU/bKqt
82PbWVHhV0xerz/6ccTv9RqNXl8gur7S4Z4bj8wQe2u8T76SvD8cigWs2UKotWVmT3LLV71ZU5Nb
6utjAZ5WsBM86rq8gVBN6r7F7xHrUcYK3B+f7A/UZuXKilgOWcP15adrv6g/5bYaRThdqKnwuIu9
/oBYZMvPNeq1aAQm/fX6m/Wi/imTFsMP5HcW5uqKJ2pgimdSbVnR1ed6lGf9dKzTJ9p6Ra5fHeu0
RN3/38fZkVaClJHZgKZ1vjWqKIbWrp47DEoDHmg8AorBXN8Qad9W4Kjd0P/zxz8Ih7mxhfECuGLO
yoHkh1f6o/xg5+Z0dU54bTee6Q6MUesxRvH7nBIvVw9bYNhwyrLd5tGUqiZq2lQ3aqapBlR3arS6
UjAx0yyxNKfLhoHnXF/6Ow8Gna9/58nJhlTYEQaXPfTQsmUPP3TPZ6w2+f5nZ5PvM6/w4SPLVzz+
+IrljxxInjn0++SZVJhJ6Wo56moj5n4emBUP1hfWezoKOzxSgaPSBmXMfNpWVnnJecr2hYmd1ups
FpOUY3cUiLJWAFVJDugMcrV8bCQxchAzHlLBlQhzcSTlV7n8+749tHwl6svRRVAS/HJxaT8PKJM8
bUq441B+4fxX5t+2tLupZpWtbp1QlNz1dZ/z4LKBmRMjE1tmcJ6eGP+TFBBfhkb4tLkf5mBGdwfe
NpdhvRLrrRDCkotZWwVyXQ4uqIVCjP0hiGJ9ORu8BcywAEcWYr0GawnrccwKZ2D24EFYirhxnH8K
V4mYQVwDE/HueiOWQbw/34PlH6AeHsTyLERwV76/D99VDtwP+fAd2Th7AfbXYNmA5X9ikbA04OiN
OJ4P13DZHhzpS1wOWqmvK/6LiYNoBGN96Tueks4v+9yUUjcyHq6tuVZKSkLB8tS3Fsqzr85AKf2k
aSnZs/68sMNTUl0fdeeafOt6Omd8EnBs37bnleYfduZ4HZWe6orK3QNdM14IFv7xmQ/3dj9ozM6p
bbq/JawUmaqrG2qmFKlVtqHlQ4/m5NptgcAqj3dDoKbDppZc99370C9yuF8YT0i3SO/g/X4VZmf5
mFvpMAvTYW6lQVwZ8M+f/JvDMI44EHcOMaWUtOWghGuwXYgSzMcRRt8QJOxpsaXDLD0favjHED+m
Olc+EfAEfORypnPV54G0LZr/U/LNpdT4jZxHcDEf3QL3tfR0HSytjCZP/vPtm2tcBf1tSkN7v9LS
oogD3BjH4a7uWc21k9c0BCsW3pfLgEeeU+0NDe2pc9YyflJaKW5G3c6LR23W2iyfp1A0VOk1UDuc
XwSnyzRf5G83nM4qr3KWFGbK2VqrTdIzaZIGdHJnln5KyaQqXVnhBD96wMTouRj3gGmfl85mEqOU
1Y39p1ByVTQwfz03xxhy9XDKnYgSpiwN7a/kF+KdK9L+dEFR3QP9T25GX6d07MovaOvquVMYbqjn
R+7SvIZgLGDLmdTZ+dpbrCuFTHpXDawaQH7noV+Zj/w2w93xTmeJPVBsZpJFgKDpdFT7hc9yusru
dTibKmVFDpTHVIGmmGOCPFPO8AeCwATZbHEVlxhya1WG8lqDw5nLcmubGlr4Zzj+VVl+U37TTN9j
ubv3J7Eo3PcQz9bwV1xxfjVZX/Pz5ZqvIcLlJVcvEWDeEldhwHeoNaLEyvd/aY1EG9vO+gJFxdo1
q6RSpy9wCL1SOOvTPxVFY7HWswFfkXBg9WpvwB9Cjx8aHQfu/EO+oHdoqMbbwJHhM+fqMaurD9fW
ku1i6ev6d+PNptjnjGnph6PX7H94/3I9PpbcJJ1UPYXz1Fd+UcRarU3iZPWm5MPJLvWab/zWWCDt
hUEsgGUZlgNYVmPZiGWVtJdtwrobSwCLB8siLHOx9GJpS9e7sXRh2YoF54+Ppdd0YFmO5Yl0vwUL
6hhvvcXo8X6LTvx3QoXQL6rFh8Vz0izpfVWb6lV1hXqTpkzzA8172nU6Wderey3jx3qD/h8MlvRd
rAA9oADfBRVCGW9cGgDNn1kzfSnkMyxpHvkNG3qn9Fw77TpP64Jli++Ys7imZcFdA6nvF/SXPEK/
wX7zj9/UxSu/f+ahZ6mEKvBiJGjDO9210AkT0HdPwjteN0yBqTAdZsAN0Is+GJrHhbVsJnokkfWi
lxHZDfDvGLlVWDuwN4NNxzEVRoNC7E2nedPgA+REhfVW7PVglBDxbvlXyETcVOpNgS8RTmaTkA4V
mwx3Yo+3RTaRXQc/QtxESPIe/BYT4+vYBJiJOD4iIlyLuAmsE72likZEhHHEcYzIroU+hB20vp1g
G8FW+CVyqsJ6Ne+Nv4crWoiOZhpvInhNetY1NCtKuAj8C0KF5jYQJkywnmAA83uR+antAz/COoxz
IvOyKpS3inmJnloYQFhDc6tpJ0963EMreVtklRgnRVZB7y6ndhmNlrISmltKvRKa66R2EStEKasI
iqyAcPkkyTzoQWgnimyEt8JbCHOpnYOZqciyaNTCzEiRilloxEzUyaQTIySbx7E24IUqiTP0NCOD
oI6glqBEUCQoMEa0MqIS4ARmEyqsS9ECx3GGFS19HFaASG0RLqHliXCRr4W/cVnh+3n7i9RKrHnv
AvxvTiPWvMfbIpyHzwl3nnCfw1/AiL3Paewc7fpZeo/PuEbgLLc9skMRzqRnn6G1f4ExtG0V4URq
i/ApJDDfUWHNV/E2JuywD3WjwjpJ38ROYnajwjrVQ1tFzJ/hVsTxEREh2ipiPsE9VDQiIkRbRUyK
sk9od94W4WNuHfBHLjc4Dh/hOVVhzff+CD7kJ4pwIrVFOoUinTQRjnELhaPwNO15lNb8G8EjxPkf
uEXBYcwwRDjILREO0Oj78AJGJxXWXO77CfcewX204t2U/mEv4fYQfAd+x/WLNe/9jqh9m9sRWhfH
7IY3+QnCmvd4W4Q3YITWjNDs14mC14jzYXrPb+Ff6de439Kaf6Uvjq+maXuVcK/y8wqvoH9zIO4V
et8r41ziu9Jc8xERXoKd3H9gnaQen7ETfsP9B42ICLlOfgMvcv9BIyJCrhOOEeHX6ff+mnbgbRH+
FzzP7R9rTv/zNPLPBHcQ/BVxsT3lO7Dmevwlcf4c5r6cnudo3nNEz7Owjeh5luh5lujZBs8QPduI
nm1EzzNpzp4hup4mG9mK2aEIvyBrfAq2kFU8RXv/E8EtZA9P4i7cdp/ETFrErJqPPEHwcaJtM8FH
4RHuf7Hm1PO2CA/TrIcI/oxD1P+D1NsIPyUdbiRb+ylJYgOdpR/TbkPITQ+OD9Fs3hbhAWr/D8xM
RfghtX9AcD18n87R9+nN9xFuLcE18D3MaFVYc2q+h+MD2OM4kdoiRko+sopmf4fgSvQmXE4rSELL
adY9NLKM4FKCS2AxSXgJ9RaTTBeRHS0g+u+m9p0Y0blPmUde5HY6PYO0Yg7BAcLfBrMxUqqw5jje
FqGf2jcRvJFmzSJJzSRd9WKWzv1NL96SRIytHM4gbzMdptHIdFo5jXA9GIP9iJtKNE2hkW7a7Xoo
wUeFNR/popHJBCcRnAjX8egMFD+pLWJs5xLrhCD5uE4auZZgB3kEipLQCjGELdRu5t4fbZDrP4m0
crk2kkZjaT5iJLMIzVYIUmTEO189FOE4RUhsh9BeVYQTqS0SFfyXT/5mP+3iS+/pozfU0Uovj37o
Ibh91BCmGm+q3DIoemK7kizDQ5ZRle5V0X6V6f0qyRIqCFdOe1A0Re/CYWlakqUk15L0Go4TMZ/j
K100z0nri2i1CmvuKQtpxIF5Fcc5qFdAFpVP7TyCdrJ7G+ZcWpxlIy1YaSQ3jculd/O2iOcpSTma
hU5ZFvUsdMrMeKa5TZoJJxP/JmpnEuT/H45zkpGudWledES5lixKjX0eeVUUc6U0NxLJVyTKBdqL
EQZICozZ7h9inv9af+D5b/vn+A/bLQu9CmVuZHN0cmVhbQplbmRvYmoKMTUgMCBvYmoKNjk3Ngpl
bmRvYmoKMTYgMCBvYmoKPDwgL1R5cGUgL0ZvbnREZXNjcmlwdG9yIC9Bc2NlbnQgNzU0IC9DYXBI
ZWlnaHQgNTg3IC9EZXNjZW50IC0yNDYgL0ZsYWdzCjMzIC9Gb250QkJveCBbIC0xNzYgLTQwNSA3
NjkgODk0IF0gL0ZvbnROYW1lIC9YUVNHVEorQ291cmllci1Cb2xkIC9JdGFsaWNBbmdsZQowIC9T
dGVtViAwIC9NYXhXaWR0aCA4MjMgL1hIZWlnaHQgNDU3IC9Gb250RmlsZTIgMTQgMCBSID4+CmVu
ZG9iagoxNyAwIG9iagpbIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2
MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAKNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYw
MCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMAo2MDAgNjAwIDYwMCA2MDAgNjAw
IDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwCjYwMCA2MDAg
NjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2
MDAKNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYw
MCA2MDAgNjAwIDYwMAo2MDAgNjAwIDYwMCA2MDAgXQplbmRvYmoKNyAwIG9iago8PCAvVHlwZSAv
Rm9udCAvU3VidHlwZSAvVHJ1ZVR5cGUgL0Jhc2VGb250IC9YUVNHVEorQ291cmllci1Cb2xkIC9G
b250RGVzY3JpcHRvcgoxNiAwIFIgL1dpZHRocyAxNyAwIFIgL0ZpcnN0Q2hhciAzMiAvTGFzdENo
YXIgMTIwIC9FbmNvZGluZyAvTWFjUm9tYW5FbmNvZGluZwo+PgplbmRvYmoKMTggMCBvYmoKPDwg
L0xlbmd0aCAxOSAwIFIgL0xlbmd0aDEgNTk3MiAvRmlsdGVyIC9GbGF0ZURlY29kZSA+PgpzdHJl
YW0KeNrdV3t4VNW1X/vsc2Ym7zNhwuRBSCYPkpCEJJOEMJMASUjCIyjhaUCDhkdMMSGEh5BWBK+1
2quR6ytoP/RqtHyIiFxqNVq1po0iSq7yUMyFVqm0WhhSyiNFxUl/e83g12tt+0f/aufM+e312Huf
tdZe+0WCiMJpM0kqX9rauIra6QQkB/C+sPTmtcmzu7duJhLfJ9JeaVp1Y2ujc9UyIr0c+s4bWzqa
Tr9e3Aj+PSLjs+bljct+H/fFXqLQHujHN0MQlqINgT8LPq25de2G7GL5M6Iwh+Jb2pY2Gmuto8FP
AO9obdywyjZCawM/E3zyysbW5Wtn7YeFYS3g01e1rVk7vEs8B/5B8EWrVi9f9fSYSif4t/DeA5kg
5Y/yyEI7VR9UF5T8vZ9G/8xP/sMaerA0YJX1GzobXh910nmhiXDNpc2kx4VGl+iEsGk2OihKRQ/1
o+wWn4pu1F1H52id0OTdFIcWGkWKcL1ShkJ3STjoGB3VfdQLGjrhok1UQC/L/ejvKB71W0Cb5Ey5
RG6jRPotapLeLDupV+wQd5JP7KMa2UUb6V3U3EgbZT/VoNd3ZSl6DBe7xWOQX8JDeiVCHakdRA9b
tETaApmP/Ig5HjGZfkhLqEnfT3dSGzVDvpd+Sb/Cu1c24ys+MVE8JrJgm7LTJbZQl3ZWdKG/RDlD
zqEe2k7btfuAe2k/vviAdrtOuodeFrcLXUTSfmC0+IQO0gs6iftQY07AXvbQpw/p3YEHXBy+5aMu
eoEGwLn0wcBDD2surpEE+Rt48VgclnrRgxj0iw4tXXtcXEefiA4aQO0BctE2PGv0UNDP0/OiDm0H
tDu41wW0kaltFoceKrcFHmgnavOMfmOikUgDoltJjETDJTrFfXKb8NBh0cnf3SFVz0dlv6WXI7lF
DCH+3WKyqEQUOxDFDjwbOY47pY120A3o7zp6TUtXcdOGApET+zRTzhCD0kU/EvDQaMfodFKn0U6d
2kFYu0vFUSum23UH9ctS0Uxt2gDF0YBV2fYOxVnm0BtWxOnr6A3QkNGK7FuA72WILg0S5KPydGCk
c9Mw/Qfll1sthi41QTnJ5h4tffqyPeWz65PfWujKzfkGm2xak/dQ3Z6IjuSe4eG6ej3BWLjHGLVH
ptv26OmpJ/6W8kRuTm1dfXKPuLa6Ktht9Q1VEM6tB6k4iCGvrsoNzOUmf5feZDyFeWklZ3mIThZh
MzSd8g4cP1BA5pEDRw7kj7C77Okuu6tJp8trZMLl3/q7rJGXzq22ZBGvIoeR4UmGiVGfVV6QZwpX
QrzdNByjX4qkXqst3h6pOxOirEKPijPV+qKber4udWdUWFKYFpZiHmno62s40uCL9niiPXanp4Dy
fO7LfU5PfkN6oXtkjMOS6koZU1w0vlTYrZEilenJYpJQSs3fPaXMW/3V3mpvadXLq+JTbFm57qJL
SZkRmSnvuz0T3O4JHrecmWixFOWn5kdU2Ww5RcrvdtjRwRmdSfPKC1zHlSPJ9uOxx6JEr02P10dr
0VHhITYtKS4zxWJQes4oI5nGjiqPCc+NNUOyzONlZSfdJy+X9ZmD9minxw7rCxoob9DtH3R/0DCY
L2K+aXvA8EJXQCzthe7xxUVjUsVHN1aUTCj3b6/0jC+y2wtLvBXi0YtffjG0896b139vtdjR7/aW
FhWVFpdopzzF3uJXXux9U0v099XV1c4OjGHz8Kf6RvkCZVARNZQXxiY4ndmOsAJrZhFlHx6dsdkh
HGcKeiMTjqadotORu622MKfQp2U6Q6w0dVyay15TbF7o810o87lPepQblHfSd9lnDvrby/oH7R7l
W+CfHxyPbJEyJuPKSEDkVH6kWL7mY6zjoLTEOEbCxxLpN8d7SqsWuwvMuS9f/0TP4NH8linXzK/s
z8/znjnwfs8597y0lRvraqu/W3oMDhaOcZd4H7+7a3to2IhFi5eU5M6+/qm+vWFhMyq8EzPHKn/r
4W+r3EuxGL2WiizMysPYk4n+i6PxMeckYeWXWG/DaRQwmk6B2o3knoNdLpZC0CYNSBRD5Xg1vEng
ZlEU1VCyecHnRlb67IiFefKkisWFhvYz+WI0co4ddOipKVRcRIVuXQ1mBvtrFQviH7rllnNx6Xn+
U/3n/AdF3rkPxSjPwhX2zvbWO+LFA20rO0qyF98lzA/eF+bwS6U52xqaGpcoe/chH5cYLqzy15Tn
F4xLSafscUfT46wXkul8+pAz5LSZHO+067EOMxQziSL0TBuFJDpc+bEi1m0ebyjrcyMXj/TZVSoG
55DvMobU9Pdh5DB24srY2b89MUtFcPAcaiDV8Gnbj6pZdXSfwq8Gqr2emhUrGN8+f+v64lxXR2xD
rdxU6PUW+UsCSep1i/1F3lK3p+/HZZPHuqPnfgexrfK36Z3yeQpDft5QXpSZlR6XkpVjiQgn52kz
Jb0XI+S29OaMuuQ+ZX5eHG5GyEynwx6SGeKYFmuXaUl5V3OCHi87eZl9Ue6ZPt/JIxgXuGcORgdy
lFNUXMk75GQJu3XFbYfFdSVBoZ4oggmMMRyplS657bYlS2+77aHExCerJ5QU2wf9nz/5yKTCiPsn
bWmdenft/mER9t6iu7QT965s6exsWXnv4iJHTKF3/ISvZh17s7w6vyy65Z7crIwv33hHWDwqC2uQ
o3ciR8PISZ7yDEtvNPWGn4reHZttTTNqrVXGtdZ5xjLjJqstJI2iRNQimRZzdSwS70KDD+uIyUn3
/5zJcFOMgwJppzWt27p13bqHt958XozzHzp/zn9I5GkfPbJ+w6OPblj/yGH/2fc/8J8NpBkF5wPe
z+5Y8/j1UWUXhbDx5v+LuA8PfV3yKGEnEDh3XTkForTY/Khs6fI/7L/asumvzochej/OLv3I3n46
jLcdbzPeerz78FbhrUG9FDy30G/EItGnubVd2gXuKQQnHg1yA2hiJuK8Z/1MVGDmBiyODn7PQiOI
Kuuqp1VOz57Stm71d5avzq1sa1n2F+dR/wC98q3nyRA+dTqokKpoGk2nGTSnYljbLBZiRZCiHnop
rqFfY6QMlIngFoj50BliAY0GN5/rzcOJzIRsHs5ZUsylccA59EeKgGwOc7PpC+BVYiZlQXYV3QRO
0VLUihl0D2S1OJOAo9dJFzPEdFoImdJI4GbIpotpNAYypZHAcsiURIqp1ACs4fbVjFWMU+hZmooW
U3DiATf8HlpUsh0VrJ/MOClYaxLXKmWZl34G9HDdCSwpYRzPWIgzoBRupgvIDcynYmCeGItIGiKP
7RlHy4C5XDeHe8oO6rO5paIlTq5eYCZ/O4PpMaxNE6lcN425VK6bzHSSGI0oG4xSjGJZAkcynuYC
49iiWJY76S3gSKZjyAMcwdpoYYdFhohmjZ2tM3lMIslfMYwyXIRBZzBKEcoYwmhj1BkloyYE2yrY
SqLfUSg43MqQWcOo4UQGD9MGkkxL+opqgZdVW/pSxQrfV/TngZYoFXeJ/qRsRKk4RUsaoossG2LZ
RfoDRYK7yLoL3Ov5YB/n1Yhgl0PucR5KOhusfZbb/oEGkdsGyyTTks7g3mGH7Ay3UrSk0zg/b4Ts
NLc6Rb+nB8GdCnLIVUg+o0bIlEYCkauQfIo+DNZIIHIVkoBln3Lvipb0icoO+o2KG+7KH1M89Ce4
74/pIzWjWCaZljwLJc80ScdVhuKOtoP7PMZt/o9xgD3/UGUU7mk5wCMqE3EKUNpDuHFUoMUhjvtB
lr3H+C63+N/A+OOkrmQHGN+ht9X4olTc22ztfpVHyC4l2UdvqhmEUnGKlrgH9XGbPq79S7bgF+x5
L3/ndfo5pUP/OrdRtKTXgra9xrLX1HylV7FuJUL2Kn/v1WEV8VeCXiuNpJdwx8P6gdLPnKrRQy+q
9YM1EqjG5EXc27B+sEYC1ZgoiaSfBr/7U+5B0ZJ+gvsi8h+lsn8va/6HcQ/jc+zF7sDagVKN47Ps
+S56hu3ZxfV2sT3P4C6r7HmG7XmG7dlJT7M9O9menWzP00HPnma7dnCObMepS9KPORufom7Oiqe4
7ycZuzkfnkAvKnefoAng/ps1jzE+yrZtY/wRPaLWX5TKekVLephrbWV8SCHG/0HmHqD7eQwf4Fy7
nyOxhefSvdxbJ7yZC30n11a0pLuZ/k9KAP6Q6bsY76Qf8Dz6AX/5dpZtZtxEt+JuZKBU1twK/TJw
SiaZltgBleZ7XPu7jB1YTVScNnCE1nOtm1mzjnEt4xpazRFew9xqjmk751Eb27+S6ZtoBa8pK3gV
uZFnTxO3WM64jOVLcX+uQ62lLFO0pMVMX8d4LddaxJFayGNVTzZeb+ppErhrGBfwajOf5rFmPrec
x7K5NAfWGIySZrOmjnubRal4DJRKczVrrmKcyViLPRu7M/H+ybTEPq4iNg0nSrXGTWPNVMYaXhF4
l6QpVAasZLpCrf7IQTX+ftiq4jqRR7Qs6EcZx8zLtT2MvDNSCY3H7cAg3iFBFyNfDZZJpiVbIXHC
UF92cy8FwT4L+Av53DJP7X5YIVR+5LIkh7I5M3j3BJ3FmZHNmTE2yI3l/rKC/WVxJmSyLIP74N0U
q4vCtGAk0ziuqcE2SiZx/lItXVwvmdsncWsDpVopR7MmEfclJUtkbhRnVALT8YxxnPexuC/ZUCuW
R8HJmpFB2Uj+tqLVqUtpRuAcp2bZCOaieZbZMadVTtpZZrL/UUxHMIbh1KY8CQ2WIUFfQthyG2eU
BbzaeQ3ec/WgNzrHV7LlGvclWEIcBSFi7+gU2f9aP8r+t/0l/hk3PMjGCmVuZHN0cmVhbQplbmRv
YmoKMTkgMCBvYmoKMzU3MwplbmRvYmoKMjAgMCBvYmoKPDwgL1R5cGUgL0ZvbnREZXNjcmlwdG9y
IC9Bc2NlbnQgNzU0IC9DYXBIZWlnaHQgNTg3IC9EZXNjZW50IC0yNDYgL0ZsYWdzCjMzIC9Gb250
QkJveCBbIC0xNzYgLTQwNSA3NjkgODk0IF0gL0ZvbnROYW1lIC9CUEVIQkkrQ291cmllci1Cb2xk
IC9JdGFsaWNBbmdsZQowIC9TdGVtViAwIC9NYXhXaWR0aCA4MjMgL1hIZWlnaHQgNDU3IC9Gb250
RmlsZTIgMTggMCBSID4+CmVuZG9iagoyMSAwIG9iagpbIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAw
IDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAKNjAwIDYwMCA2MDAg
NjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMAo2
MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYw
MCA2MDAgNjAwCjYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAw
IDYwMCA2MDAgNjAwIDYwMCA2MDAKNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAg
NjAwIDYwMCA2MDAgXQplbmRvYmoKNiAwIG9iago8PCAvVHlwZSAvRm9udCAvU3VidHlwZSAvVHJ1
ZVR5cGUgL0Jhc2VGb250IC9CUEVIQkkrQ291cmllci1Cb2xkIC9Gb250RGVzY3JpcHRvcgoyMCAw
IFIgL1dpZHRocyAyMSAwIFIgL0ZpcnN0Q2hhciAzMiAvTGFzdENoYXIgMTExIC9FbmNvZGluZyAv
TWFjUm9tYW5FbmNvZGluZwo+PgplbmRvYmoKMjIgMCBvYmoKPDwgL0xlbmd0aCAyMyAwIFIgL0xl
bmd0aDEgMTU4MzIgL0ZpbHRlciAvRmxhdGVEZWNvZGUgPj4Kc3RyZWFtCnja1Xt5YJTF/ffM8zx7
5Nxnr2ySvc9njyR75D6AbAjhCCAicghRQEA8UFHwov4oKlXEiBZERLQWA1W0yK1EtLUu1rZSa0Fb
Wq20TT3abcrbolhMNu9nZjccat++//4Ic88zz8xnvufMs4QSQgrJt4lIWq9cMu9GwSRch5q3EH5+
5S3LXKfvuXEHIXQTIcJDi268ask8y40TCZGCaO++6rrbF72eTqVQfomQitsWL5y34NPyM/sIicfQ
XrcYFQVtoozyYpR9i5csuy31W/kRlB9Auee6G66c9+bUow2EJFj/aUvm3Xajtlp4EuV7UHZdP2/J
wr+X3fI0yj2sfOMNNy8T16hWoYx3kmU33rTwxtvueKOckGqMkf8E6ihh62ErUpNX2TPkslzN1/8J
CCL5//knIagwooZoeTmPx/mkAO8hpIgUI9YhyET/jc8biJGYiJmUEAspJWWknFhRayN24iBOzNFN
PMRLfMRPAkRBS5A/tYn0YvZvkiPIbSf5glUYR1aQO8k+lLeQ58lhIZ9uJO/SUfQlsp6uoa/RBXQN
730ET5vEKOZTSF+TtEIadTtRt4bcS47QP0vHye/JBNJNfi9uJreLo9ByO9lJLxPbMKOlkomXe9Dn
XSy9UWwmG2k+PUSP09/TtWQ7/SnF28WZ5J8Yb424RTyAWa6Rysg/xWpRwJs24h3P8DEQUL9JFOhW
+gHtJweIhS6iO2kheUbYhPZb6RmyHP3X0EryMHmYjiJzyXzpKdStIjP530m8ZRPppr/AursRXhMn
ov9OrPYItWIeR8g+upQsELV0FRkgGXpGLBYtbCzyJNZ6L1lPNgl30w76sGAnH3IEuvmGfi5tzf6h
4ARu/XhnN3FL/exPVUyWC1bMhLV3k261ST2d/lSopC/RnwLpBYJF6KZLyOt4towuYE+J+ej3sDBZ
XEm6xXeEMnII5VVkFV0hbRV6hEUoFWIl6+gm4TI8tVFoJlPJCrVJygd+/I/xE1upME51RDVCZcea
N4pb6Dq0vErVpAzpCvKkuFG9GpjdSncAvTsZ/mQpUFsgPYWZ3oC/pQgrMNZMcg2wW0xuELXkcuwH
ZotZW4BUPkMKYywFUm6yQrUUfHKz8A65mcfrgdbtZCWw4jitHMKcNpG7SKxVo1ZJ2EhS4ZJ3Cf7x
C3a1XjzT9eYsd2XFV4ouWePaRabsKrrd9dLQ0JSZklU1a5fKtkv0a3dJfu8f/1PjHysrOqfMdL1E
R49pzw07Zm47Ki+ZiSwroRr1Y9ors9y7KLNRWqTqAQ9riKU1TyJqqlUJEom+9f5bcSIfe+vYWzGj
3q33u/XuRRIZuFm0Dvwls1FT/MU/b1KH2BiULsm8KlbSieDKytbyUoO+QCrOJ2XF4pEyVsiXRKLV
lJnL5GNpSyPGHHjL0NiotzTG6EjaTBMlZpNaQ4up1xOI0ipa20Lr6UltufP3OoMkZf6uKS0WNdoO
WRaoxWMszFPJmsGUziCI5RpDYUGeCu/fOvRPMUKnQ5KYWvPEY3lHC9VWUojX4WWn0jF/TV01fwve
QLcumTHruiUzZ17XM3nB/ClT5s8nwlAGtPwb7L1AYmRDa6JTmC0IQfFgPjno/HN+X9RtF3WpYElM
LCjWESo4nC53YUV5pWykxip/paaiIi4f6+s71dVnYMuLtqQtifSptNwfA+jJMiLQdowrYp7t4JJ2
4kDQ4a+Yt0B2InYhuHP9YhqVnE6n5bSGJdr0LNJF3VifJ1CLhbgTJRaaW46bVzVTxa35Sg3dRB/7
zbrvjohH5lJ7vSLTe/V1wUBN5uTESDTZNS8jTZ/XFouMz/y7NRxuMQpEMLiVkNOuDEQdSJ2hgLO/
3xlgOcXB95hMHvqzNFV6DTO8rXWmtkJbKczWX6tfoV+r32h9XP90bLt1b+xlc6/vi8ovKoqW2fbZ
BGLMKxTLDjuDhZ8aU+InVXuD++MllhJzwBIwLytdZlob6qncV5knl6hJ3JNXUhSJxbFbx1LpRn1j
vIvIfQP4k9/o1xsaDY1dsa6lIBe+zJJatpVKQKkCzQhmk6E6UVefa1NrGCERvUxQFLfm+zx+h+QK
tZk0kvGhebvfO76n6bYm6+UmZyTaOm3H5aczr9KO021rpFXWEl/D/GcLou7LbbrOKzKDv/tdZtDt
Lh4dcjjqg/U1tIvKtIgucDGemT80IC0HvRSSCjKrtSnPUnjQIabCZpJy9BVZtVYpoo1Izdpm6TnP
s8rL2pelfJ2j1CyVGNxEXeSrthpqXEVEV5KolAfSiURf4lTa0KhnxNNFoul04lhazrQcjvkdWFJd
bU3A61Fr9Ln9b6Z6bzYjJog+t9wAvdU1yvH5Xz4ajMbNT1b6/ZEWg9xS6VciT37wbxq89OLO3zxr
uqJbFN//e/9xQfyy3+dTHOJqV9Dvzfwo84/VfdMnj5Wwx21MU2FdI8gDrVOCVdGI2+c0y3nVjXVN
GuLrd34c6SdRejJKo2l73sGyv8l9cU2q7q9khMFmlvM1VNJKVa64krDFzUShJxWqxBy6RnNtkaSN
jpQHUljqQEuqa6ncn8B/tmLsLWOZ/v5EhoWupX2ZPtTpG1mLQc/bY9XeryydggnslPPzCAq5VMsZ
/D/U9EZ9/sik1tbOSn+gUmzyeBmFD6ap2u7zWm0+nzVzRjAxive5fb6gXVztDPm9ISVdE6yYtC7z
Qm1duHJCb2c4NsabGbN1UkWoccAXAFZzgNUcYNVAVrd21kbrEsFAxFaqj/QHPk70kzp6so7WpX36
g66/lfYVk5RGQxR/mddWaijWSnIBlUitEq/yxm0SqaInq2hVvV9nMxfIjfL7qUSKo5SS+zlKjTmg
hrG6EKphkPwXSgAhhxWTF2b9/wMq4XIlHPB5MkaPT4m6R42aGPF5xOUer9cTdgz+kWptPpfd6vHZ
Ml90u31ev9/rdzGIvP6Qksl4vRyj8vGJQDiTCCTG2zNjgA1sRqkY2HhIfavTJR+0MATUxVqLXtIV
uMrVRLKLjW6dqaBR55XfB1H0JSxZBgD9J8ATMX9uMV/f+ewyI1QvbpwUiUwa/H7UF6iY9Kc/dVYF
ApXCFdjsys4/dduDIee53fT5Qs6BFVk51oi53YC5BcmU1rC2QE2Mot980NYnKsZUgd8Z8NhKjEWS
SUaLJ0Di6qYyOaAzheT30ynwqZw6tx/ZzXgjw/cIJBujOWz1/2XmbvFDR9jnC3gG1kR9vsjEO++c
wHiVvo6lVE58RjDR9Z0VqMi86FW+YRGU2cvSa1hDkmxuvUGV1MH8NSejxJ+stdf6a2hNsqa13d5O
25PtrQvJC/YX/FvJj+w/8u+B6ez3OexJqnGPcNcVHBwh9dUErGJRqtLkc5AkVdn9pa02e7G2pbDZ
ptOPKgq3BvzFTS11zUUjRgZ08VG1zjb5VF860Xeqr0/+SP6on6V9uZ1r6bckMi1AxMB0exc1ntXu
EWr8in4qyOp7peCrqsw4DBfUnLD4N8Xxqh6XO1Qv2yzJClDpx03hxNiI+Q1dRUW4ovhnhtHNsXBz
5hPQYbLELteHPa6eqngRTQs3+Vxed8A+cJM9CIoNQtzNGXwtjKGEUQM9Ln/QxYF90B5we10+hql7
6KS0Bpg2Q781BNy17kXuq5ulYFONu9mlsmkTHsPBsK1PJql6bZOr2V0yukhpcyvRmmpVW7NSXVRj
0+clW+SBlpa+FLQWeJPh0thIoql+jgoXd8wi+BFX9E2kmal95rZAzcvpWXHS5R+GS7iQdqpjWTzo
WSUgDJMSZ2OF0unVE+qqIuPPgJ5Czcayac3VjUHT5VX+MvqFMrYuHh79j5jPG2kstMbjFutgutvl
H+YPKAG3YI4MbBZLvNlK14DeXlJQJT7C7cOZOTmnBcdc3jqCHiQBGiiFZdRXkpfSBTwB32zNbPFa
zbXiCs0KUessK5Eli1GXpxUCLnUhURV5CxWi846xGS0hJtv6INvk/iwLZTUeE2iJ97r6Y1Sf03fG
C2nifFHGV01fffmJLU9sKYlXYPMtHoilVR0zIbfo2/8aOPPZC5IhE1u2/OZlAyvcWI0foiwrsQ69
+GJv5m2saULmjHS39DqJkHryUOv1ugZSUeh3pkpOej4uMyZS6oqUsXC/em+Dr9pXH6mMxGuqa+qb
K5vjjdoO02hzh73DMd10iXm6fbpjoXmRfZFjufkW+y2OewoeoKsdm+kG70ZHj+o5zbPkQM1B6tHJ
RKyNFtny2muLgmKsQT6VSuO/ni9eTp96C5ainOr/PJPihk7MHxBqmfXCbBhvmCoabtkAmbM2LOwB
jkh9XX3CUFsjZI0g+rOd79CGvo9ofebXn5VZi65tuaOt4nG/c4auzHdHW8M7tZ3P5pdUzq062HM4
ta0nlRISdMzvqZZeldmUOZ1JZ3YKV5daov6I3Tm6bVys3Dq7Yi0V//AhlTIDH36YyTAeWTd0VKqW
DpPR5PXWh0JNY5vXlH2neX3zY2Ub5C3xJ2Pfi27zPDd6e+PB0fube8v2efThoKfST9T5YnNpWZOU
dFZ+WlPwqQG2YLIm5f/EuTe5v71k1MTEnMRCeYFjQe2CxmuN11qWOZbVLmtcYVlhXC6vltca72m5
x3FPrena+Ir42rioI7am0rJmT1xdHwyZ1TZNyNwxsr5DY2sHcaWPpbPyuZGRV2NjV86MTA/zY1Zu
swAB5c+5HFwlWkosw+YWd0K4KLdw6J3UfJ69qYb96aQOmnMn2lQ+JRwSi2BylRcWeB+9etX3r7xi
w9uvDr5Sf8ckweap8EjFQV+tvbjY/a2Lbn906bKndu468864B72V3nj9J4ZYcHqkpGPiHVdcNLfY
ZH/q4cd+ZXfaS8rj7+R7lQlhc6LutnkTZ8omyw8efOYXHi77Rwx9KHWDHxPkztZJ7eb2smnmaWUL
zAvKlpmWmW8qyyvXVyQkYklFw1adSA56NH3R/dXhiE/xeiMem7NclycXwlIjzoZyRamJFDbIuohU
oyXJagivYdk1jBILHE8989vAunBtwLxMvA8L6nOiaBhBvfebhFTtAVikUNFHLq6oGR8xl3rvnLju
7trJteG2D2I+f0VT8fHfHf6bZGA2qTMUdA2+f8PC8Ij2538s1DtDWbE0uPdf//rXLxkGxUOnpFe5
Dr+zNTpNpkFFDsJU1RdjwaWaPt/+kKsgahYgd/QutxzU2iTzeNlGbQXjpRBctWNdnBS6zi4JpNLI
ZXNSJjLEMjs70g+LZ16j47Wo574ZJDZ3y4xfEUx59CsV0HIQ2VF6a1EiDPEUbQ5VxK6n02jn6mhl
uInCGA3XFGY2OX22xraQIMEJY8rK7x3YJC72+pnsUtwDUzv916i5LL536GPpXnEf9H8tubt1xh2q
tarHVZvNj2ieU/VoevzPBXeY9+e/7OzVF5Xby2qL4nmkMFwWEk+cKKElA3lnZNcX9hOB0/LR8Jfx
iL7J0GsQ45Gq2kSRSKqcZUQJTVEHvcY6xkinoOMBETNymE/SNwC66M909TfmTHMWoOKHGYJtu6V4
ePVgnKzXcrZs1g8bP9BWYnv9VdWb99wwfeVx7dTXFj3y4r/eb7pl5PXLJv/YaQ988PyuffGxsWDw
CZtPTXsN+sUz22euHvf2hMnbVz+5Uydrbr5+WtTfPHXvC5lmB6wjjwu4tA/1S3er7PD/Y+R48lLI
pyJyCcLzMHieRnoI6V6karRXED/w0yFfRkqJDbieIGbipwQtauR15DTKR1EaIl7yJXp0EhUCJbOR
zka6jegRjGQ/0v1ItSRAQuhrxzMiKMZGKomP5PHxC1ETJAaUComC9FL0vAR9pqLHxSQuD/T19Q0w
fZhD1ZL1feEQ9WX6mf2fbeBo+4edQQAuMslEzCbC1H8O2AvNTeAtbOnetff+tbt3/7DhmWt+Rgsz
f3/j6i0JY8mLSqCq3WxsTwSVTQ7r2j0Prt2394EH9gmrOiZk/s+bhzP9EzqnWEuZeSARV9DnM5mx
6rmgvUrQXgVZ0TpntW2d7jHv93SPFz9m6Kl4Wdfr3VeRry3QUCLqpYsKrii4oWCBbZltZcH3Cl4o
6LHtcuQ7LGd8BfoTUvi072hlu6G9ZJphWsmzgWeDvYHeoLbYROJuzTRTUJnOfGKmHnNHAKl0Ss6k
urjoZhR3gf+inEd/UIZZDSnB/a+t4e7/+gDcgEDAqthia2Ztef3l9aNvrzO6kn6nknn3meOZD6nr
txMfE+dKbmess9fvd8YvvuSl7z7yit9fWFarOC/aRkt+9StqCWXtIKx/M2jMBxr6TXI6aEyHndSB
xlRkB2jgaeQPId+L/F7ktaCDUlCITKpAeSI//Q6CvjSQLAQtVcgXgdY0oLVS0JodtEZIO4kiKGQa
0mlId4Cmd4B6epH2ItWCqgjsFh9xQDKxNxgwMhvdjH4RvE1B/Qy0XAo6D5J8Mp1RWfoUkOyz5OR5
7pyhbyD9FQpzM5eQsbGQBdByPjXlWNhLs+zOKVFcb9a37Lv6lSEq/+KqnubaGdUh5YjDWhmvCLgG
du1Zc/+e3Wu7d5odUzsvoUVvvk2N48fSlc4QI6kvH3P7oD9fu3/Xi91r9x3InkUC48vEA5i9l7yS
nEwWAc9bELbzUEKexfqeRb8DKGuwasatbs6/dnKQfBv8SxHWcZ7mNxOUou00eh0FYu2omYawnVgw
ihFBj0DBwxZga0TQI1BgZuXIEoxqQC4PWAcRl8IWtnNunk58w1SahY7TanqgK9XFIQWdMlXoO/9E
iiNKOKv63ZxuqUm79/Hl1GR3BMNVC969GhxPPZ8epSXRxbrBhcJa3bMrVh+gWx964s6AzR6zxGuo
5vgH1DBEDjQE7r714Qey/uwh2OfNKieJk3XJauy+D/O0Ais3cieQi2L1BzFrHeooKaEC6oZAeQT0
pkadjLwG9GPBupmWCeEJiZ9DWjCagtQBnldQowCjfFJMEsyMH0gdS51vxzMzHgoCjo581pD9Riu+
OcfCZ01ZO3XnOurFzaFISBm8icU7ekKV4eCTv/zoxmurfIY18aXz6fxQpCKQ2b7OB1/Yh0i4MoBc
+/6nE7XOYOkV1zdCHSiDT2TPtVdnlkqrxSfBN/Xk78l54NcwmQjJewnSOUivQ7gZ+W8hfR7haeQP
Ie0F7e1Fnp3tRUgd0HACASbHPcCnDrwb5QifAB0wOgtyreEhBsok/WkShW3VAFqjCCrQG0VQkftB
OTugJ3ZgV3qR9nINUQdUqzFeIfIRvEVByQn6LSQvIAgI0/Behekn0iAfg1ruYu6TPsfDsET6jjGC
y5zdCWbX0rMquSZAh08Is6CjMsvg5/R03VkfXZhw9/btd9/1gx/QmM3T8PM1N11d7bXeaN/wrREb
5r782UDvpPWdVvujwWBijEHUbl218umnV67sGax8YHnFhEkVMWdUd9+228e2/ftHPx5sbBpnNnm9
QRdWvwD0uQJys5H8LDkOtKaw+zTIMQqMfaAokd/VgVFRp5AzaD2N3BDw8BATv1n8ErYu40h2u+cE
Flbgb8TuJDhyjcBMi351XMcKwJqg11T0nYN+M9AzijjM9a8Ku2+EDq9DOyGzSBP0L8Rgy7DNm/Ub
zrN9c6ca/UwXnzuFi9VfIBezJ8/6rxxk6LOq+sLq6n5jO0TkJqtj/LpJj/4wmqgIBjOfR92hRu81
C6963NsSdkcznytKtL07q3pLjJnm9uSh7ZlmN0gehrGdPrV8xf2LMnPZKSZT0YRLNCJNUc0FrSvk
jmQYsRd4iVRN8qiK2ICtF1RZDgy+5Heo5aBzC9C3osaIPZFBw8x+cQGVy5FvRQ3l+6Sgnwv9guD5
1ECq61j6nP2XA4gd2J1KM1joeYxtdF+wbvf5PryQr7SODPqTrcpBmlT83ujAF8FgOEzjr4ciwSD1
W53SoesaojOnhwIDRW4fWydU0io48t4SI1vvp5nl4ma+3jC5JRlCHOA86sSO81Wf5VAn1s4wCGD9
jEMj4EQb1qbwu20XnjPn1lyInJev2EEi8rH0sZR8LKcbz3qRWT4776wv5wR+jclq9e7zlrs2mByh
+FqTQapzeBp/ft/Sa8BYN9m/+63M7fPiwaCgsAVf21g1a6aifNm78h7wUxXjp3u3C287Q3zRFBKD
SOxG00pmJZ1YObuQ14BPhnc1u49atGjQxPZY4jaHzKliCvaRIrAaGyRJqmsgpecGvv7sJmJR558Z
f2UDBe+OefGQQidYHbQJpB0dBAVi08xSN1PoJUam0LNbxfiZ36l9DF1+ES1PXkM2QCY+gjmtJyM5
T4/GDK1AXQU+vgj7VIxZj4Ckrub7gV2EJGgiFVhjNXauFfnTkKdhRtXo+SXscS+eGUPaEFpg67Qh
tJCFCMsR1GQU1kzR1knG4V2VkLM12Hs7nmLUPALa0ACsioGNGlqBoNeViOegr4vMQ48CwjTGFWit
R2kOnp+BEadiDFbHLPkpoJFTfX3phMyOQOX+PsOwdZVzmnnKTiCiLVyGJDL8OH/YgTLwM9ILhAQz
4kdQ/fCNT/V/0J/D5xKWCwQP9wDE49UjJ8wwjAh5vCsjzvbmyk6rvyXsiUGm+KPtJkNHdTD4mNss
hC5v7phdEr5+7Kpb5ZFhn/f2YECo7L7y2zdm5tohdYJtdrp9cueM2prB40zOwBW1C6tcQa/X4q8I
jxg5quWZQ1n3K1bDCHEx9nolfINm8nZyAv+SIwh0TUDLz+49ueV7BtYVl/LYTz12swJ7Yc7J92pu
8THbmnlPJbBxTahju1aEcfJAJc3wePPQuwEWSFFOyme9qDnoPQP92Q5FuH5hUt4EKd+A9hou59m5
7DcK+v8i68+T9AJzOr4O+Nclfe7wtvqfkPThaHTuOVEfbfmg1RdugqRftAWS3tdxoC4UgqRnyPrd
Jcb2YUGvuB1hxXFO0IcdbAOw6stgH98s7gF1WsiY1hpyQqc+YT6tO1rarmkv6FR10mmaaQWzVbPp
Dv0O4zbLtqJefa9xv2V/kSwGCxfkBQ3TS5ndms4KNHZDfb5PSZk3mbNThUWbD7/x2GOHU8IPMu9/
+knmfer75BPqv/n1Rx89fPjRTT+hl72XOUnl996jusxJbm+1wd66G/ZWEJj/ITkDNpUPQYFdZYdd
5UNQYFfZwT1B2Jh+rtEtkE7FnAI0qDuB2ijoxElk0IkFdKKBxPZTDWpOY/874TN1QgbMRjob6TbY
uNtBN/uRHkCqhdxIYEw9xtRC0ulyspDJvAq81YNcgn8zpCB/KWikgHtwF5Na2AH8YHpYvhtyfric
7st5SXLulocfe/xnzszSCOFeaEC5AN0FJwMBfzQzNhiqHmM0jqkOBeF8t2+74me0eIj89Jo9LbRu
7Z6999+/64Uh4vMpLh/sJ6mYMZ3JPK+jI3PyyOFMZ4fwwtr7du9ac/8uhvlkYL6O27g15P3kpbAu
9eQ5rP5pIMG8mZeR34u8GpK3DHtg5zpChNZjOqOSe1Ay8VHm6eQhXwKcK4G5DMzt7IoSMjc/5zfl
c99pByRfLwKTgWFoSnbSgT3CDtRgV+IY146SGjl2vlKY80bDwNkPxJkcMMJ7quUeKQf8LBP+B8Sz
Jq3xPJ+T6pmu9eU81PMN2K/YWgO71q7dvXvtAy8IN4/cc+3hzBDV/fzyng6r49FgID7ayM4/gpmO
qD8YoD+9b+fuNfft3jOwk67r6Mwc/iXVdXTMM5s8vqDry39iD3wuCDvuby1h94eQdRFydzLKLCNQ
nI1LOpKlW+53n+A0y2h4mL43AIkehH0IImoZnTIqNWF/dDk6zdKmCdRZgLoKZnOxq2CuTnJfByTS
AwNnqRQ+lvu/kOI5P0sjSHQis7YGb1KCocjO9nkxJdhntV3xy1tnXV/vtiyJTP7h1d3nzC1meZhN
O25dNq7R3zjihtswwz1Dn0oWrL2Vzk4+QsaCmzqwihlIpyPthpS+C5R2F9ZxFzBZi71eA1q5B7L8
O+jzBNrXcxvAimAjj6P9MbRvQPtGtG8EdT4GWvkh+j2Nfk+j39Po9yzn9SKgFwP9VYGqm0HV5QhW
BBvoMQwPtxLIxoG9h1OjFRzvQD8CLVCAsQ2YH9MepRznAuxPA1mJniuwVwJkTCv6n8ATpdi1kWg7
Sm4k7IsICS1J+As1eEMRpAzziwswrhZjSpBWbFwzdnMh+R7e+gLCj/j+usE7UdQStCb5zUSqi5vO
uVufrj540Ol0Fzt+Of9agp1x1X/1QmL405/hW6Ds6dd59xGW4esIhZuhe9z+UKlcFO658ppvX3Vn
/VvvvfPKpKekgpEOj9vldVQ4TbW3XXz5zbe8/qsfH9vX+MA13oTe6x+3pyLQ4NHXJad3jG158N57
vhtREonltdFqryEeuaR1VJ2kurf73q3mMoslzvlg5lC/NF/qBSJPJZvg5RWRZQj3IGzge1UEPWwH
lWuBKrO01MAjBJQJt7rOoMWJuoOoCfATG7AO1aL2KHYxAN3u5bqC8HMeL1COIsfOI3Sopwhx+VhX
SzoBDtEP62/otK6WVDp3AnHeMfXw+YLp3DVa1mAHgiPO8cyI4Qt88dZ4ZTicufbSq2ZnHDYl3jz/
iTHLv6eY9DvCgZpLl/qVCo+4wAN/JLOnZ/E1Qbs7blF8nRO8cxc46WSA7zhSGwklZv2CrWrcUBo6
ewtW9UyS0SOTjiIoP56zetm3q+VcEnuwbg1gqCTFkBseIGGE5CjHmitB4X7kTMBHB9o+Z7tWcblT
wM8o1Nxbm4HWRVziMlnih3ZLQNqyb6la+vTnbNSzNg8zi9KJsyfQzCzNnfB9w+Ff1kLN+jrnN9Ml
19y85PE1ijcQfjfgrIpHuI87d83EbdvM7Qkl9KjXSpf+z7L7F9Mn3N6Az906ONXlZ05D+4T6F3bT
nzAtZ4txKggNfSA9BbwC5PtJBTJBRzZjFQI/wVLnKMPB7QaRE42FqIGWF2ixc4QA/xK4GH1lYGtF
HxOX0fnsnEFmPh13e867+DFkL34MREfHcIeQifExfBgnrwtgO8bwy58Au/zhn+Vpsxf2xv9+/cOI
bEsbvDxa2hhIjPZTibpbJtUFGmltMBhvM2QOlMWjkWiZyDW9Uwm6Bm8X7nWGFCc7PxlU6t2uBu5P
pYHLO8CliRxLjoKm1mCPmW1LyNX82+ogMPBAGlr5V9bNkFgUfdnJnhOhGnq6DBho+T2HDojVo/Yo
+rGvsdmX1JTfhTThuexX1NXg4EKUrwbXXgUup8gZkSskzexrR/zP4pjIXgq+YeFfdGah9AIwNhsf
0mr81RArcsziK0eqZe9U8Tu0bDwrTruomMVKvABCDbs/s2YVmcVKz/sGkjXmHhHmrsoPBn1B+S95
Yb8SoAV1gRK9vtLV9PyqgqDiC8l3biuNjIn5amih0+lL/LFIUXzhYjqQ8QccgYRw3K14fE6l1Cup
pMFn6L6AQ4ln5goznaGgw+cJuIRBI6vi3w7B3urGHkTJq8kE1uci7I5wIcIi0BvbAxeQ0nOdfxCr
jEIPOIA6O/EPnrVoY5w6mUQjue/WtdgTE6j8KqRMO1l5Dj4NyLUPRPvR+TSbtYs40iZOqi4ENh4j
VjcnVTYyq3Ui6NkdxPCtJcDmhPu1r27oN1Py8Ne5gjUyviakZKqjfkU5vjXzMKdoSwOnaB01KWNq
Ao2nQ0pFwxCB3cCtJTpKePssTR8XFFeQ0TTwzJ5b8/DoNt+cK3Qtn1Ga/UnAT8p+++vhdCgNtD9W
sd8sqM/++gCpWptBZ/XGzJ7MOPXqr/0uISQdIYsQiHSELkHYKh0ZyqA8GWE+QhvCHIRXERoRChHc
CDMRJiCsQxiBUIxwL0I7wtxcOxv3EMJqhAUI2xE+RejNvWMxwmW5d7D34f1kT+7ZcQiYG7TBEfYN
GqjHQ+aTu6iJbhbUwhYxLN4m/k66RyWr7lCXqH+ruUzznnZ+nilvQ35H/omC6wpjhX8quqzoWHGF
zqN7T/bJf9BvMpQYbcZdpnGmY+aNJS0ciRC5FrLyDkgAATTRChokmk/oLTkvnEI3ZPFSMxqdNuOi
aZMujYy+YflNVy+8if+SA/8y68kt3/j7ixD/pYcO9OTjv7AIcn0eBT3HOY/XwW5qBEeMgVU4lowj
48kE+GsTySRyEZkCPTQVOmkavIDp0FEzIbkuI3OSQ8K3aZKdAsPOKkQ8kmQQj+BxEzsroo2w90Ta
wGvqeb6OdCGuhW4QaQ2vr+b1CVghIo3xmkoeV1AfUhUN8xLDRqRBWGYiVXg+wN/p560+Hnv5qC7q
xO6oqIvXsbxI+R0AtVMbVqGidt6P5UVqxRpFWs7zZfyJUmrh77XwUgl5jZdMvGTk7zcAIZHqqQxL
SEX1vIXlRarj+UIeF/A4n+bB3lHxWASj/AvaTIUUnhz8tF9jJBXSdn7yyfqreCzl+km8JPJY4IhS
WA0iyAArIEOoLwa1sJT1GeSnLRmuXQf5icsA6w07JMPP5P5N7kT7GV5ieZF8AZoSYTV/DrtPhTTD
Sz+GHPucfEbmoY61iIi/jbrPyCmMp+ItIvksOQQalVDH58rbRJ4XyUl+OvQPPl4/+TukogopK7G8
SNLkI+h+FVJW9zfyV97jb7z0V97jUy57PyHbEX8MyhTxxF8ga1X8SZHnRdIHq529u48/+Wce/4lR
GPkjz59Au0g+5Pk/8Pj3PP4dv504Tn7LETnO637LEfkNb3mP17wLrySJ9nd56RiPj2b3DCnbAZYX
yTu85Vc8fpvbg7/koxzh+bd4/S/Iz/lzv+Cln/PnfkbeRD8VUlb3Jn/mp+QNXvcGLx1mlE5SjEPI
6+QnvOV1fi73+hDbpZ/k1v8T3vs1Ps6r5BXyAOpezZVYv1fIIfCsireIiNluHsKoAdSxFhEx20tW
I8Iny667F36SCF3IcHmJj/Yijw/wde3H/mf77ee1+4d+hRFYjQjPbg+fw17espfPYQ/Zzeewh89h
D5/DbrKLz2E3n8NuPodduTXt4nNheRGaMIi4ncVkJ9/TH/KRn+fxczzewSniGZ7/AY+387gHfij4
lMci2crj70O2ieQp+H2QB0gZviwvkif5M0+QLZwytvC1b4ZnCxnAY5Fs4vEjvGUDZHETWjbw8dbz
m8bv8vaHyUOcph/i1LyOn5w/CC87hLoHOaewvAgsWO+1PL6fx2vIfeitQsrecB9/8l7e8h1O2as5
TdxD7uZzupu33MXjVZiLCFwh8eAf/w8kuQrpDpRYXiS38+dv4+Peyp+4hSzn87+Fl5bz55fy/PU8
XkKug85QIa1GieVFvJ21XEMy2H8RduViyDIVUrYri/kJ1VWwT0VYVZfxfVzEpBvsLPbWBdAhrPcC
vgtXQocWonQlH3E+R28emcu9z3n8hGsu//ricsybUX4Xp/LZuXFn86cu4/JmFs/PzI0+kyM7A/YZ
k4czeNt0/v5Lcz0u5XXT+Gwv4fmp0IBsv6by0sV8hCk8P5lT+yT+/EQed0JXitCPrHU801vQlyw/
lsuEDi6zxvCa0VyKteXGbgP2IviDjd2KfWWraOXPj8qVRvERRvI1jeBxCx+nmcdNPG7kcQMwLsUT
DRzJ+twb6vntSx2nuRo+VjXvneBxnMcx/kSUf+9UxWu4vkWZxREeh3mfEPffgzkaD/K1K5xXAqxX
ciMkEXsH+2qB7Y+P06qXj+DhsZvHXBPz3WDfI0i8r4NThR0oivAssnU23s8KvIMoWXmpnPN8We4N
XEPzPPvCgeVLeMy1MywRA9cQBi4J2Nc7jNtkjjf7xdZElHR8ZSwv8m/K2MqK+NOFpIBzFNfbwD4P
Y6t4DM+L12ly/TUcAzXnFlVu7iouASQ+M66vYauV8xsSA//1WOnqbhr5X/yP/O+arh3A/180OuvX
CmVuZHN0cmVhbQplbmRvYmoKMjMgMCBvYmoKMTAzMzEKZW5kb2JqCjI0IDAgb2JqCjw8IC9UeXBl
IC9Gb250RGVzY3JpcHRvciAvQXNjZW50IDc1NCAvQ2FwSGVpZ2h0IDU4NyAvRGVzY2VudCAtMjQ2
IC9GbGFncwozMyAvRm9udEJCb3ggWyAtMTY0IC00MTAgNzQ0IDg3NiBdIC9Gb250TmFtZSAvVFdP
VE1VK0NvdXJpZXIgL0l0YWxpY0FuZ2xlCjAgL1N0ZW1WIDAgL01heFdpZHRoIDgyMyAvWEhlaWdo
dCA0NTcgL0ZvbnRGaWxlMiAyMiAwIFIgPj4KZW5kb2JqCjI1IDAgb2JqClsgNjAwIDYwMCA2MDAg
NjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMAo2
MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYw
MCA2MDAgNjAwCjYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAw
IDYwMCA2MDAgNjAwIDYwMCA2MDAKNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAg
NjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMAo2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2
MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwIDYwMCA2MDAgNjAwCjYwMCA2MDAgNjAwIDYw
MCA2MDAgXQplbmRvYmoKOCAwIG9iago8PCAvVHlwZSAvRm9udCAvU3VidHlwZSAvVHJ1ZVR5cGUg
L0Jhc2VGb250IC9UV09UTVUrQ291cmllciAvRm9udERlc2NyaXB0b3IKMjQgMCBSIC9XaWR0aHMg
MjUgMCBSIC9GaXJzdENoYXIgMzIgL0xhc3RDaGFyIDEyMSAvRW5jb2RpbmcgL01hY1JvbWFuRW5j
b2RpbmcKPj4KZW5kb2JqCjI2IDAgb2JqCjw8IC9MZW5ndGggMjcgMCBSIC9MZW5ndGgxIDQwMjgg
L0ZpbHRlciAvRmxhdGVEZWNvZGUgPj4Kc3RyZWFtCnja1Vb9d47nHf9c93XfTx4RJGSNiJCUKCWl
tF6LhCAt6xTV0GNriAedVOIlaE6HqmnWPV5Ks8xRM3PMMbN4nXXqLLqilWzVscls6/Rt1Vq2Y1Vd
Zk/2uT552h92tj+gz3Puz/19v77X93r53jAAkrAaFnlzSovLEMYISur5dJ5TsTTr5jNl+0i/C3ib
ImXzSovTyiYBdill0XkLV0YmvL0+G/B98gXz5xaXXO3U3Ei+kPzg+RS0HeNdJb+afM/5pUtXtNmG
CPnd5MMLF80pxu38w99PPlRavKIsnOTtIH+EfNYTxaVz30petYH8BceXLVqyNPYdVJD/mHyvssVz
y1Y8eboLEHQFEl+kzMDNx80oxAfIjktq8BJm4iwaSO1BopfhFaIST+EI+e3Yj1e9RFONi2a0OY4t
psrUmRJTJesGeqfa/khGkqnzw941yg5QVoX1aDDv+I24jAcQxWW7DSvtaGpW4oCZaccgE+V+qvjd
tLnIrIfZEag2ieaEaTSXzXPYY84Yjm6LcJ3xqux2e4xZVvnpuG4HWY8jVXOMvYrBh/Ia65ld5o+m
CceQZiLmgEnCXq+G+uWmGctoX2VysRmbzWg8htn+TsrWoEj/v3OUGkTNOc47yqfOTqL9Ac62wWQw
jwYcMeUosWGzBrcQM822vU1zsbCDc12PLajx1prxZrOXibdUgagrtf+Jv6v1T6Y769bEMaPI9pvc
P2iPZV4GM3H6KKKh1NB0c8bLNcfNGVa6xEvzoqYUr9A33ZQ4L5tIu83eg3YVova8l44T5Ndgjan0
d3m7vQi5JM5ko6nxZtKr2huBKagMpfqJrJ/+bm+6mXqFQUMwMsjknKvtdrORmpMmhHS+K7HDVofW
sWbLzT5W7ylXf5SzaiX+Tma6iP9yPpWMVYTHWbv5WGTD+CrXg9ky6zRWKtFVijHKWalsVAblOIkl
3nksEW5htVZiFWulOq1qYU41eBoD8hJCgc+FRL+s5Fov5/6S2ryHirLOzsjO7fdfbFZyQlYtJte2
W5l1vKVlcpGfEcyoDbrW2pxwrZ/T48r/U17J7TdxclHWcTN2XEE87LjHCiicWkTScRRTPq4g16Xm
IRKr9iPBbt4CCUjLa+MjZMKB56N//R/q70byhfoL9QM6pWSn5GSnZEd83FpiM269F6tOaP/p9cWh
PtDJ01PnxS58rcN9N4wJ6yCeSr/05ufvz0bhWY+fU/mEwjEah6pjh2KFoXWfaz77eX4DIn6DaN0W
svDwdT5PIiAmI495I+EDU8EZtGbSMR4nhPbAtK/kT5xe2HfsomWLF8xdTA/9YlvcXfI/fnF9fou3
2uSjE6zJ456zZhRixJHC4RhFHIafE4dKMkT0YMwi3suTZc09kg+SfCBKiAMkyRX2Mz35Dsyd4vpw
Ptb0xr3EO0T30pg50vYU9lDULNOdVQhMlmSOtqabbDNNV0ylJlN2jrYmA5OIXUSny6OzSdO4aeJu
Q524VHGdNH5HTCCmmGQ0U5MijaOt6SA6SdhWmGja8KYLhJaL/g8kkgtzTaxJwJuMFPBdQC4k+0Do
x+18cVboqaIGdxHhZoAWyttzhd3b2fwbbRBIZkVb3lO0xr+kb8Y/eY4Dvh3naItPuQ8sbuITbKXm
pjQ38Qv4lNxAMWVOY4mrKbuBjxkvkMbiRn4L95VPmXKVzoq2vA++RPyb4jXhr2hLfZM4R1tcw/tI
o+yaZB/hQ1l8JO5DWVxFN+IH7EYWf8Ew4vt4j903kKcVbdl3f6Kx35XnO8K33Q7DFdF/pt7yhnH0
n4SXhb9HKrERl1SRRskuqSK/k+a3klxk/8un/qK4C8LftK4Z324FHG1xXpo3hL9GF+KvFKVBdL3k
5/C6/M6Je11+r7HjplL2mmRn5XMGpyU7Le5Vt9PxS3dC2ANOSfMKchzX4lbpVHz+p2Rdpzgn8TK+
TdnJOOfsXmaXmEGZ01iiW80TjNqLMqexRLeWTmL5LdA675cwkNzPVJfjivZT4THN6yjXv9XuqKRH
W95gBCexOIxDyuGwNIeVwyEcVA6HlMMh5XAQtcrhoHI4qBxq43OqVS6OtmYcehMLHPLrwq3pjxV5
v/BHwn3aEXtF/1C4R7gbP3DnVGixS/h9TCTuxPfcfcC3q6+jLXu583mRXz1uZ2zX3Lfhu+4OEFr2
KIcvSLOV9+dwarYq3hZ3y+B56Tdjk/b0Ju3mje7sYgM7XR/KNuikONqyFs76OeG3hFV4ltYB326E
Z+W5Xppvamev0554BmuV01ppnhauYS6WdeWNx776DYynfhXrYkVb9nHnv0Jxl8ujgt8iLv8Kccvk
Xy76CWEpFqID9aUYRM7RlqM7zeOIcf0tFrDzJ9NigVbF0RbzMIQY4beaW8eIu90wV6OWYJqsS7QK
czCbFQv4dhFnq3rF/C5rR1kxcsk52vKrYpZ2/izt8kfjcR+V10zdNzNEF8WjF6myj6C77sNHpJuu
8R+OWzws2TRlO1X0FAzWek0R95AiTBb9oHb7l+U/STgRQ4kPSHu/61soFD1Bd8J43VnjJBmrW2xM
PPYY1t7yfLjYeVxXN4s8+Y+Oc6MVYZTmNFJ4n+KMEA4XDhMOZY0702OoKjkkPoKTWdEW9yjWIFkP
FN4tHCCP/uhHvEsS9VvyDvsK75RNH341WJ651j3eW3O/Q2ell7PKr+ZN5MboyVHd+vTUXu2hCLcL
s4XqxFoNy3r4su2mXZHJKlp0jcu6yi6D9e5NLkNcF5359PgI6tCiLdSfcZtQ3ZlfIh3VITrqJkjh
6rrTlqx6d2BXnESug2bmaMu91TqzdvJOQludKPVt1r4NYwdCy3gxffu12ieoBiGdliCee6AbwFdm
6tf8vnL7BuqwxnReFzV9v8A/fLHSzWTh/wNDOvciCmVuZHN0cmVhbQplbmRvYmoKMjcgMCBvYmoK
MjE2NQplbmRvYmoKMjggMCBvYmoKPDwgL1R5cGUgL0ZvbnREZXNjcmlwdG9yIC9Bc2NlbnQgNzU0
IC9DYXBIZWlnaHQgNTg3IC9EZXNjZW50IC0yNDYgL0ZsYWdzCjUgL0ZvbnRCQm94IFsgLTE2NCAt
NDEwIDc0NCA4NzYgXSAvRm9udE5hbWUgL1RPQUtWSCtDb3VyaWVyIC9JdGFsaWNBbmdsZQowIC9T
dGVtViAwIC9NYXhXaWR0aCA4MjMgL1hIZWlnaHQgNDU3IC9Gb250RmlsZTIgMjYgMCBSID4+CmVu
ZG9iagoyOSAwIG9iagpbIDYwMCBdCmVuZG9iagozMCAwIG9iago8PCAvTGVuZ3RoIDMxIDAgUiAv
RmlsdGVyIC9GbGF0ZURlY29kZSA+PgpzdHJlYW0KeNpdkM+KwyAQxu8+xRy7h6LJrSDC0qWQw/6h
2X0Ao5NU2KhMzCFvX7WhC3vwg5lvfsPn8HP31nmXgH9RMD0mGJ23hEtYySAMODnPmhasM2mvqppZ
R8Yz3G9LwrnzYwApGQC/ZntJtMHh1YYBX0rvkyyS8xMcfs597fRrjL84o08gmFJgcczr3nX80DMC
r+ixs9l3aTtm6m/ie4sIba2bRyQTLC5RGyTtJ2RSCCUvF8XQ23/WDgyjuWlism2UBCHEqYguYqFi
+0BZUD76DGZWopypXqOGKTGcx+fBYoiFqu8OoSNwwwplbmRzdHJlYW0KZW5kb2JqCjMxIDAgb2Jq
CjIyOQplbmRvYmoKOSAwIG9iago8PCAvVHlwZSAvRm9udCAvU3VidHlwZSAvVHJ1ZVR5cGUgL0Jh
c2VGb250IC9UT0FLVkgrQ291cmllciAvRm9udERlc2NyaXB0b3IKMjggMCBSIC9XaWR0aHMgMjkg
MCBSIC9GaXJzdENoYXIgMzMgL0xhc3RDaGFyIDMzIC9Ub1VuaWNvZGUgMzAgMCBSCj4+CmVuZG9i
agozMiAwIG9iago8PCAvQXV0aG9yIChHaWxsZXMgTGVuZmFudCkgL0NyZWF0b3IgKFRleHRXcmFu
Z2xlcikgL0NyZWF0aW9uRGF0ZSAoRDoyMDA3MDMxMTE3MDMzMCswMScwMCcpCi9Nb2REYXRlIChE
OjIwMDcwMzExMTcwMzMwKzAxJzAwJykgL1Byb2R1Y2VyIChNYWMgT1MgWCAxMC40LjggUXVhcnR6
IFBERkNvbnRleHQpCi9UaXRsZSAodW50aXRsZWQgdGV4dCAyKSA+PgplbmRvYmoKeHJlZgowIDMz
CjAwMDAwMDAwMDAgMDAwMDAgbiAKMDAwMDAwMjU2NiAwMDAwMCBuIAowMDAwMDAwMDIyIDAwMDAw
IG4gCjAwMDAwMDI2NzEgMDAwMDAgbiAKMDAwMDAwMjU0NiAwMDAwMCBuIAowMDAwMDAzNjM0IDAw
MDAwIG4gCjAwMDAwMTU5MjQgMDAwMDAgbiAKMDAwMDAxMTQ5NiAwMDAwMCBuIAowMDAwMDI3MTQ3
IDAwMDAwIG4gCjAwMDAwMzAxNjUgMDAwMDAgbiAKMDAwMDAwMzY3MCAwMDAwMCBuIAowMDAwMDAy
ODA1IDAwMDAwIG4gCjAwMDAwMDM2MTQgMDAwMDAgbiAKMDAwMDAwMzc1NCAwMDAwMCBuIAowMDAw
MDAzODA1IDAwMDAwIG4gCjAwMDAwMTA4NzIgMDAwMDAgbiAKMDAwMDAxMDg5MyAwMDAwMCBuIAow
MDAwMDExMTIwIDAwMDAwIG4gCjAwMDAwMTE2NzMgMDAwMDAgbiAKMDAwMDAxNTMzNiAwMDAwMCBu
IAowMDAwMDE1MzU3IDAwMDAwIG4gCjAwMDAwMTU1ODQgMDAwMDAgbiAKMDAwMDAxNjEwMSAwMDAw
MCBuIAowMDAwMDI2NTIzIDAwMDAwIG4gCjAwMDAwMjY1NDUgMDAwMDAgbiAKMDAwMDAyNjc2NyAw
MDAwMCBuIAowMDAwMDI3MzE5IDAwMDAwIG4gCjAwMDAwMjk1NzQgMDAwMDAgbiAKMDAwMDAyOTU5
NSAwMDAwMCBuIAowMDAwMDI5ODE2IDAwMDAwIG4gCjAwMDAwMjk4NDAgMDAwMDAgbiAKMDAwMDAz
MDE0NSAwMDAwMCBuIAowMDAwMDMwMzI2IDAwMDAwIG4gCnRyYWlsZXIKPDwgL1NpemUgMzMgL1Jv
b3QgMTMgMCBSIC9JbmZvIDMyIDAgUiAvSUQgWyA8NDZkNjJiOTk5M2M5MGY1NGI2MmNjMDAxNzFi
ZjE4MTU+Cjw0NmQ2MmI5OTkzYzkwZjU0YjYyY2MwMDE3MWJmMTgxNT4gXSA+PgpzdGFydHhyZWYK
MzA1NDMKJSVFT0YK
"""
LOREM_IPSUM_PDF = base64.decodestring(LOREM_IPSUM_PDF)
