#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""Functions for generating unique ids.

   Although this doesn't implement it, it's worthwhile reading RFC 4122 [1],
   "A Universally Unique IDentifier (UUID) URN Namespace" for some thoughts
   on the subject. At some point we could look at implementing RFC 4122 here,
   or replacing these functions with calls to an external RFC 4122 implementation.

   [1] http://www.rfc-archive.org/getrfc.php?rfc=4122
   """

# Copyright 2006 St James Software

import time
import random
import sys

if sys.platform == "win32":
    # on Windows, time.time() returns millisecond resolution, but seems to only be updated on a roughly 10-millisecond timer
    TIME_PRECISION = 2
else:
    TIME_PRECISION = 6
RAND_PRECISION = 12-TIME_PRECISION
RAND_FORMAT = "%0"+str(RAND_PRECISION)+"d"

def uid_digit_str(base_time=None):
    """Returns a unique string consisting only of digits.
       Generated using the current time (unless specified) and a random integer
       to complete it to 22 digits"""
    base_time = base_time or time.time()
    return str(int(base_time*10**TIME_PRECISION)) + (RAND_FORMAT % random.randint(1,10**RAND_PRECISION))

def uid_id_str(base_time=None):
    """Returns a unique string consisting of the prefix ID followed by only digits.
       Generated by calling uid_digit_str."""
    return "ID" + uid_digit_str(base_time)

