#!/usr/bin/env python

from setuptools import setup, find_packages

setup(name='jabber-roster',
      version='0.1.0',
      py_modules=['jabber_roster'],
      entry_points = {
        'console_scripts': ['jabber-roster = jabber_roster:main'],
      },
      install_requires=['xmpppy'],
      author='Kamil Paral',
      author_email='kamil.paral@gmail.com',
      description='Tool for listing Jabber roster contacts',
      long_description='A small Python tool for listing your Jabber roster contacts. You can use it to easily backup list of your buddies.',
      keywords='Jabber XMPP roster contacts commandline',
      license='GNU Affero GPL v3',
      url='https://code.launchpad.net/jabber-roster',
      download_url='https://launchpad.net/jabber-roster/+download',
      classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU Affero General Public License v3',
        'Natural Language :: English',
        'Operating System :: POSIX',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
        'Topic :: Communications :: Chat',
        'Topic :: Internet',
        'Topic :: Utilities'
      ])
