## Customization

The java2python compiler defers a significant amount of its processing to
handlers defined within configuration files.  These configuration files,
directories, and modules are supplied to the `j2py` script on the command
line. See the [usage][] page for instructions on specifying additional configs.

The default configuration module is `java2python.config.default`.  Refer to
[the source of that module][1] for details and additional descriptions.


### Usage

To change the behavior of some or all of these config items, create a Python
file, define in it the items you want, and specify that file when invoking
`j2py`.

For example, if you would like to change the comment prefix to `##`, you might
do this:

    $ echo "indentPrefix = '##'" >> ./myconfig.py

Then run the script:

    $ j2py SomeJavaSource.java -c ./myconfig.py 

The config files are Python modules, so you can use the full power of Python
when writing them.


### Defaults

Many of the defaults are built using values imported from the
`java2python.mod.basic` module.  Refer to the [source of that module][2] for
details.  The `java2python.mod` subpackage contains other modules with
additional config handlers.


### A Note About Some of the Names:  Prologue, Base, Head, and Epilogue

When a config point has `Prologue` in its name, it means that the item will be
responsible for generating code before the output.  For example, method
prologue handlers generate decorators, while module prologue handlers generate
the shebang line.

When a config point has `Base` in the name, it means that the item will be
responsible for generating the base classes of a class, enum, or interface.

A config point with `Head` in the name means that the item will be responsible
for generating code for the section between the declaration and the body of the
item.  For example:

    class X(object):
        """ this is a comment generated by classHeadHandlers """

Finally, when a config point contains `Epilogue`, it means that the item will
be responsible for generating code after the body of the item.  The only
recognized epilogue config point is `moduleEpilogueHandlers`, which (by
default) generates a main script stanza if necessary.


### Override vs. Replace

Many of the config handlers in the default config module are lists or
dictionaries.  It may be desirable for your project to supplement or modify
these instead of changing them completely.  For example, you could add a module
prologue handler to the existing values.  To do so, you would do something like this
in your config:

    from java2python.config.default import modulePrologueHandlers

    def myPrologue(module):
        ...
        
    modulePrologueHandlers.append(myPrologue)
    
Values can be removed in a similar way:

    from java2python.config.default import modulePrologueHandlers
    from java2python.mod import basic

    modulePrologueHandlers.remove(basic.shebangLine)

In other cases, you can simply redefine the config value altogether:

    classHeadHandlers = [myCustomDocStringGenerator]


### Customization Points

The remainder of this page lists the recognized config points, their meaning,
and their default values.


#### <a name="indentPrefix"></a>indentPrefix

Leading indent character or characters.  Four spaces are the default because
that is the recommendation of [PEP 8][].

Default:  `    ` (four spaces)


#### <a name="commentPrefix"></a>commentPrefix

Prefix character or characters for comments.  The hash+space is recommended by
[PEP 8][].

Default:  `# ` (hash + space)


#### <a name="expressionVariableNamingHandler"></a>expressionVariableNamingHandler

When the compiler needs to make up a variable name (for example, to emulate
assignment expressions), it calls this handler to produce a new one.

Default:  `basic.globalNameCounter`


#### <a name="modulePrologueHandlers"></a>modulePrologueHandlers

These values are strings or generators that yield strings for a module
prologue.

Default:
```
[basic.shebangLine,
 basic.simpleDocString,
 basic.maybeBsr,
 basic.maybeSyncHelpers
]
```


#### <a name="moduleEpilogueHandlers"></a>moduleEpilogueHandlers

These generators yield lines for a module epilogue.

Default: `[basic.scriptMainStanza]`


#### <a name="moduleOutputHandlers"></a>moduleOutputHandlers

These generators yield (possibly modified) source strings for a module.  The
default handler uses values defined elsewhere in the config, e.g.,
`moduleOutputSubs`.

Default: `[basic.outputSubs]`


#### <a name="modulePackageDeclarationHandler"></a>modulePackageDeclarationHandler

This config item is called to handle package declarations.  The default handler simply
turns those declarations into comments.

Default: `basic.commentedPackages`


#### <a name="moduleImportDeclarationHandler"></a>moduleImportDeclarationHandler

This config item is called to handle import statements.  The default handler
transforms the import statements into Python imports.

Default:  `basic.simpleImports`


#### <a name="moduleOutputSubs"></a>moduleOutputSubs

Mapping of input/output regular expressions used during the final pass of
source generation.

Default: refer to the [java2python.config.default][1] module.


#### <a name="classHeadHandlers"></a>classHeadHandlers

These generators yield doc values for the head of classes.

Default: `[basic.simpleDocString]`


#### <a name="classBaseHandlers"></a>classBaseHandlers

These generators yield the base types (as strings) for classes.

Default: `[basic.defaultBases]`


#### <a name="classPostWalkHandlers"></a>classPostWalkHandlers

These handlers are called with each class object after it has been completely
constructed.

Default: `[]`


#### <a name="interfaceBaseHandlers"></a>interfaceBaseHandlers

These generators yield the base types (as strings) for interfaces.

Default: `[basic.defaultBases]`


#### <a name="interfaceHeadHandlers"></a>interfaceHeadHandlers

These generators yield doc values for the head of interfaces.

Default:  `[basic.simpleDocString, '__metaclass__ = ABCMeta']`


#### <a name="enumHeadHandlers"></a>enumHeadHandlers

These generators yield doc values for the head of enums.

Default: `[basic.simpleDocString]`


#### <a name="enumValueHandler"></a>enumValueHandler

This handler is responsible for creating enum values on classes after they've
been defined.

Default:  `basic.enumConstStrings`


#### <a name="methodParamHandlers"></a>methodParamHandlers

This handler is responsible for constructing method parameters.

Default: `[basic.defaultParams]`


#### <a name="methodLockFunctionName"></a>methodLockFunctionName

This is the name of the callable used to construct locks for an object with the
synchronized keyword.

Default: `'lock_for_object'`


#### <a name="methodHeadHandlers"></a>methodHeadHandlers

These generators yield values for the head of classes.

Default: `[basic.simpleDocString]`


#### <a name="methodPrologueHandlers"></a>methodPrologueHandlers

These generators yield values for the module prologue.

Default:

```
[basic.maybeAbstractMethod,
 basic.maybeClassMethod,
 basic.maybeSynchronizedMethod,
 basic.overloadedClassMethods,
]
```

#### <a name="astTransforms"></a>astTransforms

The AST transformer uses these declarations to modify an AST before compiling
it to Python source.

Default: refer to the [java2python.config.default][1] module.

#### <a name="typeSubs"></a>typeSubs

Many Java identifiers have a 1:1 relationship with Python identifiers, and this
mapping is used to convert them when found.  Note that this mapping is now
unnecessary and will be folded into the `astTransforms` sequence in future
releases.

[1]: https://github.com/natural/java2python/blob/master/java2python/config/default.py
[2]: https://github.com/natural/java2python/blob/master/java2python/mod/basic.py
[PEP 8]: http://www.python.org/dev/peps/pep-0008/
[usage]: https://github.com/natural/java2python/tree/master/doc/usage.md
