import datetime
import os.path
import re
import yaml

from dateutil import parser

__all__ = ["Page"]


def process_jekyll_page(contents):
    yaml_lines = []
    body_lines = []
    in_yaml = False
    for line in contents.split("\n"):
        if in_yaml:
            if line == "---":
                in_yaml = False
            else:
                yaml_lines.append(line)
        else:
            if line == "---":
                in_yaml = True
            else:
                body_lines.append(line)
    yaml_str = "\n".join(yaml_lines)
    body_str = "\n".join(body_lines)
    return yaml.load(yaml_str, Loader=yaml.CLoader), body_str


class Page(object):
    def __init__(self, path):
        self.path = os.path.expanduser(path)
        with open(self.path, "r") as fh:
            contents = fh.read()
            self._metadata, self._body = process_jekyll_page(contents)
    
    @property
    def title(self):
        return self._metadata["title"].decode("utf-8")
    
    @property
    def body(self):
        return self._body.decode("utf-8")
    
    @property
    def timestamp(self):
        basename = os.path.basename(self.path)
        title_regex = re.compile(r"^(\d{4}-\d{2}-\d{2})-.*$")
        match = title_regex.match(basename)
        date = match.group(1) + " " + self._metadata.get("time", "00:00 -0500")
        return parser.parse(date)
    
    @property
    def is_published(self):
        return self._metadata.get("published", True)
    
    def __str__(self):
        return self._body
    
    def __unicode__(self):
        return self.body
