'''
Created on Mar 17, 2014

@author: scrosby
'''
import xml.etree.ElementTree as etree

class Config:
    TEMPLATE = u"<scm class=\"hudson.plugins.git.GitSCM\" plugin=\"git@1.5.0\">\n    <configVersion>2</configVersion>\n    <userRemoteConfigs>\n      <hudson.plugins.git.UserRemoteConfig>\n        <name></name>\n        <refspec></refspec>\n        <url>git@github.dev.ca1.sfmc.co:MarketingCloud/webcore.git</url>\n      </hudson.plugins.git.UserRemoteConfig>\n    </userRemoteConfigs>\n    <branches>\n      <hudson.plugins.git.BranchSpec>\n        <name>master</name>\n      </hudson.plugins.git.BranchSpec>\n    </branches>\n    <disableSubmodules>false</disableSubmodules>\n    <recursiveSubmodules>false</recursiveSubmodules>\n    <doGenerateSubmoduleConfigurations>false</doGenerateSubmoduleConfigurations>\n    <authorOrCommitter>false</authorOrCommitter>\n    <clean>false</clean>\n    <wipeOutWorkspace>false</wipeOutWorkspace>\n    <pruneBranches>false</pruneBranches>\n    <remotePoll>false</remotePoll>\n    <ignoreNotifyCommit>false</ignoreNotifyCommit>\n    <useShallowClone>false</useShallowClone>\n    <buildChooser class=\"hudson.plugins.git.util.DefaultBuildChooser\"/>\n    <gitTool>Default</gitTool>\n    <submoduleCfg class=\"list\"/>\n    <relativeTargetDir></relativeTargetDir>\n    <reference></reference>\n    <excludedRegions></excludedRegions>\n    <excludedUsers></excludedUsers>\n    <gitConfigName></gitConfigName>\n    <gitConfigEmail></gitConfigEmail>\n    <skipTag>false</skipTag>\n    <includedRegions></includedRegions>\n    <scmName></scmName>\n  </scm>"

    def __init__(self, configxml):
        self.xml = configxml
        
    def create_git_config(self):
        data = etree.fromstring(self.xml)
        scm = data.find('scm')
        module = scm.findall('.//remoteName')[0].text
        branch = scm.findall('.//locationType')[0].text
        index = data.getchildren().index(scm)
        data.remove(scm)
        git = etree.fromstring(self.TEMPLATE)
        git.find('userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/url').text = 'git@github.dev.ca1.sfmc.co:MarketingCloud/{}.git'.format(module)
        if branch != 'HEAD':
            git.find('branches/hudson.plugins.git.BranchSpec/name').text = branch
        data.insert(index, git)
        
        return etree.tostring(data)
    
    def get_cvs_repo(self):
        data = etree.fromstring(self.xml)
        scm = data.find('scm')
        data = scm.findall(".//remoteName")
        if len(data) > 0:
            repo = data[0].text
        else:
            repo = None
        return repo