'''
Created on Mar 17, 2014

@author: scrosby
'''
import xml.etree.ElementTree as etree
import re

class Config:
    TEMPLATE = u"<scm class=\"hudson.plugins.git.GitSCM\" plugin=\"git@1.5.0\">\n    <configVersion>2</configVersion>\n    <userRemoteConfigs>\n      <hudson.plugins.git.UserRemoteConfig>\n        <name></name>\n        <refspec></refspec>\n        <url>git@github.dev.ca1.sfmc.co:MarketingCloud/webcore.git</url>\n      </hudson.plugins.git.UserRemoteConfig>\n    </userRemoteConfigs>\n    <branches>\n      <hudson.plugins.git.BranchSpec>\n        <name>master</name>\n      </hudson.plugins.git.BranchSpec>\n    </branches>\n    <disableSubmodules>false</disableSubmodules>\n    <recursiveSubmodules>false</recursiveSubmodules>\n    <doGenerateSubmoduleConfigurations>false</doGenerateSubmoduleConfigurations>\n    <authorOrCommitter>false</authorOrCommitter>\n    <clean>false</clean>\n    <wipeOutWorkspace>false</wipeOutWorkspace>\n    <pruneBranches>false</pruneBranches>\n    <remotePoll>false</remotePoll>\n    <ignoreNotifyCommit>false</ignoreNotifyCommit>\n    <useShallowClone>false</useShallowClone>\n    <buildChooser class=\"hudson.plugins.git.util.DefaultBuildChooser\"/>\n    <gitTool>Default</gitTool>\n    <submoduleCfg class=\"list\"/>\n    <relativeTargetDir></relativeTargetDir>\n    <reference></reference>\n    <excludedRegions></excludedRegions>\n    <excludedUsers></excludedUsers>\n    <gitConfigName></gitConfigName>\n    <gitConfigEmail></gitConfigEmail>\n    <skipTag>false</skipTag>\n    <includedRegions></includedRegions>\n    <scmName></scmName>\n  </scm>"
    PUBLISHER = u"\n    <hudson.plugins.git.GitPublisher plugin=\"git@1.5.0\">\n      <configVersion>2</configVersion>\n      <pushMerge>false</pushMerge>\n      <pushOnlyIfSuccess>true</pushOnlyIfSuccess>\n      <tagsToPush>\n        <hudson.plugins.git.GitPublisher_-TagToPush>\n          <targetRepoName>origin</targetRepoName>\n          <tagName>R6_${versionNumber}</tagName>\n          <tagMessage>Successful Build Tag</tagMessage>\n          <createTag>true</createTag>\n          <updateTag>true</updateTag>\n        </hudson.plugins.git.GitPublisher_-TagToPush>\n      </tagsToPush>\n    </hudson.plugins.git.GitPublisher>"
    def __init__(self, configxml):
        self.xml = configxml
        
    def create_git_config(self):
        data = etree.fromstring(self.xml)
        scm = data.find('scm')
        module = scm.findall('.//remoteName')[0].text
        branch = scm.findall('.//locationType')[0].text
        index = data.getchildren().index(scm)
        data.remove(scm)
        git = etree.fromstring(self.TEMPLATE)
        git.find('userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/name').text = 'origin'
        git.find('userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/url').text = 'git@github.dev.ca1.sfmc.co:MarketingCloud/{}.git'.format(module)
        if branch != 'HEAD':
            git.find('branches/hudson.plugins.git.BranchSpec/name').text = branch
        data.find('publishers').append(etree.fromstring(self.PUBLISHER))
        data.insert(index, git)
        self.xml = etree.tostring(data)
        return self.xml
    
    def set_git_branch(self, branch):
        data = etree.fromstring(self.xml)
        data.find('scm/branches/hudson.plugins.git.BranchSpec/name').text = branch
        
        self.xml = etree.tostring(data)
        return self.xml
    
    def get_git_branch(self):
        data = etree.fromstring(self.xml)
        return data.find('scm/branches/hudson.plugins.git.BranchSpec/name').text
    
    def get_git_module(self):
        data = etree.fromstring(self.xml)
        url = data.find('scm/userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/url').text
        regex = re.compile(":MarketingCloud/(?P<module>.*)")
        match = regex.search(url)
        if match is not None:
            module = match.group('module').replace('.git','')
        else:
            module = None
            print url
            
        return module
    
    def set_git_remote_name(self, remote):
        data = etree.fromstring(self.xml)
        data.find('scm/userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/name').text = remote
        
        self.xml = etree.tostring(data)
        return self.xml
    
    def get_remote_name(self):
        data = etree.fromstring(self.xml)
        return data.find('scm/userRemoteConfigs/hudson.plugins.git.UserRemoteConfig/name').text
    
    def add_git_publisher(self):
        data = etree.fromstring(self.xml)
        data.find('publishers').append(etree.fromstring(self.PUBLISHER))
        
        self.xml = etree.tostring(data)
        
        return self.xml
    
    def is_configured_for_git(self):
        data = etree.fromstring(self.xml)
        git = data.find('scm/branches/hudson.plugins.git.BranchSpec')
        return git is not None
    
    def has_git_publisher(self):
        data = etree.fromstring(self.xml)
        pub = data.find('publishers/hudson.plugins.git.GitPublisher')
        return pub is not None
    
    def get_cvs_repo(self):
        data = etree.fromstring(self.xml)
        scm = data.find('scm')
        data = scm.findall(".//remoteName")
        if len(data) > 0:
            repo = data[0].text
        else:
            repo = None
        return repo