DOCS = """
Jenks is a command-line tool to work with a jenkins host and jobs.

Configuration (.jenksrc)
========================

Jenks requires a .jenksrc file to configure itself. jenks searches in
the current directory and moves up parent directories until it finds one.

A .jenksrc file should be a yaml file, with a dictionary of hosts and
some keys for configuration.

Here is an example .jenksrc file with all options:

    'localhost':
      url: 'http://localhost:8080/'
      jobs:
        - foo
        - bar
    'http://jenkins.local':
      jobs:
        - baz

the in-depth configuration for a host is:

* url: the url to the host. If the url doesn't exist, the host
       name is used as the url
* jobs: a list of job names to add to the list

Keys
====

By default, jenks will perform operations on all jobs in the
configuration. However, you can restrict the jobs to specific ones by
passing a list of keys. Each job is given a unique key generated by
jenks. For example, using -l on the example configuration will yield:

    $ jenks -l
    0 http://jenkins.local baz
    1 localhost foo 
    2 localhost bar

The character at the beginning of each line is the key. Each key is a
single character in the set: [0-9a-zA-Z]. You can pass in a string of characters to get information about those:

    $ jenks -l 20
    0 http://jenkins.local baz
    2 localhost bar

You can pass in keys by:

* keys as an argument:

    $ jenks -c 0

* keys with standard in:

    $ echo '0' | jenks

Examples
========

Ones of jenks' goals is to follow the Unix philosophy of doing one
thing and doing it well. By being a modular part and supporting stdin,
it's possible to chain jenks with other commands.

For example, here's a command that only lists status whose host or jobs match a specific regex:

    $ jenks -l | grep "foo" | cut -d ' ' -f 1 | jenks
    0: localhost, foo (last build #7) SUCCESS

Usage
=====

{0}
""".strip()
