#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-
# generated by wxGlade 0.6.3 on Wed Jun 04 10:16:50 2008

import wx

# begin wxGlade: extracode
# end wxGlade



class Frame(wx.Frame):
    def __init__(self, *args, **kwds):
        
        logformat     = kwds.get("logformat",None)
        if logformat:
            del kwds["logformat"]
            
        self.infoxxx  = kwds.get("info",None)
        if self.infoxxx:
            del kwds["info"]
            
        # begin wxGlade: Frame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.logsplitter = wx.SplitterWindow(self, -1, style=wx.SP_NOBORDER)
        self.apptreesplitter = wx.Panel(self.logsplitter, -1)
        self.top_window = wx.SplitterWindow(self.apptreesplitter, -1, style=wx.SP_3D|wx.SP_BORDER)
        self.app_panel = wx.Panel(self.top_window, -1)
        self.tree_panel = wx.Panel(self.top_window, -1, style=wx.NO_BORDER|wx.TAB_TRAVERSAL)
        
        # Menu Bar
        self.menubar = wx.MenuBar()
        self.File = wx.Menu()
        self.Exit = wx.MenuItem(self.File, wx.NewId(), "E&xit", "Terminate the program", wx.ITEM_NORMAL)
        self.File.AppendItem(self.Exit)
        self.menubar.Append(self.File, "File")
        self.Help = wx.Menu()
        self.About = wx.MenuItem(self.Help, wx.NewId(), "About", "About prospero shell", wx.ITEM_NORMAL)
        self.Help.AppendItem(self.About)
        self.menubar.Append(self.Help, "Help")
        self.SetMenuBar(self.menubar)
        # Menu Bar end
        self.statusbar = self.CreateStatusBar(1, 0)
        self.app_tree = wx.TreeCtrl(self.tree_panel, -1, style=wx.TR_HAS_BUTTONS|wx.TR_LINES_AT_ROOT|wx.TR_DEFAULT_STYLE|wx.SUNKEN_BORDER)
        self.logctrl = wx.TextCtrl(self.logsplitter, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY)

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_MENU, self.__onExit, self.Exit)
        self.Bind(wx.EVT_MENU, self.__onAbout, self.About)
        # end wxGlade
        
        self.__bind_logger(logformat)

    def __set_properties(self):
        # begin wxGlade: Frame.__set_properties
        self.SetTitle("Prospero Shell")
        self.SetSize((-1, -1))
        self.statusbar.SetStatusWidths([-1])
        # statusbar fields
        statusbar_fields = ["prospero shell"]
        for i in range(len(statusbar_fields)):
            self.statusbar.SetStatusText(statusbar_fields[i], i)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: Frame.__do_layout
        frame_sizer = wx.BoxSizer(wx.VERTICAL)
        top_sizer = wx.BoxSizer(wx.HORIZONTAL)
        app_sizer = wx.BoxSizer(wx.HORIZONTAL)
        tree_sizer = wx.BoxSizer(wx.HORIZONTAL)
        tree_sizer.Add(self.app_tree, 1, wx.EXPAND, 0)
        self.tree_panel.SetSizer(tree_sizer)
        self.app_panel.SetSizer(app_sizer)
        self.top_window.SplitVertically(self.tree_panel, self.app_panel, 150)
        top_sizer.Add(self.top_window, 1, wx.EXPAND, 0)
        self.apptreesplitter.SetSizer(top_sizer)
        self.logsplitter.SplitHorizontally(self.apptreesplitter, self.logctrl, 387)
        frame_sizer.Add(self.logsplitter, 1, wx.EXPAND, 0)
        self.SetSizer(frame_sizer)
        self.Layout()
        # end wxGlade

    def __onExit(self, event): # wxGlade: Frame.<event_handler>
        self.Close(True)

    def __onAbout(self, event): # wxGlade: Frame.<event_handler>
        from qmpy.python.about import AboutBox
        a = AboutBox()
        a.show(self,event,self.infoxxx)
        
    def __bind_logger(self,logformat):
        from jflow.gui.frames import WxLog
        import logging
        hdlr = WxLog(self.logctrl)
        rootLogger = logging.getLogger('')
        rootLogger.setLevel(logging.DEBUG)
        
        if logformat:
            format   = logging.Formatter(logformat)
            hdlr.setFormatter(format)
            
        rootLogger.addHandler(hdlr)
        
        from twisted.python import log
        observer = log.PythonLoggingObserver()
        observer.start()


# end of class Frame


if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    frame = Frame(None, -1, "", size=(800,600))
    app.SetTopWindow(frame)
    frame.Show()
    app.MainLoop()
