
import ConfigParser
import os
import argparse

class JBLconfig:
    def __init__(self):
        pass
        
    def __argparse_setup(self):
        prg_description="Uses template file to create many tasks in Jira at once"
        prg_epilog="""Report bugs to: <https://bitbucket.org/oktopuz/jira-bulk-loader/issues>
Project home page: <https://bitbucket.org/oktopuz/jira-bulk-loader>"""

        parser = argparse.ArgumentParser(description=prg_description, formatter_class=argparse.RawDescriptionHelpFormatter, epilog=prg_epilog)

        parser.add_argument('template_file', type=argparse.FileType('rU'), help='file containing tasks definition')
        parser.add_argument('-W', dest='project', help='Project key')
        parser.add_argument('-R', dest='priority', help='Task priority. "Medium" by default', default="Medium")
        parser.add_argument('-D', dest='dueDate', help='dueDate  (YYYY-mm-DD). For example: 2012-05-31')
        parser.add_argument('--dry', dest='dry_run', action='store_true', \
            help='Make a dry run. It checks everything but does not create tasks', default=False)

        mandatory = parser.add_argument_group('mandatory arguments')
        mandatory.add_argument('-H', dest='hostname', required=True, help='Jira hostname with http:// or https://')
        mandatory.add_argument('-U', dest='username', required=True, help='your Jira username')
        mandatory.add_argument('-P', dest='password', required=True, help='your Jira password')

        return parser.parse_args()


    def __read_config_file(path_to_executable):
        """
        Read configuration file and return dict of options.

        The config file (jira-bulk-loader.cfg) must be located either 
        in the same directory as 'path_to_executable' or in ~/.config/jira-bulk-loader/.
        The only possible section is 'connection'.

        Example:
        [connection]
        hostname = https://jira.atlassian.com
        username = my_jira_user
        """

        r = {}
        config = ConfigParser.RawConfigParser()

        project_name = 'jira-bulk-loader'
        default_cfg_filename = project_name + '.cfg'

        config.read([ \
            os.path.join(os.path.dirname(path_to_executable), default_cfg_filename), \
            os.path.join(os.path.expanduser('~/.config/' + project_name), default_cfg_filename)
            ])

        try:
            for item in config.items('connection'):
                r[item[0]] = item[1]
        except ConfigParser.NoSectionError:
            pass

        return r



