#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
#=============================================================================
#
#     FileName: jpush_py.py
#         Desc: jpush的python client
#
#       Author: dantezhu
#        Email: zny2008@gmail.com
#     HomePage: http://www.vimer.cn
#
#      Created: 2013-10-05 14:13:22
#      History:
#               0.0.1 | dantezhu | 2013-10-05 14:13:22 | init
#
#=============================================================================
"""
__version__ = (0, 1, 2)

import copy
import urllib, urllib2
import json
import logging
import hashlib
import time

logger = logging.getLogger('jpush_py')

SEND_MSG_URL = 'http://api.jpush.cn:8800/sendmsg/v2/sendmsg'
REQUIRED_KEYS = set(('receiver_type', 'msg_type', 'msg_content', 'platform'))
 
class JPushPy(object):
    """jpush's python client"""

    _sendno = None

    def __init__(self, app_key, master_secret):
        if self.__class__._sendno is None:
            self.__class__._sendno = int(time.time())

        self._app_key = app_key
        self._master_secret = master_secret

    @classmethod
    def generate_sendno(cls):
        """
        生成递增的sendno
        """
        cls._sendno += 1
        return cls._sendno 

    def generate_verification_code(self, params):
        """
        生成验证码
        """
        m = hashlib.md5()
        str = "%s%s%s%s" % (params['sendno'], params['receiver_type'], params.get('receiver_value', ''), self._master_secret)
        m.update(str)
        return m.hexdigest().upper()

    def generate_params(self, params):
        """
        生成新的params
        """
        new_params = dict()

        sendno = params.get('sendno', self.generate_sendno())

        for k, v in params.items():
            if k == 'msg_content' and isinstance(v, basestring):
                # 说明传了字符串进来
                if params['msg_type'] == 1:
                    v = dict(
                        n_content=v
                    )
                else:
                    v = dict(
                        message=v
                    )

            if isinstance(v, dict):
                new_params[k] = json.dumps(v)
            elif isinstance(v, unicode):
                new_params[k] = v.encode('utf-8')
            else:
                new_params[k] = v

        new_params['sendno'] = sendno
        new_params['app_key'] = self._app_key
        new_params['verification_code'] = self.generate_verification_code(new_params)

        return new_params
        

    def send_msg(self, params, timeout=None):
        """
        发送消息
        """
        logger.debug('params: ' + repr(params))

        # 换成set来进行与运算
        if len(REQUIRED_KEYS & set(params.keys())) != len(REQUIRED_KEYS):
            return dict(
                sendno=params.get('sendno', None),
                errcode=-1000,
                errmsg=u'参数错误',
            )

        new_params = self.generate_params(params)

        logger.debug('new_params: ' + repr(new_params))

        encode_params = urllib.urlencode(new_params)

        try:
            data = urllib2.urlopen(SEND_MSG_URL, encode_params, timeout).read()
        except Exception, e:
            logger.error('exception occur.msg[%s], traceback[%s]' % (str(e), __import__('traceback').format_exc()))
            return dict(
                sendno=new_params['sendno'],
                errcode=-1001,
                errmsg=u'网络错误',
            )

        try:
            jdata = json.loads(data)
        except Exception, e:
            logger.error('exception occur.msg[%s], traceback[%s]' % (str(e), __import__('traceback').format_exc()))
            return dict(
                sendno=new_params['sendno'],
                errcode=-1002,
                errmsg=u'返回包解析错误',
            )

        return jdata

if __name__ == '__main__':
    import logging
    import jpush_py

    jpush_py.logger.addHandler(logging.StreamHandler())
    jpush_py.logger.setLevel(logging.DEBUG)

    client = jpush_py.JPushPy('your app_key', 'your master secret')
    params = dict(
        receiver_type=4,
        msg_type=1,
        #msg_content=dict(n_content=u'我爱你'),
        msg_content=u'我想你',
        platform='android',
    )
    print client.send_msg(params, 10)
