from fanstatic import Library, Resource

library = Library('angularjs', 'resources')

angular                       = Resource(library, 'angular.js',
                                         minified='angular.min.js')
angular_bootstrap             = Resource(library, 'angular-bootstrap.js',
                                         minified='angular-bootstrap.min.js',
                                         depends=[angular])
angular_bootstrap_prettify    = Resource(library, 'angular-bootstrap-prettify.js',
                                         minified='angular-bootstrap-prettify.min.js',
                                         depends=[angular])
angular_cookies               = Resource(library, 'angular-cookies.js',
                                         minified='angular-cookies.min.js',
                                         depends=[angular])
angular_loader                = Resource(library, 'angular-loader.js',
                                         minified='angular-loader.min.js')
angular_mocks                 = Resource(library, 'angular-mocks.js',
                                         depends=[angular])
angular_resource              = Resource(library, 'angular-resource.js',
                                         minified='angular-resource.min.js',
                                         depends=[angular])
angular_sanitize              = Resource(library, 'angular-sanitize.js',
                                         minified='angular-sanitize.min.js',
                                         depends=[angular])
angular_scenario              = Resource(library, 'angular-scenario.js')

_langs = [
    'am',
    'am-et',
    'ar',
    'ar-eg',
    'bg',
    'bg-bg',
    'bn',
    'bn-bd',
    'ca',
    'ca-es',
    'cs',
    'cs-cz',
    'da',
    'da-dk',
    'de',
    'de-at',
    'de-be',
    'de-ch',
    'de-de',
    'de-lu',
    'el',
    'el-gr',
    'el-polyton',
    'en',
    'en-as',
    'en-au',
    'en-dsrt',
    'en-dsrt-us',
    'en-gb',
    'en-gu',
    'en-ie',
    'en-in',
    'en-iso',
    'en-mh',
    'en-mp',
    'en-sg',
    'en-um',
    'en-us',
    'en-vi',
    'en-za',
    'en-zz',
    'es',
    'es-es',
    'et',
    'et-ee',
    'eu',
    'eu-es',
    'fa',
    'fa-ir',
    'fi',
    'fi-fi',
    'fil',
    'fil-ph',
    'fr',
    'fr-bl',
    'fr-ca',
    'fr-fr',
    'fr-gp',
    'fr-mc',
    'fr-mf',
    'fr-mq',
    'fr-re',
    'gl',
    'gl-es',
    'gsw',
    'gsw-ch',
    'gu',
    'gu-in',
    'he',
    'he-il',
    'hi',
    'hi-in',
    'hr',
    'hr-hr',
    'hu',
    'hu-hu',
    'id',
    'id-id',
    'in',
    'is',
    'is-is',
    'it',
    'it-it',
    'iw',
    'ja',
    'ja-jp',
    'kn',
    'kn-in',
    'ko',
    'ko-kr',
    'ln',
    'ln-cd',
    'lt',
    'lt-lt',
    'lv',
    'lv-lv',
    'ml',
    'ml-in',
    'mo',
    'mr',
    'mr-in',
    'ms',
    'ms-my',
    'mt',
    'mt-mt',
    'nl',
    'nl-nl',
    'no',
    'or',
    'or-in',
    'pl',
    'pl-pl',
    'pt',
    'pt-br',
    'pt-pt',
    'ro',
    'ro-ro',
    'ru',
    'ru-ru',
    'sk',
    'sk-sk',
    'sl',
    'sl-si',
    'sq',
    'sq-al',
    'sr',
    'sr-cyrl-rs',
    'sr-latn-rs',
    'sr-rs',
    'sv',
    'sv-se',
    'sw',
    'sw-tz',
    'ta',
    'ta-in',
    'te',
    'te-in',
    'th',
    'th-th',
    'tl',
    'tl-ph',
    'tr',
    'tr-tr',
    'uk',
    'uk-ua',
    'ur',
    'ur-pk',
    'vi',
    'vi-vn',
    'zh',
    'zh-cn',
    'zh-hans',
    'zh-hans-cn',
    'zh-hk',
    'zh-tw',
]

for lang in _langs:
  locals()["angular_locale_{0}".format(lang).replace("-", "_")] = Resource(library, "i18n/angular-locale_{0}.js".format(lang))
