from fanstatic import Library, Resource

library = Library('angularjs', 'resources')

angular                       = Resource(library, 'angular.js',
                                         minified='angular.min.js')
angular_bootstrap             = Resource(library, 'angular-bootstrap.js',
                                         minified='angular-bootstrap.min.js',
                                         depends=[angular])
angular_bootstrap_prettify    = Resource(library, 'angular-bootstrap-prettify.js',
                                         minified='angular-bootstrap-prettify.min.js',
                                         depends=[angular])
angular_cookies               = Resource(library, 'angular-cookies.js',
                                         minified='angular-cookies.min.js',
                                         depends=[angular])
angular_loader                = Resource(library, 'angular-loader.js',
                                         minified='angular-loader.min.js')
angular_mocks                 = Resource(library, 'angular-mocks.js',
                                         depends=[angular])
angular_resource              = Resource(library, 'angular-resource.js',
                                         minified='angular-resource.min.js',
                                         depends=[angular])
angular_sanitize              = Resource(library, 'angular-sanitize.js',
                                         minified='angular-sanitize.min.js',
                                         depends=[angular])
angular_scenario              = Resource(library, 'angular-scenario.js')

_langs = [
    'af',
    'af-na',
    'af-za',
    'am',
    'am-et',
    'ar',
    'ar-001',
    'ar-ae',
    'ar-bh',
    'ar-dz',
    'ar-eg',
    'ar-iq',
    'ar-jo',
    'ar-kw',
    'ar-lb',
    'ar-ly',
    'ar-ma',
    'ar-om',
    'ar-qa',
    'ar-sa',
    'ar-sd',
    'ar-sy',
    'ar-tn',
    'ar-ye',
    'bg',
    'bg-bg',
    'bn',
    'bn-bd',
    'bn-in',
    'ca',
    'ca-ad',
    'ca-es',
    'chr',
    'cs',
    'cs-cz',
    'cy',
    'da',
    'da-dk',
    'de',
    'de-at',
    'de-be',
    'de-ch',
    'de-de',
    'de-li',
    'de-lu',
    'el',
    'el-cy',
    'el-gr',
    'el-polyton',
    'en',
    'en-as',
    'en-au',
    'en-bb',
    'en-be',
    'en-bm',
    'en-bw',
    'en-bz',
    'en-ca',
    'en-dsrt',
    'en-dsrt-us',
    'en-fm',
    'en-gb',
    'en-gu',
    'en-gy',
    'en-hk',
    'en-ie',
    'en-in',
    'en-iso',
    'en-jm',
    'en-mh',
    'en-mp',
    'en-mt',
    'en-mu',
    'en-na',
    'en-nz',
    'en-ph',
    'en-pk',
    'en-pr',
    'en-pw',
    'en-sg',
    'en-tc',
    'en-tt',
    'en-um',
    'en-us',
    'en-vg',
    'en-vi',
    'en-za',
    'en-zw',
    'en-zz',
    'es',
    'es-419',
    'es-ar',
    'es-bo',
    'es-cl',
    'es-co',
    'es-cr',
    'es-do',
    'es-ea',
    'es-ec',
    'es-es',
    'es-gq',
    'es-gt',
    'es-hn',
    'es-ic',
    'es-mx',
    'es-ni',
    'es-pa',
    'es-pe',
    'es-pr',
    'es-py',
    'es-sv',
    'es-us',
    'es-uy',
    'es-ve',
    'et',
    'et-ee',
    'eu',
    'eu-es',
    'fa',
    'fa-af',
    'fa-ir',
    'fi',
    'fi-fi',
    'fil',
    'fil-ph',
    'fr',
    'fr-be',
    'fr-bf',
    'fr-bi',
    'fr-bj',
    'fr-bl',
    'fr-ca',
    'fr-cd',
    'fr-cf',
    'fr-cg',
    'fr-ch',
    'fr-ci',
    'fr-cm',
    'fr-dj',
    'fr-fr',
    'fr-ga',
    'fr-gf',
    'fr-gn',
    'fr-gp',
    'fr-gq',
    'fr-km',
    'fr-lu',
    'fr-mc',
    'fr-mf',
    'fr-mg',
    'fr-ml',
    'fr-mq',
    'fr-ne',
    'fr-re',
    'fr-rw',
    'fr-sn',
    'fr-td',
    'fr-tg',
    'fr-yt',
    'gl',
    'gl-es',
    'gsw',
    'gsw-ch',
    'gu',
    'gu-in',
    'haw',
    'he',
    'he-il',
    'hi',
    'hi-in',
    'hr',
    'hr-hr',
    'hu',
    'hu-hu',
    'id',
    'id-id',
    'in',
    'is',
    'is-is',
    'it',
    'it-ch',
    'it-it',
    'it-sm',
    'iw',
    'ja',
    'ja-jp',
    'kn',
    'kn-in',
    'ko',
    'ko-kr',
    'ln',
    'ln-cd',
    'ln-cg',
    'lt',
    'lt-lt',
    'lv',
    'lv-lv',
    'ml',
    'ml-in',
    'mo',
    'mr',
    'mr-in',
    'ms',
    'ms-bn',
    'ms-my',
    'mt',
    'mt-mt',
    'nl',
    'nl-aw',
    'nl-be',
    'nl-cw',
    'nl-nl',
    'nl-sx',
    'no',
    'or',
    'or-in',
    'pl',
    'pl-pl',
    'pt',
    'pt-ao',
    'pt-br',
    'pt-gw',
    'pt-mz',
    'pt-pt',
    'pt-st',
    'ro',
    'ro-md',
    'ro-ro',
    'ru',
    'ru-md',
    'ru-ru',
    'ru-ua',
    'sk',
    'sk-sk',
    'sl',
    'sl-si',
    'sq',
    'sq-al',
    'sr',
    'sr-cyrl',
    'sr-cyrl-ba',
    'sr-cyrl-me',
    'sr-cyrl-rs',
    'sr-latn',
    'sr-latn-ba',
    'sr-latn-me',
    'sr-latn-rs',
    'sr-rs',
    'sv',
    'sv-fi',
    'sv-se',
    'sw',
    'sw-ke',
    'sw-tz',
    'ta',
    'ta-in',
    'ta-lk',
    'te',
    'te-in',
    'th',
    'th-th',
    'tl',
    'tl-ph',
    'tr',
    'tr-tr',
    'uk',
    'uk-ua',
    'ur',
    'ur-in',
    'ur-pk',
    'vi',
    'vi-vn',
    'zh',
    'zh-cn',
    'zh-hans',
    'zh-hans-cn',
    'zh-hans-hk',
    'zh-hans-mo',
    'zh-hans-sg',
    'zh-hant',
    'zh-hant-hk',
    'zh-hant-mo',
    'zh-hant-tw',
    'zh-hk',
    'zh-tw',
    'zu',
    'zu-za',
]

for lang in _langs:
  locals()["angular_locale_{0}".format(lang).replace("-", "_")] = Resource(library, "i18n/angular-locale_{0}.js".format(lang))
