/*!
 * typeahead.js 0.8.2
 * https://github.com/twitter/typeahead
 * Copyright 2013 Twitter, Inc. and other contributors; Licensed MIT
 */

(function(t){var e="0.8.2",n={isMsie:function(){return/msie [\w.]+/i.test(navigator.userAgent)},isBlankString:function(t){return!t||/^\s*$/.test(t)},escapeRegExChars:function(t){return t.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(t){return"string"==typeof t},isNumber:function(t){return"number"==typeof t},isArray:t.isArray,isFunction:t.isFunction,isObject:t.isPlainObject,isUndefined:function(t){return t===void 0},bind:t.proxy,bindAll:function(e){var n;for(var i in e)t.isFunction(n=e[i])&&(e[i]=t.proxy(n,e))},indexOf:function(t,e){for(var n=0;t.length>n;n++)if(t[n]===e)return n;return-1},each:t.each,map:t.map,filter:function(e,n){var i=[];return t.each(e,function(t,s){n(s,t,e)&&i.push(s)}),i},every:function(e,n){var i=!0;return e?(t.each(e,function(t,s){return(i=n.call(null,s,t,e))?void 0:!1}),!!i):i},mixin:t.extend,getUniqueId:function(){var t=0;return function(){return t++}}(),debounce:function(t,e,n){var i,s;return function(){var r,o,u=this,a=arguments;return r=function(){i=null,n||(s=t.apply(u,a))},o=n&&!i,clearTimeout(i),i=setTimeout(r,e),o&&(s=t.apply(u,a)),s}},throttle:function(t,e){var n,i,s,r,o,u;return o=0,u=function(){o=new Date,s=null,r=t.apply(n,i)},function(){var a=new Date,c=e-(a-o);return n=this,i=arguments,0>=c?(clearTimeout(s),s=null,o=a,r=t.apply(n,i)):s||(s=setTimeout(u,c)),r}},uniqueArray:function(t){for(var e={},n=[],i=0,s=t.length;s>i;++i)e.hasOwnProperty(t[i])||(n.push(t[i]),e[t[i]]=1);return n},tokenizeQuery:function(e){return t.trim(e).toLowerCase().split(/[\s]+/)},tokenizeText:function(e){return t.trim(e).toLowerCase().split(/[\s\-_]+/)},getProtocol:function(){return location.protocol},noop:function(){}},i=function(){var t=/\s+/;return{on:function(e,n){var i;if(!n)return this;for(this._callbacks=this._callbacks||{},e=e.split(t);i=e.shift();)this._callbacks[i]=this._callbacks[i]||[],this._callbacks[i].push(n);return this},trigger:function(e,n){var i,s;if(!this._callbacks)return this;for(e=e.split(t);i=e.shift();)if(s=this._callbacks[i])for(var r=0;s.length>r;r+=1)s[r].call(this,{type:i,data:n});return this}}}(),s=function(){function t(t){this.prefix=["__",t,"__"].join(""),this.ttlKey="__ttl__",this.keyMatcher=RegExp("^"+this.prefix)}function e(){return(new Date).getTime()}function i(t){return JSON.stringify(n.isUndefined(t)?null:t)}function s(t){return JSON.parse(t)}var r,o=window.localStorage;return r=window.localStorage&&window.JSON?{_prefix:function(t){return this.prefix+t},_ttlKey:function(t){return this._prefix(t)+this.ttlKey},get:function(t){return this.isExpired(t)&&this.remove(t),s(o.getItem(this._prefix(t)))},set:function(t,s,r){return n.isNumber(r)?o.setItem(this._ttlKey(t),i(e()+r)):o.removeItem(this._ttlKey(t)),o.setItem(this._prefix(t),i(s))},remove:function(t){return o.removeItem(this._ttlKey(t)),o.removeItem(this._prefix(t)),this},clear:function(){var t,e,n=[],i=o.length;for(t=0;i>t;t++)(e=o.key(t)).match(this.keyMatcher)&&n.push(e.replace(this.keyMatcher,""));for(t=n.length;t--;)this.remove(n[t]);return this},isExpired:function(t){var i=s(o.getItem(this._ttlKey(t)));return n.isNumber(i)&&e()>i?!0:!1}}:{get:n.noop,set:n.noop,remove:n.noop,clear:n.noop,isExpired:n.noop},n.mixin(t.prototype,r),t}(),r=function(){function t(t){n.bindAll(this),t=t||{},this.sizeLimit=t.sizeLimit||10,this.cache={},this.cachedKeysByAge=[]}return n.mixin(t.prototype,{get:function(t){return this.cache[t]},set:function(t,e){var n;this.cachedKeysByAge.length===this.sizeLimit&&(n=this.cachedKeysByAge.shift(),delete this.cache[n]),this.cache[t]=e,this.cachedKeysByAge.push(t)}}),t}(),o=function(){function e(t){var e;n.bindAll(this),t=t||{},e=/^throttle$/i.test(t.rateLimitFn)?n.throttle:n.debounce,this.wait=t.wait||300,this.wildcard=t.wildcard||"%QUERY",this.maxConcurrentRequests=t.maxConcurrentRequests||6,this.concurrentRequests=0,this.onDeckRequestArgs=null,this.cache=new r,this.get=e(this.get,this.wait)}return n.mixin(e.prototype,{_incrementConcurrentRequests:function(){this.concurrentRequests++},_decrementConcurrentRequests:function(){this.concurrentRequests--},_belowConcurrentRequestsThreshold:function(){return this.concurrentRequests<this.maxConcurrentRequests},get:function(e,n,i){var s,r=this;e=e.replace(this.wildcard,encodeURIComponent(n||"")),(s=this.cache.get(e))?i&&i(s):this._belowConcurrentRequestsThreshold()?t.ajax({url:e,type:"GET",dataType:"json",beforeSend:function(){r._incrementConcurrentRequests()},success:function(t){i&&i(t),r.cache.set(e,t)},complete:function(){r._decrementConcurrentRequests(),r.onDeckRequestArgs&&(r.get.apply(r,r.onDeckRequestArgs),r.onDeckRequestArgs=null)}}):this.onDeckRequestArgs=[].slice.call(arguments,0)}}),e}(),u=function(){function i(t){n.bindAll(this),this.storage=new s(t.name),this.adjacencyList={},this.itemHash={},this.name=t.name,this.resetDataOnProtocolSwitch=t.resetDataOnProtocolSwitch||!1,this.queryUrl=t.remote,this.transport=t.transport,this.limit=t.limit||10,this._customMatcher=t.matcher||null,this._customRanker=t.ranker||null,this._ttl_ms=n.isNumber(t.ttl_ms)?t.ttl_ms:864e5,this.keys={version:"version",protocol:"protocol",itemHash:"itemHash",adjacencyList:"adjacencyList"},t.local&&this._processLocalData(t.local),t.prefetch&&this._loadPrefetchData(t.prefetch)}return n.mixin(i.prototype,{_processLocalData:function(t){t&&this._mergeProcessedData(this._processData(t))},_loadPrefetchData:function(i){function s(t){var i=r._processData(t),s=i.itemHash,o=i.adjacencyList;r.storage.set(r.keys.itemHash,s,r._ttl_ms),r.storage.set(r.keys.adjacencyList,o,r._ttl_ms),r.storage.set(r.keys.version,e,r._ttl_ms),r.storage.set(r.keys.protocol,n.getProtocol(),r._ttl_ms),r._mergeProcessedData(i)}var r=this,o=this.storage.get(this.keys.itemHash),u=this.storage.get(this.keys.adjacencyList),a=this.storage.get(this.keys.protocol),c=this.storage.get(this.keys.version),h=c!==e||a!==n.getProtocol();o&&u&&!h?this._mergeProcessedData({itemHash:o,adjacencyList:u}):t.getJSON(i).done(s)},_processData:function(t){var e={},i={};return n.each(t,function(t,s){var r;n.isString(s)&&(s={value:s,tokens:n.tokenizeText(s)}),s.tokens=n.filter(s.tokens||[],function(t){return!n.isBlankString(t)}),s.tokens=n.map(s.tokens,function(t){return t.toLowerCase()}),e[r=n.getUniqueId(s.value)]=s,n.each(s.tokens,function(t,e){var s=e.charAt(0),o=i[s]||(i[s]=[r]);!~n.indexOf(o,r)&&o.push(r)})}),{itemHash:e,adjacencyList:i}},_mergeProcessedData:function(t){var e=this;n.mixin(this.itemHash,t.itemHash),n.each(t.adjacencyList,function(t,n){var i=e.adjacencyList[t];e.adjacencyList[t]=i?i.concat(n):n})},_getPotentiallyMatchingIds:function(e){var i=[],s=[];if(n.map(e,n.bind(function(t){var e=this.adjacencyList[t.charAt(0)];e&&s.push(e)},this)),1===s.length)return s[0];var r=[];t.each(s,function(t,e){r.push(e.length)});var o=n.indexOf(r,Math.min.apply(null,r))||0,u=s[o]||[];return i=n.map(u,function(t){var e=n.every(s,function(e){return n.indexOf(e,t)>-1});return e?t:void 0})},_getItemsFromIds:function(t){var e=[];return n.map(t,n.bind(function(t){var n=this.itemHash[t];n&&e.push(n)},this)),e},_matcher:function(t){if(this._customMatcher){var e=this._customMatcher;return function(t){return e(t)}}return function(e){var i=e.tokens,s=n.every(t,function(t){var e=n.filter(i,function(e){return 0===e.indexOf(t)});return e.length});return s?e:void 0}},_compareItems:function(t,e,n){var i=t.score_boost?t.score_boost:0,s=e.score_boost?e.score_boost:0,r=t.score?t.score:0,o=e.score?e.score:0;return n?e.weight+s-(t.weight+i):o+s-(r+i)},_ranker:function(t,e){if(this._customRanker)return this._customRanker(t,e);var n=t.weight&&0!==t.weight,i=e.weight&&0!==e.weight;return n&&!i?-1:i&&!n?1:n&&i?this._compareItems(t,e,!0):this._compareItems(t,e,!1)},_processRemoteSuggestions:function(t,e){var i=this;return function(s){n.each(s,function(t,s){var r=!1;return s=n.isString(s)?{value:s}:s,n.each(e,function(t,e){return s.value===e.value?(r=!0,!1):void 0}),!r&&e.push(s),e.length<i.limit}),t&&t(e)}},getSuggestions:function(t,e){var i=n.tokenizeQuery(t),s=this._getPotentiallyMatchingIds(i),r=this._getItemsFromIds(s),o=n.filter(r,this._matcher(i));o.sort(this._ranker),e&&e(o),o.length<this.limit&&this.queryUrl&&this.transport.get(this.queryUrl,t,this._processRemoteSuggestions(e,o))}}),i}(),a=function(){function e(e){var i=this;n.bindAll(this),this.specialKeyCodeMap={9:"tab",27:"esc",37:"left",39:"right",13:"enter",38:"up",40:"down"},this.query="",this.$hint=t(e.hint),this.$input=t(e.input).on("blur.tt",this._handleBlur).on("focus.tt",this._handleFocus).on("keydown.tt",this._handleSpecialKeyEvent),n.isMsie()?this.$input.on("keydown.tt keypress.tt cut.tt paste.tt",function(t){i.specialKeyCodeMap[t.which||t.keyCode]||setTimeout(i._compareQueryToInputValue,0)}):this.$input.on("input.tt",this._compareQueryToInputValue),this.$overflowHelper=s(this.$input)}function s(e){return t("<span></span>").css({position:"absolute",left:"-9999px",visibility:"hidden",whiteSpace:"nowrap",fontFamily:e.css("font-family"),fontSize:e.css("font-size"),fontStyle:e.css("font-style"),fontVariant:e.css("font-variant"),fontWeight:e.css("font-weight"),wordSpacing:e.css("word-spacing"),letterSpacing:e.css("letter-spacing"),textIndent:e.css("text-indent"),textRendering:e.css("text-rendering"),textTransform:e.css("text-transform")}).insertAfter(e)}function r(t,e){return t=(t||"").replace(/^\s*/g,"").replace(/\s{2,}/g," ").toLowerCase(),e=(e||"").replace(/^\s*/g,"").replace(/\s{2,}/g," ").toLowerCase(),t===e}return n.mixin(e.prototype,i,{_handleFocus:function(){this.trigger("focus")},_handleBlur:function(){this.trigger("blur")},_handleSpecialKeyEvent:function(t){var e=this.specialKeyCodeMap[t.which||t.keyCode];e&&this.trigger(e,t)},_compareQueryToInputValue:function(){var t=this.getInputValue(),e=r(this.query,t),n=e?this.query.length!==t.length:!1;n?this.trigger("whitespaceChange",{value:this.query}):e||this.trigger("queryChange",{value:this.query=t})},destroy:function(){this.$hint.off(".tt"),this.$input.off(".tt"),this.$hint=this.$input=this.$overflowHelper=null},focus:function(){this.$input.focus()},blur:function(){this.$input.blur()},getQuery:function(){return this.query},getInputValue:function(){return this.$input.val()},setInputValue:function(t,e){this.$input.val(t),e!==!0&&this._compareQueryToInputValue()},getHintValue:function(){return this.$hint.val()},setHintValue:function(t){this.$hint.val(t)},getLanguageDirection:function(){return(this.$input.css("direction")||"ltr").toLowerCase()},isOverflow:function(){return this.$overflowHelper.text(this.getInputValue()),this.$overflowHelper.width()>this.$input.width()},isCursorAtEnd:function(){var t,e=this.$input.val().length,i=this.$input[0].selectionStart;return n.isNumber(i)?i===e:document.selection?(t=document.selection.createRange(),t.moveStart("character",-e),e===t.text.length):!0}}),e}(),c=function(){function e(e){n.bindAll(this),this.isMouseOverDropdown,this.$menu=t(e.menu).on("mouseenter.tt",this._handleMouseenter).on("mouseleave.tt",this._handleMouseleave).on("click.tt",".tt-suggestion",this._handleSelection).on("mouseover.tt",".tt-suggestion",this._handleMouseover)}function s(t){var e=t.parents(".tt-suggestions").first();return{value:t.data("value"),query:e.data("query"),dataset:e.data("dataset")}}return n.mixin(e.prototype,i,{_handleMouseenter:function(){this.isMouseOverDropdown=!0},_handleMouseleave:function(){this.isMouseOverDropdown=!1},_handleMouseover:function(e){this._getSuggestions().removeClass("tt-is-under-cursor"),t(e.currentTarget).addClass("tt-is-under-cursor")},_handleSelection:function(e){this.trigger("select",s(t(e.currentTarget)))},_moveCursor:function(t){var e,n,i,s;if(this.$menu.hasClass("tt-is-open")){if(e=this._getSuggestions(),n=e.filter(".tt-is-under-cursor"),n.removeClass("tt-is-under-cursor"),i=e.index(n)+t,i=(i+1)%(e.length+1)-1,-1===i)return this.trigger("cursorOff"),void 0;-1>i&&(i=e.length-1),s=e.eq(i).addClass("tt-is-under-cursor"),this.trigger("cursorOn",{value:s.data("value")})}},_getSuggestions:function(){return this.$menu.find(".tt-suggestions > .tt-suggestion")},destroy:function(){this.$menu.off(".tt"),this.$menu=null},hideUnlessMouseIsOverDropdown:function(){this.isMouseOverDropdown||this.hide()},hide:function(){this.$menu.hasClass("tt-is-open")&&(this.$menu.removeClass("tt-is-open").find(".tt-suggestions > .tt-suggestion").removeClass("tt-is-under-cursor"),this.trigger("hide"))},show:function(){this.$menu.hasClass("tt-is-open")||(this.$menu.addClass("tt-is-open"),this.trigger("show"))},isOpen:function(){return this.$menu.hasClass("tt-is-open")},moveCursorUp:function(){this._moveCursor(-1)},moveCursorDown:function(){this._moveCursor(1)},getSuggestionUnderCursor:function(){var t=this._getSuggestions().filter(".tt-is-under-cursor").first();return t.length>0?s(t):null},getFirstSuggestion:function(){var t=this._getSuggestions().first();return t.length>0?s(t):null},renderSuggestions:function(e,i,s){var r,o,u,a="tt-dataset-"+i.name,c=this.$menu.find("."+a);0===c.length&&(c=t('<li><ol class="tt-suggestions"></ol></li>').addClass(a).appendTo(this.$menu)),r=document.createElement("div"),o=document.createDocumentFragment(),this.clearSuggestions(i.name),s.length>0&&(this.$menu.removeClass("tt-is-empty"),n.each(s,function(t,e){r.innerHTML=i.template.render(e),u=r.firstChild,u.setAttribute("data-value",e.value),o.appendChild(u)})),c.find("> .tt-suggestions").data({query:e,dataset:i.name}).append(o),this.trigger("suggestionsRender")},clearSuggestions:function(t){var e=t?this.$menu.find(".tt-dataset-"+t+" .tt-suggestions"):this.$menu.find(".tt-suggestions");e.empty(),0===this._getSuggestions().length&&this.$menu.addClass("tt-is-empty")}}),e}(),h=function(){function e(t){var e,i,r;n.bindAll(this),this.$node=s(t.input),this.datasets=t.datasets,e=this.$node.find(".tt-dropdown-menu"),i=this.$node.find(".tt-query"),r=this.$node.find(".tt-hint"),this.dropdownView=new c({menu:e}).on("select",this._handleSelection).on("cursorOn",this._clearHint).on("cursorOn",this._setInputValueToSuggestionUnderCursor).on("cursorOff",this._setInputValueToQuery).on("cursorOff",this._updateHint).on("suggestionsRender",this._updateHint).on("show",this._updateHint).on("hide",this._clearHint),this.inputView=new a({input:i,hint:r}).on("focus",this._showDropdown).on("blur",this._hideDropdown).on("blur",this._setInputValueToQuery).on("enter",this._handleSelection).on("queryChange",this._clearHint).on("queryChange",this._clearSuggestions).on("queryChange",this._getSuggestions).on("whitespaceChange",this._updateHint).on("queryChange whitespaceChange",this._showDropdown).on("queryChange whitespaceChange",this._setLanguageDirection).on("esc",this._hideDropdown).on("esc",this._setInputValueToQuery).on("tab up down",this._managePreventDefault).on("up down",this._moveDropdownCursor).on("up down",this._showDropdown).on("tab left right",this._autocomplete)}function s(e){var n=t(e),i=t(o.hint).css({"background-color":n.css("background-color")});if(0===n.length)return null;n.data("ttAttrs",{dir:n.attr("dir"),autocomplete:n.attr("autocomplete"),spellcheck:n.attr("spellcheck")});try{!n.attr("dir")&&n.attr("dir","auto")}catch(s){}return n.attr({autocomplete:"off",spellcheck:!1}).addClass("tt-query").wrap(o.wrapper).parent().prepend(i).append(o.dropdown)}function r(t){var e=t.find(".tt-query");n.each(e.data("ttAttrs"),function(t,i){n.isUndefined(i)?e.removeAttr(t):e.attr(t,i)}),e.detach().removeClass("tt-query").insertAfter(t),t.remove()}var o={wrapper:'<span class="twitter-typeahead"></span>',hint:'<input class="tt-hint" type="text" autocomplete="off" spellcheck="false" disabled>',dropdown:'<ol class="tt-dropdown-menu tt-is-empty"></ol>'};return n.mixin(e.prototype,i,{_managePreventDefault:function(t){var e,n,i=t.data,s=!1;switch(t.type){case"tab":e=this.inputView.getHintValue(),n=this.inputView.getInputValue(),s=e&&e!==n;break;case"up":case"down":s=!i.shiftKey&&!i.ctrlKey&&!i.metaKey}s&&i.preventDefault()},_setLanguageDirection:function(){var t="tt-"+this.inputView.getLanguageDirection();this.$node.hasClass(t)||this.$node.removeClass("tt-ltr tt-rtl").addClass(t)},_updateHint:function(){var t,e,i,s,r,o=this.dropdownView.getFirstSuggestion(),u=o?o.value:null;u&&this.dropdownView.isOpen()&&!this.inputView.isOverflow()&&(t=this.inputView.getInputValue(),e=t.replace(/\s{2,}/g," ").replace(/^\s+/g,""),i=n.escapeRegExChars(e),s=RegExp("^(?:"+i+")(.*$)","i"),r=s.exec(u),this.inputView.setHintValue(t+(r?r[1]:"")))},_clearHint:function(){this.inputView.setHintValue("")},_clearSuggestions:function(){this.dropdownView.clearSuggestions()},_setInputValueToQuery:function(){this.inputView.setInputValue(this.inputView.getQuery())},_setInputValueToSuggestionUnderCursor:function(t){var e=t.data;this.inputView.setInputValue(e.value,!0)},_showDropdown:function(){this.dropdownView.show()},_hideDropdown:function(t){this.dropdownView["blur"===t.type?"hideUnlessMouseIsOverDropdown":"hide"]()},_moveDropdownCursor:function(t){var e=t.data;e.shiftKey||e.ctrlKey||e.metaKey||this.dropdownView["up"===t.type?"moveCursorUp":"moveCursorDown"]()},_handleSelection:function(t){var e="select"===t.type,i=e?t.data:this.dropdownView.getSuggestionUnderCursor();i&&(this.inputView.setInputValue(i.value),e?this.inputView.focus():t.data.preventDefault(),e&&n.isMsie()?setTimeout(this.dropdownView.hide,0):this.dropdownView.hide())},_getSuggestions:function(){var t=this,e=this.inputView.getQuery();n.isBlankString(e)||n.each(this.datasets,function(n,i){i.getSuggestions(e,function(n){t._renderSuggestions(e,i,n)})})},_renderSuggestions:function(t,e,n){t===this.inputView.getQuery()&&(n=n.slice(0,e.limit),this.dropdownView.renderSuggestions(t,e,n))},_autocomplete:function(t){var e,n,i,s;("right"!==t.type&&"left"!==t.type||(e=this.inputView.isCursorAtEnd(),n="ltr"===this.inputView.getLanguageDirection()?"left"===t.type:"right"===t.type,e&&!n))&&(i=this.inputView.getQuery(),s=this.inputView.getHintValue(),""!==s&&i!==s&&this.inputView.setInputValue(s))},destroy:function(){this.inputView.destroy(),this.dropdownView.destroy(),r(this.$node),this.$node=null}}),e}();(function(){function e(t){return a[t]?a[t].apply(this,[].slice.call(arguments,1)):a.initialize.apply(this,arguments)}function i(t){l=t}function s(t,e){var n,i='<li class="tt-suggestion">%body</li>';return n=t?e.compile(i.replace("%body",t)):{render:function(t){return i.replace("%body","<p>"+t.value+"</p>")}}}var r,a,c={},l={};jQuery.fn.typeahead=e,e.configureTransport=i,a={initialize:function(i){var a={};if(i=n.isArray(i)?i:[i],0===i.length)throw Error("no datasets provided");return delete e.configureTransport,r=r||new o(l),n.each(i,function(t,e){var i,o=e.name=e.name||n.getUniqueId();if(c[o])i=c[o];else{if(e.limit=e.limit||5,e.template&&!e.engine)throw Error("no template engine specified for "+o);i=c[o]=new u({name:e.name,limit:e.limit,local:e.local,prefetch:e.prefetch,ttl_ms:e.ttl_ms,remote:e.remote,matcher:e.matcher,ranker:e.ranker,transport:r})}a[o]={name:e.name,limit:e.limit,template:s(e.template,e.engine),getSuggestions:i.getSuggestions}}),this.each(function(){t(this).data({typeahead:new h({input:this,datasets:a})})})},destroy:function(){this.each(function(){var e=t(this),n=e.data("typeahead");n&&(n.destroy(),e.removeData("typeahead"))})}}})()})(window.jQuery);