# -*- encoding: utf-8 -*-

import re
import os
import click
import requests
from bs4 import BeautifulSoup

@click.command()
@click.argument('library')
@click.argument('target', default='index.html')
def main(library, target):
    cdnjs = requests.get('https://api.github.com/search/code?sort=created&order=desc&q=%s+repo:cdnjs/cdnjs+in:path+extension:js+extension:css' % library).json()
    jsdelivr = requests.get('https://api.github.com/search/code?sort=created&order=desc&q=%s+repo:jsdelivr/jsdelivr+in:path+extension:js+extension:css' % library).json()

    libindex = []
    i = 0

    for item in cdnjs['items'][:10]:
        urlparts = item['html_url'].split('/')[-5:]
        if urlparts[0] != 'ajax' and urlparts[1] != 'libs':
            continue
        path = '//cdnjs.cloudflare.com/' + '/'.join(urlparts)
        libindex.append(path)
        click.echo('[%s]: %s' % (i, path))
        i += 1
    for item in jsdelivr['items'][:10]:
        urlparts = item['html_url'].split('/')[-3:]
        path = '//cdn.jsdelivr.net/' + '/'.join(urlparts)
        libindex.append(path)
        click.echo('[%s]: %s' % (i, path))
        i += 1

    choosed = click.prompt('Choose', type=int, default=0)
    url = libindex[choosed]

    click.echo('Adding to %s' % target)
    if not os.path.isfile(target):
        open(target, 'w').close()

    with open(target, 'r') as f:
        contents = f.read()
        soup = BeautifulSoup(contents)

        nohead = False
        if not soup.head:
            nohead = True
            head = soup.new_tag('head')
            if soup.contents:
                doctype = soup.contents[0]
                doctype.insert_after(head)
            else:
                soup.append(head)

        # js file
        if url.split('.')[-1] == 'js':
            js = soup.new_tag('script', src=url)
            # insert after the last external script
            for script in soup.head.find_all('script').reverse() or []:
                if script['src'].startswith('//') or\
                   script['src'].startswith('http'):
                    script.insert_after(js)
                    break
            else:
                soup.head.append(js)

        # css file
        else:
            css = soup.new_tag('css', src=url)
            # insert after the last external css
            for link in soup.head.find_all('link').reverse() or []:
                if link['href'].startswith('//') or\
                   link['href'].startswith('http'):
                    link.insert_after(css)
                    break
            else:
                soup.head.append(css)

    with open(target, 'w') as f:
        if nohead:
            f.write(soup.prettify())
            return
        new = re.sub('< *head[^>]*>.*< *\/ *head[^>]*>', '\n' + soup.head.prettify() + '\n', contents, flags=re.I|re.M|re.S)
        f.write(new)

if __name__ == '__main__':
    main()
