#!/usr/bin/env python

from setuptools import setup

setup(
    author='Giovanni Torres Parra',
    author_email='fiatjaf@gmail.com',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 2',
        ],
    description='Add JS libraries from a CDN to your HTML',
    license='MIT',
    include_package_data=True,
    maintainer='Giovanni Torres Parra',
    maintainer_email='fiatjaf@gmail.com',
    name='jsadd',
    py_modules=['jsadd'],
    install_requires=[
        'click>=3.3',
        'beautifulsoup4==4.3.2',
        'requests>=2.4.1',
    ],
    url='https://github.com/fiatjaf/jsadd',
    version='0.0.1',
    entry_points='''

    [console_scripts]
    jsadd=jsadd:main
    '''
)

