// Generated by json_to_model

import Foundation

class {{ class_name }} : {{ super_name }} {
{% for property in properties %}
    {% if property.type.split(' ')[0] in ['Int', 'Bool', 'Double', 'String?'] %}
    var {{ property.name }} : {{ property.type }} = {{ property.default_value }}
    {% elif property.type.split(' ')[0].startswith('Array') %}
    var {{ property.name }} : {{ property.type }} = {{ property.default_value }}
    {% else %}
    var {{ property.name }} : {{ property.type }}? = {{ property.default_value }}
    {% endif %}
{% endfor %}
{% if super_name == 'NSObject' %}
   init(JSONDictionary: NSDictionary) {
{% else %}
    override init(JSONDictionary: NSDictionary) {
        super.init(JSONDictionary: JSONDictionary)
{% endif %}
{% for property in properties %} {% if property.type == 'Int' %}
        if (!(JSONDictionary["{{ property.original_name }}"] is NSNull)) {
            self.{{ property.name }} = JSONDictionary["{{ property.original_name }}"]!.integerValue
        }
{% elif property.type == 'Double' %}
        if (!(JSONDictionary["{{ property.original_name }}"] is NSNull)) {
            self.{{ property.name }} = JSONDictionary["{{ property.original_name }}"]!.doubleValue
        }
{% elif property.type == 'Bool' %}
        if (!(JSONDictionary["{{ property.original_name }}"] is NSNull)) {
            self.{{ property.name }} = JSONDictionary["{{ property.original_name }}"]!.boolValue
        }
{% elif property.type == 'String?' %}
        if (!(JSONDictionary["{{ property.original_name }}"] is NSNull)) {
            self.{{ property.name }} = JSONDictionary["{{ property.original_name }}"] as String?
        }
{% elif property.type.startswith('Array') %}
        for child in (JSONDictionary["{{ property.original_name }}"] as NSArray) {
        {% if property.children_type.split(' ')[0].startswith('Array') %}
            {{ property.name }}.append(child as AnyObject? as {{ property.children_type }});
        {% elif property.children_type.split(' ')[0] in ['String?', 'Int', 'Bool', 'Double'] %}
            {{ property.name }}.append(child as AnyObject? as {{ property.children_type }});
        {% else %}
            {{ property.name }}.append({{ property.children_type }}(JSONDictionary:child as NSDictionary))
        {% endif %}
        }
{% else %}
        if (!(JSONDictionary["{{ property.original_name }}"] is NSNull)) {
            self.{{ property.name }} = {{ property.type }}(JSONDictionary:JSONDictionary["{{ property.original_name }}"] as NSDictionary)
        }
{% endif %} {% endfor %}
    }

    convenience init?(JSONData: NSData) {
        var error : NSErrorPointer = nil
        var result : NSDictionary? = NSJSONSerialization.JSONObjectWithData(JSONData, options:NSJSONReadingOptions.AllowFragments, error:error) as NSDictionary?
        if (result != nil) {
            self.init(JSONDictionary:result!)
        } else {
            self.init(JSONDictionary:NSMutableDictionary())
            return nil
        }
    }

{% if super_name == 'NSObject' %}
    func JSONDictionary() -> NSDictionary {
{% else %}
    override func JSONDictionary() -> NSDictionary {
{% endif %}
{% if super_name == 'NSObject' %}
        var dictionary : NSMutableDictionary = NSMutableDictionary()
{% else %}
        var dictionary : NSMutableDictionary = super.JSONDictionary() as NSMutableDictionary
{% endif %}
{% for property in properties %} {% if property.type == 'Int' %}
        dictionary["{{ property.original_name }}"] = self.{{ property.name }}
{% elif property.type == 'Double' %}
        dictionary["{{ property.original_name }}"] = self.{{ property.name }}
{% elif property.type == 'Bool' %}
        dictionary["{{ property.original_name }}"] = self.{{ property.name }}
{% elif property.type == 'String?' %}
        dictionary["{{ property.original_name }}"] = (self.{{ property.name }} != nil) ? self.{{ property.name }} : NSNull()
{% elif property.type.startswith('Array') %}
        var _{{ property.name }} : NSMutableArray = NSMutableArray()
        dictionary["{{ property.original_name }}"] = _{{ property.name }}
        for __ in self.{{ property.name }} {
            {% if property.children_type.split(' ')[0] in ['Int', 'Bool', 'Double'] %}
                _{{ property.name }}.addObject(__)
            {% elif property.children_type.split(' ')[0] == 'String?' %}
                _{{ property.name }}.addObject(__!)
            {% elif property.children_type.split(' ')[0].startswith('Array') %}
                _{{ property.name }}.addObject(__)
            {% else %}
                _{{ property.name }}.addObject(__.JSONDictionary())
            {% endif %}
        }
{% else %}
        dictionary["{{ property.original_name }}"] = (self.{{ property.name }} == nil) ? NSNull() : self.{{ property.name }}
{% endif %} {% endfor %}
        return dictionary;
    }
{% if super_name == 'NSObject' %}
    func JSONData() -> NSData? {
{% else %}
    override func JSONData() -> NSData? {
{% endif %}
        var error : NSErrorPointer = nil
        var data : NSData? = NSJSONSerialization.dataWithJSONObject(self.JSONDictionary(), options:nil, error:error)
        if (error != nil) {
            return nil
        }
        return data
    }

}
