#!/usr/bin/env python
#
#

import os
import sys

try: use_setuptools()
except: pass

try:
    from setuptools import setup
except Exception as ex:
    print(str(ex))
    os._exit(1)

from distutils import sysconfig
site_packages_path = sysconfig.get_python_lib()

setup(
    name='jsonbot',
    version='1.0.1',
    url='https://pikacode.com/milla/jsonbot1',
    author='Bart Thate',
    author_email='milla@dds.nl',
    description='The bot for us. !',
    license='MIT',
    include_package_data=True,
    zip_safe=False,
    install_requires=["jsb", "beautifulsoup4", "sleekxmpp"],
    scripts=["bin/jsonbot", ],
    long_description = """ JSONBOT is a remote event-driven framework for building bots that talk JSON to each other over XMPP. This distribution has IRC/Console/XMPP/WWW/Convore bots built on this framework. """,
    data_files=[('doc', ["LICENSE", ]),],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Other Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Communications :: Email',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
