# Copyright 2012 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Juju machine provider for MaaS."""

from juju.machine import ProviderMachine


class MaaSMachine(ProviderMachine):
    """MaaS-specific provider machine implementation."""

    @classmethod
    def from_dict(cls, d):
        """Convert a `dict` into a :class:`MaaSMachine`.

        :param dict d: a dict as returned (in a list) by
        :meth:`juju.providers.maas.maas.MaaSClient.start_node`
        :rtype: :class:`MaaSMachine`
        """
        system_id, hostname = d["system_id"], d["hostname"]
        return cls(system_id, hostname, hostname)
