# message types (the first identifying piece of a serialized message)
MSG_TYPE_HANDSHAKE = 1
MSG_TYPE_ANNOUNCE = 2
MSG_TYPE_UNSUBSCRIBE = 3
MSG_TYPE_PUBLISH = 4
MSG_TYPE_RPC_REQUEST = 5
MSG_TYPE_RPC_RESPONSE = 6
MSG_TYPE_PROXY_PUBLISH = 7
MSG_TYPE_PROXY_REQUEST = 8
MSG_TYPE_PROXY_RESPONSE = 9
MSG_TYPE_PROXY_RESPONSE_COUNT = 10
MSG_TYPE_PROXY_QUERY_COUNT = 11

# invariants for chunked message types:
#  - <msgtype>            + 9 == <corresponding proxy msgtype>
#  - <is chunked msgtype> + 3 == <corresponding chunk msgtype>
#  - <chunk msgtype>      + 3 == <corresponding end chunks msgtype>
# these save us from a bunch of mapping table lookups
MSG_TYPE_PUBLISH_IS_CHUNKED = 12
MSG_TYPE_REQUEST_IS_CHUNKED = 13
MSG_TYPE_RESPONSE_IS_CHUNKED = 14
MSG_TYPE_PUBLISH_CHUNK = 15
MSG_TYPE_REQUEST_CHUNK = 16
MSG_TYPE_RESPONSE_CHUNK = 17
MSG_TYPE_PUBLISH_END_CHUNKS = 18
MSG_TYPE_REQUEST_END_CHUNKS = 19
MSG_TYPE_RESPONSE_END_CHUNKS = 20
MSG_TYPE_PROXY_PUBLISH_IS_CHUNKED = 21
MSG_TYPE_PROXY_REQUEST_IS_CHUNKED = 22
MSG_TYPE_PROXY_RESPONSE_IS_CHUNKED = 23
MSG_TYPE_PROXY_PUBLISH_CHUNK = 24
MSG_TYPE_PROXY_REQUEST_CHUNK = 25
MSG_TYPE_PROXY_RESPONSE_CHUNK = 26
MSG_TYPE_PROXY_PUBLISH_END_CHUNKS = 27
MSG_TYPE_PROXY_REQUEST_END_CHUNKS = 28
MSG_TYPE_PROXY_RESPONSE_END_CHUNKS = 29

# error codes
RPC_ERR_MALFORMED = 1
RPC_ERR_NOHANDLER = 2
RPC_ERR_NOMETHOD = 3
RPC_ERR_KNOWN = 4
RPC_ERR_UNKNOWN = 5
RPC_ERR_LOST_CONN = 6
RPC_ERR_UNSER_RESP = 7
RPC_ERR_BADARGS = 8

REVERSE = dict((val, key)
        for (key, val) in globals().items()
        if key.startswith("MSG_TYPE"))
