# coding: utf-8

import json
import os

BASE_PATH = os.path.dirname(__file__)
RECIPES_PATH = 'recipes'

def auth_request():
    message = {'command': 'auth_request'}
    return json.dumps(message)

def auth_response(allow):
    if allow:
        message = {'command': 'auth_response', 'response': 'allow'}
    else:
        message = {'command': 'auth_response', 'response': 'deny'}
    return json.dumps(message)

def state_request():
    message = {'command': 'state_request'}
    return json.dumps(message)

def installation_request(recipe_name, config):
    recipe_file = open(os.path.join(BASE_PATH, RECIPES_PATH, recipe_name), 'r')
    setup_tools_file = open(os.path.join(BASE_PATH, 'setup_tools.py'), 'r')                
    message = {'command': 'installation_request',
               'config': config,
               'recipe': recipe_file.read(),
               'recipe_name': recipe_name,
               'setup_tools': setup_tools_file.read()}
    return json.dumps(message)

def stop_installation_request():
    message = {'command': 'stop_installation_request'}
    return json.dumps(message)

def exit_request():
    message = {'command': 'exit_request'}
    return json.dumps(message)