#!/usr/bin/env python
# coding: utf-8

import os
import shutil
import sys
#import glob

from distutils.core import setup


settings_path = '/etc/junta-server'
settings_name = 'settings.json'
settings_path_name = os.path.join(settings_path, settings_name)

default_settings_path = '/etc/junta-server'
default_settings_name = 'default_settings.json'
default_settings_path_name = os.path.join(default_settings_path, default_settings_name)

setup(
    name='junta-server',
    version='1.0.2',
    packages=['junta'],
    package_dir={'junta': ''},
    data_files=[
        ('/etc/init', ['upstart/junta-server.conf']),
        (default_settings_path, [default_settings_name])
        ],
    author='iVideon',
    author_email='support@ivideon.ru',
    url='https://bitbucket.org/ivideon/junta'
    )

if 'install' in sys.argv:
    if not os.path.isfile(settings_path_name):
        try:
            shutil.copyfile(default_settings_path_name, settings_path_name)
        except Exception as e:
            print "Error: can not copy config file. Exception: {}.".format(e)
