# coding: utf-8

import glob
import os
import cgitb
import logging
import sys

import time
import tornado.web
from xml.etree import ElementTree

from dbinterface import get_agents_names, get_installed_programs_on_server,\
                    get_installation_log, new_installation, set_installation_status
from sharedvariables import agents_list
from servertoagent import installation_request

DEBUG = False

BASE_PATH = os.path.dirname(__file__)

RECIPES_PATH = 'recipes'
TEMPLATES_PATH = 'templates'

logging.basicConfig(filename='/opt/ivideon/junta/log/webhandlers.log', level=logging.DEBUG)

def find_agent_by_name(name):
    for a in agents_list:
        if a[1] == name:
            return a[0]
    return None

def get_recipes_and_servers():
    pattern = os.path.join(BASE_PATH, RECIPES_PATH, '*.xml')
    recipes = [s.split('/')[-1] for s in glob.glob(pattern)]
    recipes.remove('recipe_template.xml')
    servers = [(a, get_server_status(a)) for a in get_agents_names()]
    return recipes, servers

def get_server_status(server_name):
    to_agent = find_agent_by_name(server_name)
    if to_agent is None:
        return 'Offline'
    else:
        return to_agent.state

def get_default_config(recipe_name):
    path = os.path.join(BASE_PATH, RECIPES_PATH, recipe_name)
    tree = ElementTree.parse(path)
    conf = []
    for arg in tree.findall('./Args/Arg'):
        name = arg.text
        default = arg.get('default', '')
        if arg.get('type') == 'password':
            conf.append((name, default, 'password'))
        else:
            conf.append((name, default, 'text'))

    return conf

def get_config_list(recipe_name, config_dict):
    path = os.path.join(BASE_PATH, RECIPES_PATH, recipe_name)
    tree = ElementTree.parse(path)
    conf = []
    for arg in tree.findall('./Args/Arg'):
        name = arg.text
        if name in config_dict:
            conf.append(config_dict[name])
        else:
            conf.append('')


class GetHomePage(tornado.web.RequestHandler):
    def get(self, *args):
        try:
            recipes, servers= get_recipes_and_servers()
            self.render(os.path.join(TEMPLATES_PATH, "home.html"), recipes=recipes, servers=servers)
        except Exception as e:
            logging.error(cgitb.text(sys.exc_info()))

class GetServersPage(tornado.web.RequestHandler):
    def get(self, *args):
        try:
            recipes, servers= get_recipes_and_servers()
            server_name = args[0]
            status = get_server_status(server_name)
            installed = get_installed_programs_on_server(server_name)
            
            self.render(os.path.join(TEMPLATES_PATH, "servers.html"), recipes=recipes, servers=servers, 
                        server_name=server_name, status=status, installed=installed)
        except Exception as e:
            logging.error(cgitb.text(sys.exc_info()))
        
    def post(self, *args):
        try:
            if self.get_argument("action") == u'Установить':    #step 1
                recipes, servers= get_recipes_and_servers()
                recipe_name = self.get_argument("recipe_name")
                server_name = self.get_argument("server_name")
                status = get_server_status(server_name)
                config = get_default_config(recipe_name)
                self.render(os.path.join(TEMPLATES_PATH, "installation.html"), recipes=recipes, servers=servers,
                            recipe_name=recipe_name, server_name=server_name,
                            status=status, in_process=False, config=config, log=[])
            elif self.get_argument("action") == u'Готово':
                if not "configuration" in self.request.arguments:   # step 2
                    recipes, servers= get_recipes_and_servers()
                    recipe_name = self.get_argument("recipe_name")
                    server_name = self.get_argument("server_name")
                    status = get_server_status(server_name)
                    
                    config = []
                    log = []
                    
                    self.render(os.path.join(TEMPLATES_PATH, "installation.html"), recipes=recipes, servers=servers, 
                                recipe_name=recipe_name, server_name=server_name, 
                                status=status, in_process=False, config=config, log=log)
                else:   #step 3
                    recipes, servers= get_recipes_and_servers()
                    recipe_name = self.get_argument("recipe_name")
                    server_name = self.get_argument("server_name")
                    status = get_server_status(server_name)
                    config = {}
                    for arg in self.request.arguments:
                        if '.' in arg:
                            key = arg.split('.')[1]
                            val = self.get_argument(arg)
                            config[key] = val
                    default_config = get_default_config(recipe_name)
                    for d_c in default_config:
                        if d_c[0] not in config:
                            config[d_c[0]] = d_c[1]
                    to_agent = find_agent_by_name(server_name)
                    if to_agent is not None:
                        new_installation(server_name, recipe_name, config)
                        self.redirect("/installation/"+ server_name + "/" + recipe_name)
                        time.sleep(0.5)
                        to_agent.reset_counter()
                        to_agent.write_message(installation_request(recipe_name, config))
                    else:
                        self.redirect('/')
            else:   # "Cancel" pressed
                if "server_name" in self.request.arguments:
                    self.redirect("/servers/" + self.get_argument("server_name"))
                else:
                    self.redirect('/')
        except Exception as e:
            logging.error(cgitb.text(sys.exc_info()))


class GetInstallationPage(tornado.web.RequestHandler):
    def get(self, *args):
        try:
            recipes, servers= get_recipes_and_servers()
            server_name = args[0]
            recipe_name = args[1]
            status = get_server_status(server_name)
        
            log = get_installation_log(server_name, recipe_name)    
        
            self.render(os.path.join(TEMPLATES_PATH, "installation.html"), recipes=recipes, servers=servers, 
                    recipe_name=recipe_name, server_name=server_name, 
                    status=status, in_process=True, config=[], log=log)
        except Exception as e:
            time.sleep(0.1)
            self.get(self, *args)
            logging.error(cgitb.text(sys.exc_info()))


class GetRecipesPage(tornado.web.RequestHandler):
    def get(self, *args):
        try:
            recipes, servers= get_recipes_and_servers()
            file_name = None
            file_content = None
            if len(args) > 0:
                if args[0] == "add_recipe":
                    file_name = "new_recipe.xml"
                    file_ = open(os.path.join(BASE_PATH, RECIPES_PATH, "recipe_template.xml"), 'r')
                else:
                    file_name = args[0]
                    file_ = open(os.path.join(BASE_PATH, RECIPES_PATH, file_name), 'r')
                file_content = file_.readlines()
                file_.close()
            
            self.render(os.path.join(TEMPLATES_PATH, "recipes.html"), recipes=recipes, servers=servers, 
                        file_name=file_name, file_content=file_content)
        except Exception as e:
            logging.error(cgitb.text(sys.exc_info()))
        
    def post(self, *args):
        if self.get_argument("action") == u'Сохранить':
            file_name = self.get_argument("name")
            file_content = self.get_argument("content")
            file_ = open(os.path.join(BASE_PATH, RECIPES_PATH, file_name), 'w')
            file_.writelines(file_content)
            if DEBUG:
                print "recipe is saved"
        self.redirect("/")
