# coding: utf-8
import json
import cgitb
import logging
import sys

import pymongo
import time
from ws4py.server.handler.tornadohandler import WebSocketHandler

from dbinterface import agent_login, save_log, set_installation_status
from sharedvariables import agents_list
from servertoagent import auth_request, auth_response, state_request, \
                    installation_request, stop_installation_request, exit_request
from webhandlers import get_server_status

DEBUG = True

browsers = []

logging.basicConfig(filename='/opt/ivideon/junta/log/agentshandler.log', level=logging.DEBUG)

def notify_browsers():
    for ws in browsers:
        ws.write_message("*")
        
def print_agents ():
    print 'agents_list:'
    for a in agents_list:
        print a[1]

class AgentsHandler(WebSocketHandler):
    def open(self):
        agents_list.append([self, ""])
        self._agent_name = ""
        self._logined = False
        self._no = 0
        self._state = 'Unknown'
    
    def reset_counter(self):
        self._no = 0
        
    @property
    def state(self):
        return self._state
    
    def to_exit(self):
        self.write_message(exit_request())
        
    def on_close(self):
        for a in agents_list:
            if a[1] == self._agent_name:
                agents_list.remove(a)
                break
        
        notify_browsers()
        if DEBUG:
            print_agents()

    def on_message(self, message):
        message = json.loads(message)
        command = message['command']
        
        if not self._logined and command != 'auth_response':
            self.write_message(auth_request())
        try:
            if command == 'auth_response':
                self._auth(message['login'], message['password'])
            elif command == 'state_response':
                self._set_state(message['state'])
            elif command == 'change_installation_state':
                set_installation_status(self._agent_name, message['recipe_name'], message['status'])
            elif command == 'log_message':
                self._save_log(message['recipe_name'], message['msg_type'], message['msg'])
            else:
                print 'UNKNOWN COMMAND', command
        except Exception as e:
            logging.error(cgitb.text(sys.exc_info()))
                
    def _auth(self, login, password):
        if get_server_status(login) != 'Offline':
            self._logined = False
        else:
            self._logined = True  # TODO replace with auth function
            
        if self._logined:
            self._agent_name = login
            self._set_name_in_agents_list()
            agent_login(login)
            notify_browsers()
            if DEBUG:
                print 'Agent', self._agent_name, 'allowed.'
                print_agents()
            self.write_message(auth_response(True))
        else:
            if DEBUG:
                print 'Agent', self._agent_name, 'denied.'
            time.sleep(1)
            self.write_message(auth_response(False))
            self.write_message(auth_request())

    def _set_state(self, state):
        self._state = state
        notify_browsers()
        if DEBUG:
            print 'Agent', self._agent_name, 'has new state: ', state

    def _save_log(self, recipe_name, msg_type, msg):
        self._no += 1
        save_log(self._agent_name, recipe_name, msg_type, msg, self._no)
        time.sleep(0.2)
        notify_browsers()

    def _set_name_in_agents_list(self):
        for a in agents_list:
            if a[0] == self:
                a[1] = self._agent_name
                break
        

class BrowsersHandler(WebSocketHandler):
    def open(self):
        browsers.append(self)

    def on_close(self):
        if self in browsers:
            browsers.remove(self)
        else:
            print 'error' 
