# coding: utf-8

import os
from threading import Thread
import time
import tornado.ioloop
import tornado.web
import tornado.httpserver

from agentshandler import AgentsHandler, BrowsersHandler
from sharedvariables import agents_list
from webhandlers import GetHomePage, GetServersPage, GetRecipesPage, GetInstallationPage

WEB_PORT = 8000
AGENTS_PORT = 8001
STATIC_PATH = os.path.join(os.path.dirname(__file__), 'static')


class HttpServerThread(Thread):
    def __init__(self, urls, port, *args, **kwargs):
        Thread.__init__(self, *args, **kwargs)
        app = tornado.web.Application(urls)
        http_server = tornado.httpserver.HTTPServer(app)
        http_server.listen(port)
        self._stop = False
        self.daemon = True

    def stop(self):
        print 'Stop.'
        self._stop = self.__stop()
        self._loop.stop()
    
    def run(self):
        while not self._stop:
            try:
                self._loop = tornado.ioloop.IOLoop.instance()
                self._loop.start()
            except KeyboardInterrupt:
                print "Thread KeyboardInterrupt"
                break
    
def start_servers ():
    web_urls = [(r'/socket', BrowsersHandler),
                (r'/installation/(.*)/(.*)', GetInstallationPage),
                (r'/static/(.*)', tornado.web.StaticFileHandler, {'path': STATIC_PATH}),
                (r'/(.*.png)', tornado.web.StaticFileHandler, {'path': STATIC_PATH}),
                (r'/', GetHomePage), 
                (r'/recipes/(.*)', GetRecipesPage),
                (r'/servers/(.*)', GetServersPage)]
    
    agents_urls = [(r'/agent-server', AgentsHandler)]
    
    web_server_thread = HttpServerThread(web_urls, WEB_PORT)
    agents_server_thread = HttpServerThread(agents_urls, AGENTS_PORT)
    try:
        web_server_thread.start()
        agents_server_thread.start()
        while True:
            time.sleep(5)
    except KeyboardInterrupt:
        for a in agents_list:
            a[0].to_exit()
        print "Exit."
        exit(0)
    else:
        pass
        
if __name__ == '__main__':
    start_servers()
