# coding: utf-8

import datetime

import pymongo

DB_NAME = 'testdb'
db = pymongo.Connection()[DB_NAME]

def agent_login(agent_id):
    exist = db.agents.find({'_id': agent_id}).count() > 0
    if not exist:
        db.agents.save({'_id': agent_id, 'name': agent_id})
    
def get_agents_names():
    agents = db.agents.find()
    return [a['name'] for a in agents]

def new_installation(server_name, recipe_name, config):
    db.log.remove({'server_name': server_name, 'recipe_name': recipe_name})
    db.installed.remove({'server_name': server_name, 'recipe_name': recipe_name})
    db.installed.save({'server_name': server_name, 
                       'recipe_name': recipe_name,
                       'date': str(datetime.datetime.now())[:19],
                       'status': 'sent',
                       'config': config})

def get_installed_programs_on_server(server_name):
    installed_list = db.installed.find({'server_name': server_name})
    return [dict(ins) for ins in installed_list]
    
def save_log(server_name, recipe_name, msg_type, msg, n):
    db.log.save({'server_name': server_name, 
                 'recipe_name': recipe_name,
                 'type': msg_type,
                 'message': msg,
                 'n': n})    
    
def get_installation_log(server_name, recipe_name):
    res = db.log.find({'server_name': server_name, 'recipe_name': recipe_name})
    log = []
    for r in res:
        log.append((r['n'], r['type'], r['message']))
        
    def cmp_func(a, b):
        if int(a[0]) > int(b[0]):
            return 1
        elif int(b[0]) == int(a[0]):
            return 0
        else:
            return -1
            
    log.sort(cmp=cmp_func)
    return log

def set_installation_status(server_name, recipe_name, status):
    res = db.installed.find({'server_name': server_name, 'recipe_name': recipe_name})
    for r in res:
        r['status'] = status
        db.installed.save(r)
        break
