# coding: utf-8
import sys

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

if not 'java' in sys.platform.lower():
    raise Exception('This package can only be installed on Jython.')

long_description = open('README.txt').read()

setup(
    name='jython-swingutils',
    version='1.0b1',
    description="Makes using Java's Swing UI toolkit easy on Jython",
    long_description=long_description,
    author='Alex Gronholm',
    author_email='swingutils@nextday.fi',
    url='http://pypi.python.org/jython-swingutils/',
    classifiers=[
      'Development Status :: 4 - Beta',
      'Intended Audience :: Developers',
      'License :: OSI Approved :: MIT License',
      'Programming Language :: Python',
      'Programming Language :: Python :: 2.5',
      'Programming Language :: Java',
    ],
    keywords='jython swing',
    license='MIT',
    packages=[
        'swingutils',
        'swingutils.binding',
        'swingutils.binding.adapters',
        'swingutils.dialogs',
        'swingutils.models',
        'swingutils.thirdparty',
        'swingutils.threads'
    ],
)
