# -*- coding: utf-8 -*-

#    This file is part of KTBS <http://liris.cnrs.fr/sbt-dev/ktbs>
#    Copyright (C) 2011-2012 Pierre-Antoine Champin <pchampin@liris.cnrs.fr> /
#    Françoise Conil <francoise.conil@liris.cnrs.fr> /
#    Universite de Lyon <http://www.universite-lyon.fr>
#
#    KTBS is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Lesser General Public License as published
#    by the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    KTBS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public License
#    along with KTBS.  If not, see <http://www.gnu.org/licenses/>.

"""I provide an implementation of the `abstract-ktbs-api`:ref:.

This implementation is defined as a set of mix-in classes that rely on the
uniform interface of `rdfrest.interface.IResource`:class:. This allows to use
those classes in different ways:

* as local instances (for a standalone kTBS embeded in one's application),
* as an HTTP client to a remote kTBS,
* or even as a client through any protocol implemented on top of
  `rdfrest`:mod:.


Extensions to the abstract API
==============================

I implement the following extensions to the default `abstract-ktbs-api`:ref:.

Extensions suggested by the abstract API
----------------------------------------

* read-only or read-write properties corresponding to get/set methods
* read-only properties corresponding to list methods
* iter methods corresponding to list methods

Note also that those adaptations are automatically generated by the
`~.utils.extend_api`:func: class decorator.

Specific extensions for function parameters
-------------------------------------------

* Anytime a kTBS element is expected, passing a URI should also work
  (including a URI relative to the target object). For example, the 'model'
  argument of :meth:`~.base.Base.create_stored_trace` can be a URI (as a
  unicode or an `~rdflib.URIRef`:class:) rather than an instance of
  :class:`~.trace_model.TraceModel`.

* Datetimes can be used instead of integers for representing timecodes in
  traces when the trace model and origin allow the conversion.

.. _ktbs-resource-creation:

Specific extensions for creation methods
----------------------------------------

* The `id` parameter is specified in the `abstract-ktbs-api`:ref: in all
  creation methods: it is often optional but can be used to set the URI of the
  resource to create (else, the KTBS will generate a URI). If provided, it must
  of course be an acceptable URI (not already in use, and subordinated to the
  parent's URI). As specified by the `abstract-ktbs-api`:ref:, `id` can be
  provided as character string, representing a URI either absolute or relative
  to the parent's URI. The Python implementation also accepts a
  `rdflib.URIRef`:class: or any object with a `uri` attribute returning a
  `~rdflib.URIRef`:class:.

* Creation methods also accept an additional parameter `graph` where the user
  can specify arbitrary properties for the resource to create. This assumes
  that the resource can be identified in the graph, which is trivial is `id` is
  provided. However, if the user wants to provide a `graph` but also wants to
  let the KTBS mint a URI for the created resource, they can use a
  `blank node <rdflib.BNode>`:class:) to represent the resource in `graph`, and
  pass it to `id`.

"""
