
import sys
from setuptools import setup

# use the version of the framework package as the base version:
try:
    import kabaret.version
except ImportError:
    version = lambda: '0.0.0a1'
else:
    version = kabaret.version.get()


if not hasattr(sys, 'version_info') or sys.version_info < (2, 5, 0, 'final'):
    raise SystemExit("Kabaret requires Python 2.5 or later.")

install_requires = []

setup(
    name='kabaret.core',
    namespace_packages=['kabaret'],
    packages=['kabaret','kabaret.core'],
    version=version,
    install_requires=install_requires,
    description='Base package for the kabaret framework.',
    url='http://packages.python.org/kabaret',
    author='Damien Coureau',
    author_email='dee@dee909.com',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        
        'Topic :: Office/Business :: Groupware',
        'Topic :: Office/Business :: Scheduling',
        
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Information Technology',
        
        'Operating System :: OS Independent',
        
        'Programming Language :: Python :: 2.5',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
)