

from kabaret.core.station_config import get_station_class
from kabaret.core.events.dispatcher import EventDispatcher
from kabaret.core.events.event import Event
from kabaret.core.apps import load_apps
#from kabaret.core.utils import opi


class AppHost(object):
    def __init__(self, project):
        # project is actually a ProjectInterface!
        super(AppHost, self).__init__()
        self._project = project
        self.project_name = project.project_name
        
        self.station_config = self._project.get_station_config(
            get_station_class()
        )
        self.station_config.apply()
        
        self._clients = set()

        # this event dispatcher let the app
        # connect to others apps events.
        self._event_dispatcher = EventDispatcher()

        self._apps = {}
        self._load_apps()
        
    def _load_apps(self):
        # instanciate the apps
        app_refs = self._project.get_settings().APPS
        self._apps = load_apps(app_refs, apphost=self)
        
        # setup the apps
        setting_dir = self.station_config.project_dirs['SETTINGS_DIR']
        for key, app in self._apps.items():
            app.set_event_emitter(self.emit_app_event)
            app._load_settings(key, setting_dir)
        
        for app in self._apps.values():
            app._host_init_done()
            
    def app_keys(self, in_project=False):
        '''
        Returns a list of app keys declared in this
        apphost (or in the project if in_project is True)
        ''' 
        if in_project:
            return self._project.app_keys()
        return self._apps.keys()
        
    def app(self, app_key, in_project=False):
        '''
        Returns the hosted app declared with the given key, or
        None if no such app was declared in the project
        settings.
        '''
        if in_project:
            return self._project.app(app_key)
        return self._apps.get(app_key, None)
    
    def get_commands(self, app_key=None, menu=None):
        '''
        Returns the ui information of the commands in the 
        given app (or all apps) that are present
        in the given menu (or all menus).
        '''
        actions = {}
        for key, app in self._apps.items():
            if app_key is not None and key != app_key:
                continue
            if key not in actions:
                actions[key] = []
            actions[key].extend(
                [
                    a.ui_infos(n) for n, a in app._commands.items() 
                    if (menu is None) or menu in a.CMD_MENUS
                ]
            )
        return actions
        
    def register_client(self, client_opi):
        self._clients.add(client_opi)
        
    def add_event_handler(self, handler, path, etype=None):
        '''
        This gives each app in the host the opportunity
        to receive events from other apps.
        '''
        self._event_dispatcher.add_handler(
            handler, path, etype
        )

    def emit_app_event(self, event):
        # dispatch event to apps first
        self._event_dispatcher.dispatch(event)
        
        # publish to clients if still needed:
        dead_clients = set()
        for  c in self._clients:
            if not event.propagating:
                break
            try:
                c.receive_event(event)
            except Exception, err:
                # most likely a communication error
                # but we are not in ro so we
                # are not allowed to check it.
                # we simply drop the client
                print err
                print 'Dropping Client', c
                dead_clients.add(c)
        print '-------------'
        print dead_clients
        print '-----'
        print self._clients
        self._clients -= dead_clients
        print '----->LL'
        print self._clients

    def do_cmd(self, path, args, kwargs):
        print 'AppHost got command %r(%r, %r)'%(path, args, kwargs)
#        print '    sending message to all clients.'
#        msg = 'Got command %r(%r, %r)'%(path, args, kwargs)
#        self.emit_app_event(Event(path, Event.TYPE.MESSAGE, msg))
        app_name, cmd_name = path
        try:
            ret = getattr(self.app(app_name), cmd_name)(*args, **kwargs)
        except Exception, err:
            print '  ERROR:', err
            raise
        return ret
    
    def do_project_cmd(self, path, *args, **kwargs):
        print 'AppHost got Project command %r(%r, %r)'%(path, args, kwargs)
        print '    sending back message to all clients.'
        msg = 'Got project command %r(%r, %r)'%(path, args, kwargs)
        self.emit_app_event(Event(path, Event.TYPE.MESSAGE, msg))
        return path
    

#class AppHostInterface(opi.OPI):
#    _IMP_CLASS = AppHost
#    _PUBLIC_QUERIES = (
#        'action',
#    )
#    _PUBLIC_CALLS = (
#        'register_client',
#        'a'
#    )
#
#    def __init__(self, project):
#        super(AppHostInterface, self).__init__(project)

#    def register_client(self, client):
#        self._imp.register_client(client)
#    
#    def action(self, arg):
#        import sys
#        sys.stderr.write('AppHost got action args %r, sending back message to all clients.\n'%(arg,))
#        sys.stderr.flush()
#        [ c.message('Got action %r'%(arg,)) for c in self._imp._clients ]
#        return arg
#    
#    def a(self, x):
#        import sys
#        sys.stderr.write('--------------A'+str(x)+'\n')
#        sys.stderr.flush()

