
#TODO: all doit should be wrapped by a try/raise CommandError
#also, maybe the Command should have a class attr "RAISES" to
#raise this instead of CommandError

#TODO: the keyword only in command call is a pita!!!

class Arg(object):
    def __init__(self,
        name=None,
        default=None,
        label=None,
        types=None,
        ui=None,
    ):
        self.name = None
        self.label = label
        self.types = types
        self.default = default
        self.ui = ui
    
class CommandType(type):
    def __new__(cls, class_name, bases, class_dict):
        args = {}
        for n, o in class_dict.items():
            if isinstance(o, Arg):
                o.name = n
                if o.label is None:
                    o.label = n
                args[n] = o
                class_dict[n] = ArgDescriptor(n)
        
        if class_dict.get('CMD_LABEL', None) is None:
            class_dict['CMD_LABEL'] = class_name
            
        class_dict['_CMD_ARGS'] = args
        app_class = super(CommandType, cls).__new__(cls, class_name, bases, class_dict)
        return app_class

class ArgDescriptor(object):
    def __init__(self, name):
        self.name = name
        
    def __get__(self, cmd, cmd_type):
        if cmd is None:
            return cmd_type._CMD_ARGS[self.name]
        try:
            return cmd._arg_values[self.name]
        except KeyError:
            return cmd_type._CMD_ARGS[self.name].default

class CommandError(Exception):
    pass

class Command(object):
    __metaclass__ = CommandType

    CMD_TOPICS = []
    CMD_BLOCKS_TOPICS = []
    CMD_LABEL = None
    CMD_MENUS = []
    CMD_ICON = None

    def __init__(self, app, **kwargs):
        self.app = app
        self._arg_values = kwargs
    
    @classmethod
    def ui_infos(cls, name):
        return {
            'name':name, 
            'topics':cls.CMD_TOPICS,
            'blocks_topics':cls.CMD_BLOCKS_TOPICS,
            'label':cls.CMD_LABEL,
            'menus':cls.CMD_MENUS,
            'icon':cls.CMD_ICON,
        }
    
    @classmethod
    def usage(cls):
        return '%s.%s(app, %s)'%(
            cls.__module__, cls.__name__, 
            ', '.join([ '%s=%r'%(k, v.default) for k, v in cls._CMD_ARGS.items() ])
        )
        
    def get_args(self):
        return self.__class__._args
    
    def get_values(self):
        return self._values
    
    def __call__(self):
        return self.doit()
    
    def doit(self):
        raise NotImplementedError
    
    def undoit(self):
        raise NotImplementedError






if __name__ == '__main__':
    class TestCmd(Command):
        name = Arg(default='DEFAULT')
        value = Arg()
        
        def doit(self):
            print "Doing TestCmd(%r, %r)"%(self.name, self.value)
            return self.name, self.value
        
        def undoit(self):
            print "UnDoing TestCmd(%r, %r)"%(self.name, self.value)
            return self.value, self.name 
        
    cmd = TestCmd(app=None)
    assert cmd.doit() == ('DEFAULT', None)
    assert cmd.undoit() == (None, 'DEFAULT')

    cmd = TestCmd(None, value=12)
    assert cmd.doit() == ('DEFAULT', 12)
    assert cmd.undoit() == (12, 'DEFAULT')
    
    
        