
#from kabaret.core.utils.callbacks import weak_ref

#TODO: find a way to get ride of dead weak refs


class EventDispatcher(object):
    def __init__(self):
        super(EventDispatcher, self).__init__()
        self._event_handlers = {} # path_string: (etype or None, [list of weak_ref(handler)])
    
    def add_handler(self, handler, path, etype):
        path_str = '^'.join(path)
        (_, l) = self._event_handlers.get(path_str, (etype, []))
#        l.append(weak_ref(handler))
        l.append(handler)
        self._event_handlers[path_str] = (etype, l)

    def dispatch(self, event):
        # Filter event handler that match
        # the event path and etype
        path = event.path
        path_str = '^'.join(path)
        etype = event.etype
        startswith = str.startswith # bring to local scope for speed
        path_and_handlers = [
            (eh_path_str, ehs) for eh_path_str, (eh_etype, ehs) in self._event_handlers.iteritems()
            if startswith(path_str, eh_path_str) and (eh_etype is None or eh_etype==etype) 
        ]

        # Trigger all event handlers until
        # the event does not propagate.
        #
        # This code seams odd but is ultra fast:
        try:
            [ 
                1/0
                for _path, ehs in path_and_handlers 
                for eh in ehs 
                if eh(event) and not event.propagating 
            ]
        except ZeroDivisionError:
            # the event does not propagate
            # anymore.
            pass
