 
 
import os
import sys
import multiprocessing

import Pyro4

from kabaret.core.apphost import AppHost

from . import url
from . import this_host
from . import CommunicationError


class AppHostService(AppHost):
    def __init__(self, project_name):
        self.project_name = project_name
        project_url = url.For.project(project_name)
        project = url.resolve(project_url, local=False)
        super(AppHostService, self).__init__(project)
                                        
    def kill(self):
        import signal
        os.kill(os.getpid(), signal.SIGTERM)
               
#    def settings(self):
#        print('Request Settings')
#        return self.project.settings()

    def ping(self):
        return '%s (pid:%s)'%(self._pyroDaemon.locationStr, os.getpid())
    
    def ping_project(self):
        return self._project.ping()

#    def action(self, arg):
#        sys.stderr.write('AppHost got action args %r, sending back message to all clients.\n'%(arg,))
#        sys.stderr.flush()
#        print('AppHost got action args %r, sending back message to all clients.\n'%(arg,))
#        [ c.message('Got action %r'%(arg,)) for c in self._clients ]
#        return arg
#    
#    def a(self, x):
#        sys.stderr.write('--------------A'+str(x)+'\n')
#        sys.stderr.flush()


def start_service(project_name):
    with Pyro4.core.Daemon(this_host()) as daemon:
        with url.get_service(local=True) as urls:
            ah=AppHostService(project_name)
            uri=daemon.register(ah)
            urls.register(url.For.apphost(project_name), uri)
            daemon.requestLoop() #TODO: make the loop condition work!
            daemon.shutdown()
            urls.unregister(url)
            
def start_service_in_process(project_name):
    print('Starting %r AppHost in separate process'%(project_name,))
    p = multiprocessing.Process(
        target=start_service,
        args=(project_name,)
    )
    p.daemon = True
    p.start()
    
    app_host_url = url.For.apphost(project_name)
    app_host = url.wait_for_resolve(app_host_url, local=True)
    return app_host


#def get_local_name_server():
#    name_server_address = socket.gethostname()
#    try:
#        name_server = Pyro4.locateNS(name_server_address)
#    except Pyro4.errors.NamingError:
#        raise Exception('Unable to locate a NameServer on %r'%(name_server_address,))
#    else:
#        print('Name Server found:', name_server._pyroUri)
#    return name_server

def ensure_service(project_name, new_process=True):
    apphost = None
    try:
        apphost = url.resolve(url.For.apphost(project_name), local=True)
    except url.UrlError:
        print 'No AppHost service found for %r, starting a one.'%(project_name,)
    except CommunicationError:
        print 'Dead AppHost service found for %r, starting a one.'%(project_name,)
    else:
        print 'AppHost Service found:', apphost._pyroUri.location
            
    if apphost is None:
        if new_process:
            return start_service_in_process(project_name)
        else:
            start_service(project_name)
    return apphost
    
    
    
if __name__ == '__main__':
    import sys
    project_name = sys.argv[1:]
    if not project_name:
        raise RuntimeError('Please provide the project name in first command line argument.')
    apphost = ensure_service(project_name, new_process=True)

    r = raw_input('Press Enter to close the app host service (or k+Enter to kill it).')
    if r == 'k':
        apphost._pyroOneway.add('kill')
        apphost.kill()
        print 'AppHost Killed.'
    else:
        print 'AppHost Stopped.'
    
