 

import multiprocessing
import socket

import kabaret.core.admin.projects
#from kabaret.core.events.event import Event
#from kabaret.core.events.dispatcher import EventDispatcher

from ..mq.async import AsyncService, AsyncClient
from ..mq.name_service import ExposeServices


class ProjectService(AsyncService):
    def __init__(self, store_path, project_name):
        super(ProjectService, self).__init__()

        self._project = kabaret.core.admin.projects.Project(
            store_path, project_name
        )

        self._rpc_ops = {
            # declared here (service.project.Service):
            'stop':self.stop,
            'request_port':self.request_port,
            'name':self.name,
            'apphost_rpc_port':self.apphost_rpc_port,
            'settings': self.settings,
            'test': self.test,
            
            # declared in base (AsyncService):
            'publish': self.publish,
            '_get_ps_port': self._get_ps_port,
        }

    def _get_rpc_handler(self, op):
        return self._rpc_ops.get(op)

    def stop(self):
        self.loop.stop()

    def request_port(self):
        '''
        Returns the port to use for name_service of
        AppHosts
        '''
        return self._project.settings.NAME_SERVICE.request_port
    
    def name(self):
        '''
        Returns the name of the project
        '''
        return self._project.name
    
    def apphost_rpc_port(self):
        '''
        Returns the port to use for AppHosts rpc
        '''
        return 2000 #TODO: should be managed by self._project
    
    def settings(self):
        return self._project.settings

    def test(self):
        return 'OK TEST', repr(self._project.settings.STATIONS.CLASSES)


class ProjectServiceProcess(multiprocessing.Process):
    def __init__(self, store_path, project_name):
        super(ProjectServiceProcess, self).__init__(
            name='Kabaret_ProjectServiceProcess_'+project_name
        )
        self.store_path = store_path
        self.project_name = project_name
        
    def run(self):
        print 'Building Project Service'
        # Create the ProjectService and bind to random
        service = ProjectService(self.store_path, self.project_name)
        service.bind_to_random('*')

        # Create and start an ExposeService sub process to serve the
        # ProjectService's address
        services = {
            'reversion:%s'%(self.project_name,): 'http://the_url:reversion_port',
            'project:%s'%(self.project_name,): '%s://%s:%i'%(
                service.protocol, 
                socket.gethostbyname(socket.gethostname()), 
                service.rpc_port
            ),
        }
        exposure_port = service.settings().NAME_SERVICE.request_port
        self.name_service = ExposeServices(
            name="Kabaret_project_NameServer:%s"%(self.project_name,),
            frequence=1, exposure_port=exposure_port,
            **services
        )
        self.name_service.daemon = True
        print 'Exposing Project Service'
        self.name_service.start()

        print 'Starting Service'
        service.loop.start()


class ProjectClient(AsyncClient):
    def __init__(self, adress, port):
        super(ProjectClient, self).__init__()
        self.connect(adress, port)


