

class Event(object):
    '''
    Events are generated by apps to notify all the registered handlers
    of their actions.
    
    An event has a path attribute that identify the object of
    the event, a etype attribute that categorize the event 
    and a (pickable) data attribute containing informations 
    depending on the etype and the path.
    
    An event path is a list of strings.
    The first item should be the name of the app who emits the
    event. All other strings identify the hierarchy leading to
    the object of the event and should be unic for this object. 
    
    Events are dispatched to handlers by the AppHost.
    Handler register themselves with a given event path to receive
    all event with this path or a sub path (see 
    core.mq.apphost.ProjectClient.add_event_handler()).
    The shortest path handler receive the event first and can
    call event.stop() to prevent further handlers to receive
    this event.
    
    '''
    class TYPE:
        CREATED = 'CREATED'
        UPDATED = 'UPDATED'
        DELETED = 'DELETED'
        MESSAGE = 'MESSAGE'
        
    def __init__(self, path, etype, data):
        '''
        /!\ data must be pickable.
        '''
        self.path = path
        self.etype = etype
        self.data = data
    
        self.propagating = True
    
    def to_dict(self):
        return {
            'path':self.path,
            'etype':self.etype,
            'data':self.data,
        }
    
    @classmethod
    def from_dict(cls, d):
        return cls(**d)
    
    def stop(self):
        self.propagating = False
            