


import os
import socket
import contextlib
import time
import multiprocessing

import Pyro4
import Pyro4.errors

from kabaret.core.utils import get_user_name

URL_ROOT = 'kabaret'

class UrlError(Exception):
    pass

class For(object):
    '''
    This class is used as a namespace for the
    url constructors.
    '''
    @staticmethod
    def project(project_name):
        return '%s/project/%s'%(URL_ROOT, project_name,)
    
    @staticmethod
    def apphost(project_name, user=None, host=None):
        user = user or get_user_name()
        host = host or socket.gethostname()
        return '%s/project/%s/apphost/%s/%s'%(
            URL_ROOT, project_name, host, user
        )    
    
    @staticmethod
    def client(project_name, client_name, user=None, host=None):
        user = user or get_user_name()
        host = host or socket.gethostname()
        return '%skabaret/project/%s/client/%s/%s/%s'%(
            URL_ROOT, project_name, host, user, client_name
        )    

def resolve(url, local=True, ping=True):
    ro = None
    with get_service(local=local) as urls:
        try:
            uri = urls.lookup(url)
        except Pyro4.errors.NamingError:
            raise UrlError('Unable to resole %surl %r'%(local and 'local ' or '', url))
        else:
            ro = Pyro4.Proxy(uri)

        if ping:
            try:
                # Check this service is alive
                ro.ping()
            except Pyro4.errors.CommunicationError:
                # service is unreachable,
                # it was probably killed and did not unregister from
                # the url service.
                # let's clean up the url and raise the error:
                print 'Dead url found, cleaning up url service.'
                urls.remove(url)
                raise
    return ro

def wait_for_resolve(url, local=True, nb_try=5, wait_between=1):
    uri = None
    with get_service(local=local) as urls:
        for _ in range(nb_try):
            try:
                uri = urls.lookup(url)
            except Pyro4.naming.NamingError:
                print '  Waiting for service to register its url.'
                time.sleep(wait_between)
            else:
                print '  Url found.'
                break
    if uri is None:
        raise UrlError('Unable to resole %surl %r'%(local and 'local ' or '', url))
    return Pyro4.Proxy(uri)

@contextlib.contextmanager
def get_service(local=True):
    host = local and 'localhost' or None# #socket.gethostname()
    try:
        with Pyro4.locateNS(host) as url_service:
            yield url_service
    except Pyro4.errors.NamingError:
        raise Exception('Unable to find url service on %r'%(host,))

def start_service(local=True):
    host = local and 'localhost' or socket.gethostname()
    tries = range(3)
    for i, _ in enumerate(tries):
        try:
            Pyro4.naming.startNSloop(
                host=host, port=None,
                enableBroadcast=not local,
                bchost=None, bcport=None,
                unixsocket=None,
                nathost=None, natport=None
            )
        except socket.error, err:
            if err.errno == 98:
                print '#----------- SOCKET ALREADY IN USE!!!!', i
                tries += ['x']
                time.sleep(1)
                
def start_service_in_process(local=True):
    print 'Starting %sUrl in separate process'%(local and 'local ' or '',)
    p = multiprocessing.Process(
        target=start_service,
        args=(local,)
    )
    p.daemon = True
    p.start()
    
    host = local and 'localhost' or socket.gethostname()
    nb_try = 50
    wait_between = 1
    for _ in range(nb_try):
        try:
            url_service = Pyro4.locateNS(host)
        except Pyro4.errors.NamingError:
            print 'Waiting for %sUrl service to be ready.'%(local and 'local ' or '',)
            time.sleep(wait_between)
        else:
            print '%sUrl service up: %s'%(local and 'Local ' or '', url_service._pyroUri)
            return url_service
         
def ensure_service(local=True, new_process=True):
    host = local and 'localhost' or socket.gethostname()
    try:
        url_service = Pyro4.locateNS(host)
    except Pyro4.errors.NamingError:
        print 'No url service found, starting a one.'
        if new_process:
            return start_service_in_process(local=local)
        else:
            start_service(local=local)
    else:
        print 'Url Service found:', url_service._pyroUri
        return url_service

if __name__ == '__main__':
    import sys
    ensure_service(local='local' in sys.argv[1:])

