

import os 
import sys
import platform
import pprint

ENV__STATION_CLASS = 'KABARET_STATION_CLASS'


class StationConfig(object):
    def __init__(self, station_class, store_path, python_paths):
        super(StationConfig, self).__init__()
        self.station_class = station_class
        self.store_path = store_path
        self.python_paths = python_paths
        self.auto_python_paths = []
        self.project_dirs = {}
        
    def __repr__(self):
        return '%s(\n\tstation_class=%r,\n\tstore_path=%r,\n\tpython_paths=%s\n)'%(
            self.__class__.__name__,
            self.station_class, 
            self.store_path,
            pprint.pformat(self.python_paths)
        )

    def copy(self):
        station_config = self.__class__(
            self.station_class,
            self.store_path,
            self.python_paths
        )
        station_config.auto_python_paths = self.auto_python_paths
        station_config.project_dirs = self.project_dirs.copy()
        return station_config
    
    def set_project_dirs(self, key_to_path):
        self.project_dirs = dict(key_to_path)
        
    def apply(self):
        # beware: self.auto_python_paths must be in front
        # of self.python_paths in sys.path since
        # the project Dev must be able to override 
        # the generic code.
        for path in self.python_paths+self.auto_python_paths:
            if path not in sys.path:
                sys.path.insert(0, path)

        
def get_station_config(station_class, station_config_list):
    default_config = None
    selected = None
    for config in station_config_list:
        if default_config is None and config.station_class is None:
            default_config = config
        elif station_class == config.station_class:
            selected = config
            break
        
    if selected is None:
        if default_config is None:
            raise ValueError(
                'Unable to find a StationConfig matching %r, and no default found either'%(
                    station_class
                )
            )
        selected = default_config
    return selected

def get_station_class():
    if ENV__STATION_CLASS in os.environ:
        station_class = os.environ[ENV__STATION_CLASS]
    else:
        station_class = platform.platform(terse=True)
    return station_class
