
import platform

import kabaret.gui.styles.dark
from kabaret.gui import import_qt
QtCore, QtGui = import_qt()

from kabaret.gui.widgets.views import CmdsAppView, ListenerView, ConnectionView
from kabaret.gui.standalone import main_window


def show_ui(client, ui_setup=None):    
    app_name = 'Kabaret::'+client.project_name
    
    app = QtGui.QApplication(sys.argv)
    app.setApplicationName(app_name)
    w = main_window.MainWindow(client)
    w.setWindowTitle(app_name)
    
    if platform.system() not in ('Darwin',):
        kabaret.gui.styles.dark.apply()
    
#    sides = [
#        QtCore.Qt.LeftDockWidgetArea,
#        #QtCore.Qt.RightDockWidgetArea,
#        #QtCore.Qt.TopDockWidgetArea,
#        #QtCore.Qt.BottomDockWidgetArea,
#    ]
#    for i, app_name in enumerate(client.apphost.app_keys()):
#        if app_name == 'CMDS':
#            view_class = CmdView
#        else:
#            view_class = MyView
#        w.create_view(
#            app_name, 'View', view_class, 
#            sides[i%len(sides)], True,
#            #QtGui.QStyle.SP_FileDialogDetailedView
#            ('gui.icons', app_name.lower()+'_app')
#        )
    
    w.create_view(
        u"Launch", 'Applications', CmdsAppView, QtCore.Qt.LeftDockWidgetArea, True, None
    )
    w.create_view(
        u"\u20AD", 'Listener', ListenerView, QtCore.Qt.BottomDockWidgetArea, True, None
    )
    w.create_view(
        u"\u20AD", 'Connection', ConnectionView, QtCore.Qt.RightDockWidgetArea, True, None
    )
    
    if ui_setup is not None:
        ui_setup(w)
        
    w.show()
    app.exec_()


def startup(project_name, ui_setup, verbose):
    import kabaret.core.ro.url
    import kabaret.core.ro.apphost
    import kabaret.core.ro.client
    import traceback
    client = None
    
    try:
        print
        print '#-------------- Local Urls'
        urls = kabaret.core.ro.url.ensure_service(local=True, new_process=True)
        if urls is None:
            raise Exception('Could not find or start a local Url Service.')
        print
        print '#-------------- Local AppHost'
        apphost = kabaret.core.ro.apphost.ensure_service(project_name, new_process=True)
        if apphost is None:
            raise Exception('Could not find or start a local AppHost Service.')
        print
        print '#-------------- Client'
        client = kabaret.core.ro.client.Client(project_name)
        
        try:
            show_ui(client, ui_setup)
        except Exception, err:
            msg = 'There was an unhandled error in GUI: %s\nClosing GUI.'%(err,)
            if verbose:
                msg += '\n'+traceback.format_exc()
            else:
                msg += '\nUse -v or --verbose to see the traceback\n'
            print msg
            
    except Exception, err:
        msg = 'There was an error while starting a service: %s'%(err,)
        if verbose:
            msg += '\n'+traceback.format_exc()
        else:
            msg += '\nUse -v or --verbose to see the traceback\n'
        print msg
        
    finally:
        if client is not None:
            client.shutdown()



if __name__ == '__main__':
    import sys
    
    project_name = 'TEST'
    print 'Starting up Default GUI for project %r (This is pointless...)'%(project_name,)
    sys.exit(startup(project_name, ui_setup=None, verbose=True))
