

import contextlib


from kabaret.gui import import_qt
QtCore, QtGui = import_qt()

from kabaret.core.utils import resources
import kabaret.gui.icons # installs gui icons



class DocTabs(QtGui.QTabWidget):
    def __init__(self, parent):
        super(DocTabs, self).__init__(parent)
        #self.setStyleSheet('QFrame {border: 2px solid yellow;}')

class MainWindow(QtGui.QMainWindow):
    def __init__(self, client):
        super(MainWindow, self).__init__()
        
        self.status_bar = None
        self._install_status_bar() 
        
        self._progress_bar = None
        self._install_progress_bar()

        self._throbber_label = None
        self._install_throbber()
        
        self.menus = {}
        self.menu_bar = None
        self.app_menu = None
        self._install_menu_bar()

        self.view_menu = None
        self._install_view_menu()
        
        self.viewTB = None
        self._install_view_toolbar()

        self.client = client
        self.client_ticker = QtCore.QTimer(self)
        self.connect(
            self.client_ticker, 
            QtCore.SIGNAL('timeout()'), 
            self.client_tick
        )
        self.client_ticker.start(500)

        sides = [
            QtCore.Qt.LeftDockWidgetArea,
            QtCore.Qt.RightDockWidgetArea,
            QtCore.Qt.TopDockWidgetArea,
            QtCore.Qt.BottomDockWidgetArea,
        ]
        for side in sides:
            self.setTabPosition(side, QtGui.QTabWidget.North)

        cw = DocTabs(self)
        self.setCentralWidget(cw)
        
    def _install_status_bar(self):
        self.status_bar = self.statusBar()
        self.status_bar.showMessage("Initializing")
#        status_bar.setSizeGripEnabled(False)

    def _install_progress_bar(self):
        self._progress_bar = QtGui.QProgressBar()
        self._progress_bar.setMinimum(0)
        self._progress_bar.setMaximum(100)
        self._progress_bar.reset()
        self.status_bar.addPermanentWidget(self._progress_bar)

        self._load_label = QtGui.QLabel(self)
        self.status_bar.addPermanentWidget(self._load_label)
        
    def _install_throbber(self): 
        self._throbber_label = QtGui.QLabel(self)
        self._throbber_label.setStyleSheet('border: none;')
        self.throbber_movie = QtGui.QMovie(resources.get('gui.icons', 'throbber.gif'))
        self._throbber_label.setMovie(self.throbber_movie)
        self._throbber_label.resize(16,16)
        self.status_bar.addPermanentWidget(self._throbber_label)

    def _install_menu_bar(self):
        mb = self.menuBar()
        if not mb:
            mb = QtGui.QMenuBar(None)
            self.setMenuBar(mb)
        self.menu_bar = mb

    def _install_view_menu(self):
        self.view_menu = self.menu_bar.addMenu("Views")
        self.view_app_menu = {}

    def _install_view_toolbar(self):
        self.viewTB = QtGui.QToolBar("Views", self)
#        self.viewTB.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
#        self.addToolBar(QtCore.Qt.LeftToolBarArea, self.viewTB)
        self.addToolBar(self.viewTB)

    def show_progress(self, nb_step, curr_step, msg):
        self.status_bar.showMessage(msg)
        self._progress_bar.setMaximum(nb_step)
        self._progress_bar.setValue(curr_step)
    
    def clear_progress(self, msg, delay=500):
        self._progress_bar.setMaximum(100)
        self._progress_bar.reset()
        self.status_bar.showMessage(msg, delay)

    @contextlib.contextmanager
    def wait_cursor(self):
        QtGui.QApplication.instance().setOverrideCursor(QtGui.QCursor(QtCore.Qt.WaitCursor))
        try:
            yield
        finally:
            QtGui.QApplication.instance().restoreOverrideCursor()

    def create_view(
            self, app_name, title, view_class, area, visible, icon=None, allowed_areas=None,
            add_to_view_toolbar=True, view_sets=[]
        ):
        full_title = '%s %s'%(app_name, title)
        if icon is not None:
            icon = resources.get_icon(icon, self)
        
        view_app_menu = self.view_app_menu.get(app_name)
        if view_app_menu is None:
            view_app_menu = self.view_menu.addMenu(app_name)
            if icon is not None:
                view_app_menu.setIcon(icon)
            self.view_app_menu[app_name] = view_app_menu

        d = QtGui.QDockWidget(full_title, self)
        
        if allowed_areas is not None:
            d.setAllowedAreas(
                QtCore.Qt.TopDockWidgetArea
                | QtCore.Qt.BottomDockWidgetArea
            )
        view = view_class(self, self.client, app_name)
        view.name = full_title
        d.setWidget(view)
        def on_visibility_changed(visible):
            with self.wait_cursor():
                view.on_view_toggled(visible)
        d.connect(d, QtCore.SIGNAL('visibilityChanged(bool)'), on_visibility_changed)
        self.addDockWidget(area, d)
        toggle_action = d.toggleViewAction()
        if icon is not None:
            toggle_action.setIcon(icon)
        toggle_action.setStatusTip('Show/Hide %s'%full_title)
        view_app_menu.addAction(toggle_action)
        if add_to_view_toolbar:
            self.viewTB.addAction(toggle_action)
        if not visible:
            d.hide()
                    
        return d

    def client_tick(self):
        status = self.client.tick()
        self._load_label.setText(status)
        self.throbber_movie.jumpToNextFrame()
        