
from kabaret.gui import import_qt
QtCore, QtGui = import_qt()

from kabaret.core.events.event import Event
from kabaret.core.utils import resources

class AbstractView(QtGui.QWidget):
    def __init__(self, parent, client, app_name):
        super(AbstractView, self).__init__(parent)

        self.client = client
        self.app_name = app_name

    def on_view_toggled(self, visible):
        pass


class AppView(AbstractView):
    class CommandInfos(object):
        def __init__(self, name=None, topics=[], blocks_topics=[], label=None, menus=[], icon=None):
            self.name = name
            self.topics = topics
            self.blocks_topics = blocks_topics
            self.label = label
            self.menus = menus
            self.icon = icon

    def __init__(self, parent, client, app_name):
        super(AppView, self).__init__(parent, client, app_name)

        self.setLayout(QtGui.QVBoxLayout())
        
        self.waitter = QtGui.QLabel('Loading')
        self.layout().addWidget(self.waitter)
        
        self.movie = QtGui.QMovie(resources.get('gui.icons', 'throbber.gif'))
        self.waitter.setMovie(self.movie)
        self.movie.start()
        
        self.fetch_commands()
    
    def fetch_commands(self):
        with self.client.result_to(self._receive_commands):
            self.client.get_commands(self.app_name)
    
    def _receive_commands(self, commands):
        self.commands = [ self.CommandInfos(**infos) for infos in commands[self.app_name] ]
        self._build_ui()
        
    def _build_ui(self):
        for c in self.commands:
            b = QtGui.QPushButton(c.label, self)
            b.connect(b, QtCore.SIGNAL('clicked()'), lambda c=c:self.on_command(c))
            if c.icon is not None:
                b.setIcon(c.icon)
            self.layout().addWidget(b)
        self.layout().addStretch()
        self.waitter.hide()

    def on_command(self, command):
        with self.client.result_to(self.on_result):
            self.client.apps[self.app_name][command.name]()
#        event = Event(
#            ['GUI', self.app_name, command.name], 
#            Event.TYPE.UPDATED, 
#            'this_is_a_fake'
#        )
#        self.client.emit_app_event(event)

    def on_result(self, result):
        self.client.send_event(
            Event(['GUI', self.__class__.__name__]+['result'], Event.TYPE.MESSAGE, result)
        )

    def on_timeout(self):
        print '--------- COMMAND TIMED OUT!!!!'

class CmdsAppView(AppView):
    def fetch_commands(self):
        with self.client.result_to(self._receive_commands):
            self.client.apps['CMDS'].ls()

    def _receive_commands(self, commands):
        class Wrapper:
            def __init__(self, c):
                self.cmd_id = c
                self.name = c
                self.label = c
                self.icon = None
        self.commands = [ Wrapper(c) for c in commands ]
        self._build_ui()

    def on_command(self, command):
        with self.client.result_to(self.on_result):
            self.client.apps['CMDS'].run(cmd_id=command.cmd_id)

class ListenerView(AbstractView):
    def __init__(self, parent, client, app_name):
        super(ListenerView, self).__init__(parent, client, app_name)

        self.setLayout(QtGui.QVBoxLayout())
        self.t = QtGui.QTextEdit(self)
        self.t.setReadOnly(True)
        self.t.setLineWrapMode(self.t.NoWrap)
        self.layout().addWidget(self.t)

        self.client.add_event_handler(self.on_event, [])
        self.t.append('Listener Ready')
        
    def on_event(self, event):
        txt = '%s %r: %r'%(event.etype, event.path, event.data)
        self.t.append(txt)

class ConnectionView(AbstractView):
    def __init__(self, parent, client, app_name):
        super(ConnectionView, self).__init__(parent, client, app_name)

        self.setLayout(QtGui.QVBoxLayout())
        
        for tool in (
            'ping_apphost', 'ping_project', 
            None,
            'kill_apphost', 'reconnect', 
            None,
            'test_naming',
            ):
            if not tool:
                self._add_space()
            else:
                self._add_button(tool)
        self.layout().addStretch()

    def _add_space(self):
        self.layout().addSpacing(16)
        
    def _add_button(self, tool_name):
        b = QtGui.QPushButton(tool_name, self)
        b.connect(b, QtCore.SIGNAL('clicked()'), getattr(self, tool_name))
        self.layout().addWidget(b)

    def send_message(self, msg, path=[]):
        self.client.send_event(
            Event(['GUI', self.__class__.__name__]+path, Event.TYPE.MESSAGE, msg)
        )
        
    def ping_apphost(self):
        pong = self.client.apphost.ping()
        self.send_message(pong, ['ping_apphost'])
        
    def ping_project(self):
        pong = self.client.apphost.ping_project()
        self.send_message(pong, ['ping_project'])
        
    def kill_apphost(self):
        self.client.kill_apphost()
        self.send_message('Done', ['kill_apphost'])

    def reconnect(self):
        pong = self.client.connect()
        self.send_message('Done', ['reconnect', pong])

    def test_naming(self):
        msg = 'get shot root names'
        on_result = lambda result, msg=msg: self.on_result([msg, result])
        with self.client.result_to(on_result):
            self.client.apps.NAMING.get_root_names()
        
        
        msg = 'get shot config keys'
        on_result = lambda result, msg=msg: self.on_result([msg, result])
        with self.client.result_to(on_result):
            self.client.apps.NAMING.get_keys_for(root_name='WORK', type_name='TaskFolder')
    
        msg = 'get shot path'
        on_result = lambda result, msg=msg: self.on_result([msg, result])
        with self.client.result_to(on_result):
            self.client.apps.NAMING.get_path(
                root_name='WORK', config={
                    'Shot': 'P002', 
                    'Seq': 'S01', 
                    'Dept': 'Anim', 
                    'Types': 'Export_Cam', 
                    'Film': 'Film',
                }
            )

        msg = 'get config'
        on_result = lambda result, msg=msg: self.on_result([msg, result])
        with self.client.result_to(on_result):
            self.client.apps.NAMING.get_config(
                root_name='WORK', path='Film/Export/S01/P002/Anim/Film_S01_P002-Anim-Export_Cam'
            )
    
    def on_result(self, result):
        self.send_message('  RESULT: %r'%(result,))
        

