
import sys
from setuptools import setup


# (
#    (Major, Minor, [Micros]),
#    [(Alpha/Beta/rc marker, version)],
# )
__version_info__ = ((0, 1, 0), ('b', 3))

def get_version():
    global __version_info__
    return (
        '.'.join(str(x) for x in __version_info__[0]) 
        +''.join(str(x) for x in __version_info__[1])
    )
        
if not hasattr(sys, 'version_info') or sys.version_info < (2, 6, 0, 'final'):
    raise SystemExit("Kabaret requires Python 2.6 or later.")

install_requires = []

setup(
    name='kabaret',
    packages=['kabaret'],
    version=get_version(),
    install_requires=install_requires,
    description='Digital Creation Studio Framework',
    url='http://packages.python.org/kabaret',
    author='Damien Coureau',
    author_email='dee@dee909.com',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        
        'Topic :: Office/Business :: Groupware',
        'Topic :: Office/Business :: Scheduling',
        
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Information Technology',
        
        'Operating System :: OS Independent',
        
        'Programming Language :: Python :: 2.5',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
)