from datetime import datetime, timedelta
import tarfile
from plot.parser import parse_lines, LogParser


def parse(pr, infile, db, tablename):
    def parse_apache_timestamp(ts):
        # format 18/Jun/2013:03:00:08 +0000
        def timezone(zone):
            # format '+0000'
            return timedelta(hours= int(zone[:3]), minutes= int(zone[:1]+zone[3:]))

        res = datetime.strptime(ts[:-6], '%d/%b/%Y:%H:%M:%S')
        return (res + timezone(ts[-5:])).strftime('%s%f')[:13]

    def ms_since_epoch(**kw_args):
        return parse_apache_timestamp(kw_args['timestamp'])

    callbacks = { 'ms_since_epoch': ms_since_epoch }

    # parse the data from the logfiles
    access = LogParser(pr.compile_regex('%{COMBINEDAPACHELOG}'), callbacks, db, tablename)
    parse_lines([access], infile)


def populate(pr, filename, db, testrun, tablename):
    with tarfile.open(filename, mode="r:gz") as tar:
        # read in all access logfiles
        for tarinfo in tar:
            if tarinfo.isreg():
                print 'working on %s' % tarinfo
                infile = tar.extractfile(tarinfo.name)
                parse(pr, infile, db, tablename)


def query(db, tablename, arguments=[]):
    c = db.cursor()
    c.execute('select * from %s order by ms_since_epoch' % tablename)

    rows = c.fetchall()
    headers = tuple([h[0] for h in c.description])
    c.close()
    return [headers] + rows
