from datetime import datetime, timedelta
import tarfile
from plot.parser import parse_lines, LogParser


def parse(pr, infile, db, tablename):
    def parse_load_timestamp(ts):
        # format 2013-07-18T15:34:38.648+0200
        def timezone(zone):
            # format '+0000'
            return timedelta(hours= int(zone[:3]), minutes= int(zone[:1]+zone[3:]))

        res = datetime.strptime(ts[:-5], '%Y-%m-%dT%H:%M:%S.%f')
        return (res + timezone(ts[-5:])).strftime('%s%f')[:13]

    def ms_since_epoch(**kw_args):
        return parse_load_timestamp(kw_args['timestamp'])

    # def ms_since_epoch(logstart, interval):
    #     # helper to create a generator for adding timestamps to
    #     # parsed loglines
    #     # workaround to implement missing closure
    #     nonlocal = {
    #         'logstart': logstart,
    #         'interval': int(interval)
    #         }

    #     def gen(**kw_args):
    #         nonlocal['logstart'] += timedelta(
    #             seconds=nonlocal['interval'])
    #         return nonlocal['logstart'].strftime('%s%f')[:13]
    #     return gen

    # read logstart and interval from file
    # match = pr.compile_regex('%{COUNTER_START}').match(
    #     infile.readline()).groupdict()

    callbacks = { 'ms_since_epoch': ms_since_epoch }

    # parse the data from the logfiles
    load = LogParser(pr.compile_regex('%{AOGAERU_LOAD}'), callbacks, db, tablename)
    # discard = LogParser(pr.compile_regex('%{LINUX_VMSTAT_DISCARD}'))
    parse_lines([load], infile)


def populate(pr, filename, db, testrun, tablename):
    with tarfile.open(filename, mode="r:gz") as tar:
        infile = tar.extractfile('results.csv')
        parse(pr, infile, db, tablename)


def query(db, tablename, arguments=[]):
    c = db.cursor()
    c.execute('select * from %s order by ms_since_epoch' % tablename)

    rows = c.fetchall()
    headers = tuple([h[0] for h in c.description])
    c.close()
    return [headers] + rows
